/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.config.FoProcessor;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.URIUtils;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class XSLFormatter
extends DefaultStep {
    private static final QName _href = new QName("", "href");
    private static final QName _content_type = new QName("", "content-type");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private Properties options = new Properties();

    public XSLFormatter(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void setParameter(QName qName, RuntimeValue runtimeValue) {
        if (!"".equals(qName.getNamespaceURI())) {
            throw new XProcException(this.step.getNode(), "The p:xsl-formatter parameters are in no namespace: " + qName + " (" + qName.getNamespaceURI() + ")");
        }
        this.options.setProperty(qName.getLocalName(), runtimeValue.getString());
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        String string2;
        super.run();
        Vector<String> vector = new Vector<String>();
        if (this.runtime.getConfiguration().foProcessor != null) {
            vector.add(this.runtime.getConfiguration().foProcessor);
        }
        vector.add("com.xmlcalabash.util.FoFOP");
        FoProcessor foProcessor = null;
        for (String string2 : vector) {
            if (foProcessor != null) continue;
            try {
                foProcessor = (FoProcessor)Class.forName(string2).newInstance();
                foProcessor.initialize(this.runtime, this.step, this.options);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                foProcessor = null;
            }
            catch (Exception exception) {
                foProcessor = null;
            }
        }
        if (foProcessor == null) {
            throw new XProcException(this.step.getNode(), "Failed to instantiate FO provider");
        }
        Object object = null;
        if (this.getOption(_content_type) != null) {
            object = this.getOption(_content_type).getString();
        }
        string2 = this.getOption(_href).getBaseURI().resolve(this.getOption(_href).getString()).toASCIIString();
        String string3 = null;
        if (!string2.startsWith("file:/")) {
            throw new XProcException(this.step.getNode(), "Don't know how to write p:xsl-formatter output to " + string2);
        }
        string3 = URIUtils.getFile(string2).getPath();
        OutputStream outputStream = null;
        try {
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(string3));
                foProcessor.format(this.source.read(), outputStream, (String)object);
            }
            catch (XProcException xProcException) {
                throw xProcException;
            }
            catch (Exception exception) {
                throw new XProcException(this.step.getNode(), "Failed to process FO document", (Throwable)exception);
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(XProcConstants.c_result);
        treeWriter.startContent();
        treeWriter.addText(string2);
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }
}

