/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.core.XProcStep;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadableDocument;
import com.xmlcalabash.io.ReadableInline;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.ComputableValue;
import com.xmlcalabash.model.DataBinding;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.DocumentBinding;
import com.xmlcalabash.model.InlineBinding;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.NamespaceBinding;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Parameter;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.Port;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.SourceArtifact;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XCatch;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XInput;
import com.xmlcalabash.runtime.XOutput;
import com.xmlcalabash.runtime.XSelect;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TypeUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;

public class XAtomicStep
extends XStep {
    private static final QName _name = new QName("", "name");
    private static final QName _namespace = new QName("", "namespace");
    private static final QName _value = new QName("", "value");
    private static final QName _type = new QName("", "type");
    private static final QName cx_item = new QName("cx", "http://xmlcalabash.com/ns/extensions", "item");
    protected Hashtable<String, Vector<ReadablePipe>> inputs = new Hashtable();
    protected Hashtable<String, WritablePipe> outputs = new Hashtable();

    public XAtomicStep(XProcRuntime xProcRuntime, Step step, XCompoundStep xCompoundStep) {
        super(xProcRuntime, step);
        this.parent = xCompoundStep;
    }

    @Override
    public XCompoundStep getParent() {
        return this.parent;
    }

    @Override
    public RuntimeValue optionAvailable(QName qName) {
        if (!this.inScopeOptions.containsKey(qName)) {
            return null;
        }
        return (RuntimeValue)this.inScopeOptions.get(qName);
    }

    protected ReadablePipe getPipeFromBinding(Binding binding) {
        ReadablePipe readablePipe = null;
        if (binding.getBindingType() == 1) {
            PipeNameBinding pipeNameBinding = (PipeNameBinding)binding;
            XCompoundStep xCompoundStep = this.parent;
            if (this instanceof XCompoundStep) {
                xCompoundStep = (XCompoundStep)this;
            }
            readablePipe = xCompoundStep.getBinding(pipeNameBinding.getStep(), pipeNameBinding.getPort());
        } else if (binding.getBindingType() == 2) {
            InlineBinding inlineBinding = (InlineBinding)binding;
            readablePipe = new ReadableInline(this.runtime, inlineBinding.nodes(), inlineBinding.getExcludedNamespaces());
        } else if (binding.getBindingType() == 5) {
            readablePipe = new ReadableDocument(this.runtime);
        } else if (binding.getBindingType() == 3) {
            DocumentBinding documentBinding = (DocumentBinding)binding;
            readablePipe = this.runtime.getConfigurer().getXMLCalabashConfigurer().makeReadableDocument(this.runtime, documentBinding);
        } else if (binding.getBindingType() == 8) {
            DataBinding dataBinding = (DataBinding)binding;
            readablePipe = this.runtime.getConfigurer().getXMLCalabashConfigurer().makeReadableData(this.runtime, dataBinding);
        } else if (binding.getBindingType() == 7) {
            XCompoundStep xCompoundStep = this.parent;
            while (!(xCompoundStep instanceof XCatch)) {
                xCompoundStep = xCompoundStep.getParent();
            }
            readablePipe = xCompoundStep.getBinding(xCompoundStep.getName(), "error");
        } else {
            throw new XProcException(binding.getNode(), "Unknown binding type: " + binding.getBindingType());
        }
        readablePipe.setReader(this.step);
        return readablePipe;
    }

    protected void instantiateReaders(Step step) {
        for (Input input : step.inputs()) {
            String string = input.getPort();
            if (string.startsWith("|")) continue;
            Vector<Object> vector = null;
            if (this.inputs.containsKey(string)) {
                vector = this.inputs.get(string);
            } else {
                vector = new Vector();
                this.inputs.put(string, vector);
            }
            for (Binding binding : input.getBinding()) {
                ReadablePipe readablePipe = this.getPipeFromBinding(binding);
                readablePipe.canReadSequence(input.getSequence());
                if (input.getSelect() != null) {
                    this.finest(step.getNode(), step.getName() + " selects from " + readablePipe + " for " + string);
                    readablePipe = new XSelect(this.runtime, this, readablePipe, input.getSelect(), input.getNode());
                }
                vector.add(readablePipe);
                this.finest(step.getNode(), step.getName() + " reads from " + readablePipe + " for " + string);
            }
            XInput xInput = new XInput(this.runtime, input);
            this.addInput(xInput);
        }
    }

    @Override
    public void instantiate(Step step) {
        this.instantiateReaders(step);
        for (Output output : step.outputs()) {
            String string = output.getPort();
            XOutput xOutput = new XOutput(this.runtime, output);
            xOutput.setLogger(step.getLog(string));
            this.addOutput(xOutput);
            WritablePipe writablePipe = xOutput.getWriter();
            writablePipe.canWriteSequence(output.getSequence());
            this.outputs.put(string, writablePipe);
            this.finest(step.getNode(), step.getName() + " writes to " + writablePipe + " for " + string);
        }
        this.parent.addStep(this);
    }

    protected void computeParameters(XProcStep xProcStep) throws SaxonApiException {
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        for (Input input : this.step.inputs()) {
            if (!input.getParameterInput()) continue;
            bl |= input.getPrimary();
            vector.add(input.getPort());
        }
        int n = 0;
        boolean bl2 = false;
        while (!bl2) {
            Object object;
            ++n;
            bl2 = true;
            for (Parameter parameter : this.step.parameters()) {
                if ("http://www.w3.org/ns/xproc".equals(parameter.getName().getNamespaceURI())) {
                    throw XProcException.dynamicError(31);
                }
                boolean bl3 = bl2 = parameter.getPosition() <= n;
                if (parameter.getPosition() != n) continue;
                bl2 = false;
                if (!bl) {
                    object = parameter.getPort();
                    if (object == null) {
                        throw XProcException.staticError(34, this.step.getNode(), "No parameter input port.");
                    }
                    xProcStep.setParameter(parameter.getPort(), parameter.getName(), this.computeValue(parameter));
                    continue;
                }
                xProcStep.setParameter(parameter.getName(), this.computeValue(parameter));
            }
            for (String string : vector) {
                object = this.step.getInput(string);
                boolean bl4 = bl2 = bl2 && ((Input)object).getPosition() <= n;
                if (((Input)object).getPosition() != n) continue;
                for (ReadablePipe readablePipe : this.inputs.get(string)) {
                    while (readablePipe.moreDocuments()) {
                        XdmNode xdmNode = readablePipe.read();
                        XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
                        if (XProcConstants.c_param_set.equals((Object)xdmNode2.getNodeName())) {
                            for (XdmNode xdmNode3 : new RelevantNodes(this.runtime, xdmNode2, Axis.ATTRIBUTE)) {
                                QName qName = xdmNode3.getNodeName();
                                if (!"".equals(qName.getNamespaceURI()) && !"http://www.w3.org/ns/xproc".equals(qName.getNamespaceURI())) continue;
                                throw XProcException.dynamicError(14, this.step.getNode(), "Attribute not allowed");
                            }
                            for (XdmNode xdmNode3 : new RelevantNodes(this.runtime, xdmNode2, Axis.CHILD)) {
                                if (xdmNode3.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                                if (!xdmNode3.getNodeName().equals((Object)XProcConstants.c_param)) {
                                    throw XProcException.dynamicError(18, this.step.getNode(), "Element not allowed: " + xdmNode3.getNodeName());
                                }
                                this.parseParameterNode(xProcStep, xdmNode3);
                            }
                            continue;
                        }
                        if (XProcConstants.c_param.equals((Object)xdmNode2.getNodeName())) {
                            this.parseParameterNode(xProcStep, xdmNode2);
                            continue;
                        }
                        throw new XProcException(this.step.getNode(), xdmNode2.getNodeName() + " found where c:param or c:param-set expected");
                    }
                }
            }
        }
    }

    @Override
    public void reset() {
        for (String string : this.inputs.keySet()) {
            for (ReadablePipe readablePipe : this.inputs.get(string)) {
                readablePipe.resetReader();
            }
        }
        for (String string : this.outputs.keySet()) {
            WritablePipe writablePipe = this.outputs.get(string);
            writablePipe.resetWriter();
        }
        this.clearOptions();
        this.clearParameters();
    }

    @Override
    public void run() throws SaxonApiException {
        Object object;
        QName qName;
        Object object2;
        Object object3;
        XProcStep xProcStep = this.runtime.getConfiguration().newStep(this.runtime, this);
        for (String iterator2 : this.inputs.keySet()) {
            int n = 0;
            object3 = this.step.getInput(iterator2);
            if (!((Input)object3).getParameterInput()) {
                int n2 = this.inputs.get(iterator2).size();
                if (n2 > 1) {
                    object2 = new Pipe(this.runtime);
                    ((Pipe)object2).setWriter(this.step);
                    ((Pipe)object2).setReader(this.step);
                    ((Pipe)object2).canWriteSequence(true);
                    ((Pipe)object2).canReadSequence(((Port)object3).getSequence());
                    for (ReadablePipe readablePipe : this.inputs.get(iterator2)) {
                        if (readablePipe.moreDocuments()) {
                            while (readablePipe.moreDocuments()) {
                                qName = readablePipe.read();
                                ((Pipe)object2).write((XdmNode)qName);
                                ++n;
                            }
                            continue;
                        }
                        if (!(readablePipe instanceof ReadableDocument)) continue;
                        ++n;
                    }
                    xProcStep.setInput(iterator2, (ReadablePipe)object2);
                } else if (n2 == 1) {
                    object2 = this.inputs.get(iterator2).firstElement();
                    object2.setReader(this.step);
                    if (object2.moreDocuments()) {
                        n += object2.documentCount();
                    } else if (object2 instanceof ReadableDocument) {
                        ++n;
                    }
                    xProcStep.setInput(iterator2, (ReadablePipe)object2);
                }
            }
            if (n == true || ((Port)object3).getSequence()) continue;
            throw XProcException.dynamicError(6, this.step.getNode(), n + " documents appear on the '" + iterator2 + "' port.");
        }
        for (String string : this.outputs.keySet()) {
            xProcStep.setOutput(string, this.outputs.get(string));
        }
        DeclareStep declareStep = this.step.getDeclaration();
        this.inScopeOptions = this.parent.getInScopeOptions();
        for (QName qName2 : this.step.getOptions()) {
            object3 = this.step.getOption(qName2);
            RuntimeValue runtimeValue = this.computeValue((ComputableValue)object3);
            object2 = declareStep.getOption(qName2);
            object = ((Option)object2).getType();
            XdmNode xdmNode = ((SourceArtifact)object2).getNode();
            if (object != null && xdmNode != null) {
                if (((String)object).contains("|")) {
                    TypeUtils.checkLiteral(runtimeValue.getString(), (String)object);
                } else {
                    qName = new QName((String)object, xdmNode);
                    TypeUtils.checkType(this.runtime, runtimeValue.getString(), qName, ((SourceArtifact)object3).getNode());
                }
            }
            xProcStep.setOption(qName2, runtimeValue);
            this.inScopeOptions.put(qName2, runtimeValue);
        }
        xProcStep.reset();
        this.computeParameters(xProcStep);
        if (XProcConstants.p_in_scope_names.equals((Object)this.step.getType())) {
            for (QName qName3 : this.inScopeOptions.keySet()) {
                xProcStep.setParameter(qName3, (RuntimeValue)this.inScopeOptions.get(qName3));
            }
        }
        XProcData xProcData = this.runtime.getXProcData();
        xProcData.openFrame(this);
        xProcStep.run();
        String string = this.getInheritedExtensionAttribute(XProcConstants.cx_cache);
        if ("true".equals(string)) {
            for (String string2 : this.outputs.keySet()) {
                object2 = this.outputs.get(string2);
                if (!(object2 instanceof Pipe)) continue;
                object = new Pipe(this.runtime, ((Pipe)object2).documents());
                object.canReadSequence(true);
                object.setReader(this.step);
                while (object.moreDocuments()) {
                    XdmNode xdmNode = object.read();
                    this.runtime.cache(xdmNode, this.step.getNode().getBaseURI());
                }
            }
        } else if (!"false".equals(string) && string != null) {
            throw XProcException.dynamicError(19);
        }
        for (String string3 : this.outputs.keySet()) {
            object2 = this.outputs.get(string3);
            object2.close();
        }
        xProcData.closeFrame();
    }

    public void reportError(XdmNode xdmNode) {
        this.parent.reportError(xdmNode);
    }

    private void parseParameterNode(XProcStep xProcStep, XdmNode xdmNode) {
        String string = xdmNode.getAttributeValue(_value);
        if (string == null && this.runtime.getAllowGeneralExpressions()) {
            this.parseParameterValueNode(xProcStep, xdmNode);
            return;
        }
        Parameter parameter = new Parameter(this.step.getXProc(), xdmNode);
        String string2 = parameter.getPort();
        String string3 = xdmNode.getAttributeValue(_name);
        String string4 = xdmNode.getAttributeValue(_namespace);
        QName qName = null;
        if (string4 == null) {
            qName = new QName(string3, xdmNode);
        } else {
            QName qName2;
            int n = string3.indexOf(":");
            if (n > 0 && !string4.equals((qName2 = new QName(string3 = string3.substring(n), xdmNode)).getNamespaceURI())) {
                throw XProcException.dynamicError(25);
            }
            qName = new QName(string4, string3);
        }
        if ("http://www.w3.org/ns/xproc".equals(qName.getNamespaceURI())) {
            throw XProcException.dynamicError(31);
        }
        parameter.setName(qName);
        for (QName qName2 : new RelevantNodes(this.runtime, xdmNode, Axis.ATTRIBUTE)) {
            QName qName3 = qName2.getNodeName();
            if (!"".equals(qName3.getNamespaceURI()) || qName3.equals((Object)_name) || qName3.equals((Object)_namespace) || qName3.equals((Object)_value)) continue;
            throw XProcException.dynamicError(14);
        }
        if (string2 != null) {
            xProcStep.setParameter(string2, qName, new RuntimeValue(string, xdmNode));
        } else {
            xProcStep.setParameter(qName, new RuntimeValue(string, xdmNode));
        }
    }

    private void parseParameterValueNode(XProcStep xProcStep, XdmNode xdmNode) {
        Object object;
        Object object22;
        Parameter parameter = new Parameter(this.step.getXProc(), xdmNode);
        String string = parameter.getPort();
        String string2 = xdmNode.getAttributeValue(_name);
        String string3 = xdmNode.getAttributeValue(_namespace);
        QName qName = null;
        if (string3 == null) {
            qName = new QName(string2, xdmNode);
        } else {
            int n = string2.indexOf(":");
            if (n > 0 && !string3.equals((object22 = new QName(string2 = string2.substring(n), xdmNode)).getNamespaceURI())) {
                throw XProcException.dynamicError(25);
            }
            qName = new QName(string3, string2);
        }
        parameter.setName(qName);
        for (Object object22 : new RelevantNodes(this.runtime, xdmNode, Axis.ATTRIBUTE)) {
            object = object22.getNodeName();
            if (!"".equals(object.getNamespaceURI()) || object.equals((Object)_name) || object.equals((Object)_namespace)) continue;
            throw XProcException.dynamicError(14);
        }
        Object object3 = "";
        object22 = new Vector();
        for (XdmNode xdmNode2 : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
            if (xdmNode2.getNodeKind() != XdmNodeKind.ELEMENT) continue;
            if (!xdmNode2.getNodeName().equals((Object)cx_item)) {
                throw XProcException.dynamicError(18, this.step.getNode(), "Element not allowed: " + xdmNode2.getNodeName());
            }
            String string4 = xdmNode2.getAttributeValue(_type);
            if (string4 == null) {
                XdmNode xdmNode3;
                Vector<XdmValue> vector = new Vector<XdmValue>();
                URI uRI = null;
                XdmSequenceIterator xdmSequenceIterator = xdmNode2.axisIterator(Axis.CHILD);
                while (xdmSequenceIterator.hasNext()) {
                    xdmNode3 = (XdmNode)xdmSequenceIterator.next();
                    if (uRI == null && xdmNode3.getNodeKind() == XdmNodeKind.ELEMENT) {
                        uRI = xdmNode3.getBaseURI();
                    }
                    vector.add((XdmValue)xdmNode3);
                }
                xdmNode3 = new XdmDestination();
                try {
                    if (uRI == null) {
                        uRI = new URI("http://example.com/");
                    }
                    S9apiUtils.writeXdmValue(this.runtime.getProcessor(), vector, (Destination)xdmNode3, uRI);
                    XdmNode xdmNode4 = xdmNode3.getXdmNode();
                    object3 = (String)object3 + xdmNode4.getStringValue();
                    ((Vector)object22).add(xdmNode4);
                    continue;
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new XProcException(uRISyntaxException);
                }
                catch (SaxonApiException saxonApiException) {
                    throw new XProcException(saxonApiException);
                }
            }
            object3 = (String)object3 + xdmNode2.getStringValue();
            ((Vector)object22).add(new XdmAtomicValue(xdmNode2.getStringValue()));
        }
        object = new RuntimeValue((String)object3, (Vector<XdmItem>)object22, xdmNode, new Hashtable<String, String>());
        if (string != null) {
            xProcStep.setParameter(string, qName, (RuntimeValue)object);
        } else {
            xProcStep.setParameter(qName, (RuntimeValue)object);
        }
    }

    protected RuntimeValue computeValue(ComputableValue computableValue) {
        String string;
        Object object;
        String string22;
        Object object2;
        Object saxonApiException;
        Object object3;
        Object object7;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable hashtable2 = this.inScopeOptions;
        XdmNode xdmNode = null;
        try {
            if (computableValue.getBinding().size() > 0) {
                object7 = computableValue.getBinding().firstElement();
                ReadablePipe vector2 = this.getPipeFromBinding((Binding)object7);
                xdmNode = vector2.read();
                if (vector2.moreDocuments()) {
                    throw XProcException.dynamicError(this.step, 8, "More than one document in context for parameter '" + computableValue.getName() + "'");
                }
            }
        }
        catch (SaxonApiException saxonApiException2) {
            throw new XProcException(saxonApiException2);
        }
        for (NamespaceBinding namespaceBinding : computableValue.getNamespaceBindings()) {
            object3 = new Hashtable();
            if (namespaceBinding.getBinding() != null) {
                saxonApiException = new QName(namespaceBinding.getBinding(), namespaceBinding.getNode());
                object2 = (RuntimeValue)hashtable2.get(saxonApiException);
                if (object2 == null) {
                    throw new XProcException(computableValue.getNode(), "No in-scope option or variable named: " + saxonApiException);
                }
                object3 = ((RuntimeValue)object2).getNamespaceBindings();
            } else if (namespaceBinding.getXPath() != null) {
                try {
                    saxonApiException = this.runtime.getProcessor().newXPathCompiler();
                    saxonApiException.setBaseURI(this.step.getNode().getBaseURI());
                    for (QName qName : hashtable2.keySet()) {
                        saxonApiException.declareVariable(qName);
                    }
                    object2 = saxonApiException.compile(namespaceBinding.getXPath());
                    XPathSelector xPathSelector = object2.load();
                    for (QName qName : hashtable2.keySet()) {
                        string22 = new XdmAtomicValue(((RuntimeValue)hashtable2.get(qName)).getString());
                        xPathSelector.setVariable(qName, (XdmValue)string22);
                    }
                    if (xdmNode != null) {
                        xPathSelector.setContextItem((XdmItem)xdmNode);
                    }
                    object = null;
                    for (String string22 : xPathSelector) {
                        if (object != null || string22.isAtomicValue()) {
                            throw XProcException.dynamicError(9);
                        }
                        object = (XdmNode)string22;
                        if (object.getNodeKind() == XdmNodeKind.ELEMENT) continue;
                        throw XProcException.dynamicError(9);
                    }
                    if (object == null) {
                        throw XProcException.dynamicError(9);
                    }
                    string22 = object.axisIterator(Axis.NAMESPACE);
                    while (string22.hasNext()) {
                        string = (XdmNode)string22.next();
                        ((Hashtable)object3).put(string.getNodeName().getLocalName(), string.getStringValue());
                    }
                }
                catch (SaxonApiException saxonApiException3) {
                    throw new XProcException(saxonApiException3);
                }
            } else if (namespaceBinding.getNamespaceBindings() != null) {
                object3 = namespaceBinding.getNamespaceBindings();
            }
            saxonApiException = new HashSet();
            for (String string3 : namespaceBinding.getExcludedNamespaces()) {
                for (String string4 : ((Hashtable)object3).keySet()) {
                    if (!string3.equals(((Hashtable)object3).get(string4))) continue;
                    ((HashSet)saxonApiException).add(string4);
                }
            }
            object2 = ((HashSet)saxonApiException).iterator();
            while (object2.hasNext()) {
                String string5 = (String)object2.next();
                ((Hashtable)object3).remove(string5);
            }
            object2 = ((Hashtable)object3).keySet().iterator();
            while (object2.hasNext()) {
                String string6 = (String)object2.next();
                if (hashtable.containsKey(string6) && !hashtable.get(string6).equals(((Hashtable)object3).get(string6))) {
                    throw XProcException.dynamicError(13);
                }
                hashtable.put(string6, (String)((Hashtable)object3).get(string6));
            }
        }
        object7 = computableValue.getSelect();
        Vector<XdmItem> vector = this.evaluateXPath(xdmNode, hashtable, (String)object7, hashtable2);
        object3 = "";
        try {
            saxonApiException = vector.iterator();
            while (saxonApiException.hasNext()) {
                object2 = (XdmItem)saxonApiException.next();
                if (object2.isAtomicValue()) {
                    object3 = object3 + object2.getStringValue();
                    continue;
                }
                XdmNode xdmNode2 = (XdmNode)object2;
                if (xdmNode2.getNodeKind() == XdmNodeKind.ATTRIBUTE) {
                    object3 = (String)object3 + xdmNode2.getStringValue();
                    continue;
                }
                object = new XdmDestination();
                S9apiUtils.writeXdmValue(this.runtime, (XdmItem)object2, (Destination)object, null);
                object3 = (String)object3 + object.getXdmNode().getStringValue();
            }
        }
        catch (SaxonApiUncheckedException saxonApiUncheckedException) {
            object2 = saxonApiUncheckedException.getCause();
            if (object2 instanceof XPathException) {
                XPathException xPathException = (XPathException)((Object)object2);
                if ("http://www.w3.org/2005/xqt-errors".equals(xPathException.getErrorCodeNamespace()) && "XPDY0002".equals(xPathException.getErrorCodeLocalPart())) {
                    throw XProcException.dynamicError(26, this.step.getNode(), "The expression for $" + computableValue.getName() + " refers to the context item.");
                }
                throw saxonApiUncheckedException;
            }
            throw saxonApiUncheckedException;
        }
        catch (SaxonApiException saxonApiException4) {
            throw new XProcException(saxonApiException4);
        }
        if (computableValue.getType() != null) {
            saxonApiException = computableValue.getType();
            if (((String)saxonApiException).contains("|")) {
                TypeUtils.checkLiteral(object3, (String)saxonApiException);
            } else if (((String)saxonApiException).contains(":")) {
                TypeUtils.checkType(this.runtime, (String)object3, computableValue.getTypeAsQName(), computableValue.getNode());
            }
        }
        if (((Matcher)(object2 = ((Pattern)(saxonApiException = Pattern.compile("^\\s*\\$([^\\s=]+)\\s*$"))).matcher((CharSequence)object7))).matches()) {
            String string7 = ((Matcher)object2).group(1);
            object = null;
            if (string7.contains(":")) {
                String string8 = string7.substring(0, string7.indexOf(":"));
                string22 = string7.substring(string7.indexOf(":") + 1);
                string = hashtable.get(string8);
                object = new QName(string8, string, string22);
            } else {
                object = new QName("", string7);
            }
            RuntimeValue runtimeValue = (RuntimeValue)hashtable2.get(object);
            hashtable = runtimeValue.getNamespaceBindings();
        }
        if (vector.size() > 0 && vector.get(0) instanceof XdmNode) {
            XdmNode xdmNode3 = (XdmNode)vector.get(0);
            hashtable.clear();
            object = xdmNode3.axisIterator(Axis.NAMESPACE);
            while (object.hasNext()) {
                XdmNode xdmNode4 = (XdmNode)object.next();
                hashtable.put(xdmNode4.getNodeName() == null ? "" : xdmNode4.getNodeName().getLocalName(), xdmNode4.getStringValue());
            }
        }
        if (this.runtime.getAllowGeneralExpressions()) {
            return new RuntimeValue((String)object3, vector, computableValue.getNode(), hashtable);
        }
        return new RuntimeValue((String)object3, computableValue.getNode(), hashtable);
    }

    protected Vector<XdmItem> evaluateXPath(XdmNode xdmNode, Hashtable<String, String> hashtable, String string, Hashtable<QName, RuntimeValue> hashtable2) {
        Vector<XdmItem> vector = new Vector<XdmItem>();
        Hashtable<QName, RuntimeValue> hashtable3 = new Hashtable<QName, RuntimeValue>();
        for (QName object2 : hashtable2.keySet()) {
            RuntimeValue runtimeValue = hashtable2.get(object2);
            if (!runtimeValue.initialized()) continue;
            hashtable3.put(object2, runtimeValue);
        }
        try {
            XPathException xPathException;
            XPathExecutable xPathExecutable;
            XPathCompiler xPathCompiler = this.runtime.getProcessor().newXPathCompiler();
            xPathCompiler.setBaseURI(this.step.getNode().getBaseURI());
            for (QName qName : hashtable3.keySet()) {
                xPathCompiler.declareVariable(qName);
            }
            for (String string2 : hashtable.keySet()) {
                xPathCompiler.declareNamespace(string2, hashtable.get(string2));
            }
            Object var8_12 = null;
            try {
                xPathExecutable = xPathCompiler.compile(string);
            }
            catch (SaxonApiException saxonApiException) {
                XPathException xPathException2;
                Throwable throwable = saxonApiException.getCause();
                if (throwable instanceof XPathException && (xPathException2 = (XPathException)throwable).getMessage().contains("Undeclared (or unbound?) variable")) {
                    throw XProcException.dynamicError(26, this.step.getNode(), xPathException2.getMessage());
                }
                throw saxonApiException;
            }
            XPathSelector xPathSelector = xPathExecutable.load();
            for (Object object : hashtable3.keySet()) {
                xPathException = null;
                RuntimeValue runtimeValue = (RuntimeValue)hashtable3.get(object);
                xPathException = this.runtime.getAllowGeneralExpressions() && runtimeValue.hasGeneralValue() ? runtimeValue.getValue() : runtimeValue.getUntypedAtomic(this.runtime);
                xPathSelector.setVariable(object, (XdmValue)xPathException);
            }
            if (xdmNode != null) {
                xPathSelector.setContextItem((XdmItem)xdmNode);
            }
            try {
                Iterator iterator = xPathSelector.iterator();
                while (iterator.hasNext()) {
                    vector.add((XdmItem)iterator.next());
                }
            }
            catch (SaxonApiUncheckedException saxonApiUncheckedException) {
                Object object;
                object = saxonApiUncheckedException.getCause();
                if (object instanceof XPathException) {
                    xPathException = (XPathException)((Object)object);
                    if ("http://www.w3.org/2005/xqt-errors".equals(xPathException.getErrorCodeNamespace()) && "XPDY0002".equals(xPathException.getErrorCodeLocalPart())) {
                        throw XProcException.dynamicError(26, this.step.getNode(), "Expression refers to context when none is available: " + string);
                    }
                    throw saxonApiUncheckedException;
                }
                throw saxonApiUncheckedException;
            }
        }
        catch (SaxonApiException saxonApiException) {
            if (S9apiUtils.xpathSyntaxError(saxonApiException)) {
                throw XProcException.dynamicError(23, this.step.getNode(), saxonApiException.getCause().getMessage());
            }
            throw new XProcException(saxonApiException);
        }
        return vector;
    }
}

