/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.xmlcalabash.config.JingConfigurer;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidateJing
extends DefaultStep {
    private static final QName _assert_valid = new QName("", "assert-valid");
    private static final QName _dtd_attribute_values = new QName("", "dtd-attribute-values");
    private static final QName _dtd_id_idref_warnings = new QName("", "dtd-id-idref-warnings");
    private static final QName _encoding = new QName("encoding");
    private static final QName _line = new QName("line");
    private static final QName _column = new QName("column");
    private ReadablePipe source = null;
    private ReadablePipe schemaSource = null;
    private WritablePipe result = null;
    private URI docBaseURI = null;

    public ValidateJing(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.source = readablePipe;
        } else if ("schema".equals(string)) {
            this.schemaSource = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        XdmNode xdmNode;
        block11: {
            StringReader stringReader;
            super.run();
            boolean bl = this.getOption(_assert_valid, true);
            boolean bl2 = this.getOption(_dtd_id_idref_warnings, false);
            boolean bl3 = this.getOption(_dtd_attribute_values, false);
            RNGErrorHandler rNGErrorHandler = new RNGErrorHandler();
            PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
            propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, (Object)rNGErrorHandler);
            propertyMapBuilder.put(ValidateProperty.URI_RESOLVER, (Object)this.runtime.getResolver());
            propertyMapBuilder.put(ValidateProperty.ENTITY_RESOLVER, (Object)this.runtime.getResolver());
            if (bl2) {
                RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
            }
            xdmNode = this.source.read();
            XdmNode xdmNode2 = this.schemaSource.read();
            XdmNode xdmNode3 = S9apiUtils.getDocumentElement(xdmNode2);
            this.docBaseURI = xdmNode.getBaseURI();
            SchemaReader schemaReader = null;
            boolean bl4 = XProcConstants.c_data.equals((Object)xdmNode3.getNodeName());
            String string = xdmNode3.getAttributeValue(XProcConstants.c_content_type);
            if (string != null) {
                bl4 |= string.startsWith("text/") || string.equals("application/relax-ng-compact-syntax");
            }
            InputSource inputSource = null;
            JingConfigurer jingConfigurer = this.runtime.getConfigurer().getJingConfigurer();
            if (bl4) {
                jingConfigurer.configRNC(propertyMapBuilder);
                schemaReader = CompactSchemaReader.getInstance();
                stringReader = new StringReader(this.compactSchema(xdmNode3));
                inputSource = new InputSource(stringReader);
                inputSource.setSystemId(xdmNode3.getBaseURI().toASCIIString());
            } else {
                jingConfigurer.configRNG(propertyMapBuilder);
                schemaReader = new AutoSchemaReader();
                inputSource = S9apiUtils.xdmToInputSource(this.runtime, xdmNode2);
            }
            stringReader = new ValidationDriver(propertyMapBuilder.toPropertyMap(), schemaReader);
            try {
                if (stringReader.loadSchema(inputSource)) {
                    InputSource inputSource2 = S9apiUtils.xdmToInputSource(this.runtime, xdmNode);
                    if (!stringReader.validate(inputSource2) && bl) {
                        throw XProcException.stepError(53);
                    }
                    break block11;
                }
                throw new XProcException(this.step.getNode(), "Error loading schema");
            }
            catch (SAXParseException sAXParseException) {
                if (bl) {
                    throw XProcException.stepError(53);
                }
            }
            catch (SAXException sAXException) {
                throw new XProcException("SAX Exception", (Throwable)sAXException);
            }
            catch (IOException iOException) {
                throw new XProcException("IO Exception", (Throwable)iOException);
            }
        }
        this.result.write(xdmNode);
    }

    private String compactSchema(XdmNode xdmNode) {
        if ("base64".equals(xdmNode.getAttributeValue(_encoding))) {
            byte[] byArray = Base64.decode(xdmNode.getStringValue());
            String string = new String(byArray);
            return string;
        }
        return xdmNode.getStringValue();
    }

    class RNGErrorHandler
    implements ErrorHandler {
        SAXParseException err = null;

        RNGErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.error(sAXParseException);
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            TreeWriter treeWriter = new TreeWriter(ValidateJing.this.runtime);
            treeWriter.startDocument(ValidateJing.this.docBaseURI);
            treeWriter.addStartElement(XProcConstants.c_error);
            if (sAXParseException.getLineNumber() != -1) {
                treeWriter.addAttribute(_line, "" + sAXParseException.getLineNumber());
            }
            if (sAXParseException.getColumnNumber() != -1) {
                treeWriter.addAttribute(_column, "" + sAXParseException.getColumnNumber());
            }
            treeWriter.startContent();
            treeWriter.addText(sAXParseException.toString());
            treeWriter.addEndElement();
            treeWriter.endDocument();
            ValidateJing.this.step.reportError(treeWriter.getResult());
            if (this.err != null) {
                this.err = sAXParseException;
            }
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
        }
    }
}

