/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.drivers;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadableData;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritableDocument;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.LogOptions;
import com.xmlcalabash.util.ParseArgs;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.xml.sax.InputSource;

public class Main {
    private static boolean errors = false;
    private static QName _code = new QName("code");
    private XProcRuntime runtime = null;
    private boolean readStdin = false;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean debug = false;

    public static void main(String[] stringArray) throws SaxonApiException, IOException, URISyntaxException {
        Main main = new Main();
        main.run(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    public void run(String[] stringArray) throws SaxonApiException, IOException, URISyntaxException {
        block86: {
            ParseArgs parseArgs = new ParseArgs();
            try {
                parseArgs.parse(stringArray);
            }
            catch (XProcException xProcException) {
                System.err.println(xProcException.getMessage());
                this.usage();
            }
            if (parseArgs.showVersion) {
                this.showVersion();
                System.exit(0);
            }
            if (parseArgs.saxonConfigFile != null) {
                if (parseArgs.schemaAware) {
                    throw new XProcException("Specifying schema-aware processing is an error if you specify a Saxon configuration file.");
                }
                if (parseArgs.saxonProcessor != null) {
                    throw new XProcException("Specifying a processor type is an error if you specify a Saxon configuration file.");
                }
            }
            try {
                Object object;
                Object object22;
                Object object3;
                Object object8;
                Object object9;
                XProcConfiguration xProcConfiguration = null;
                try {
                    object9 = parseArgs.saxonProcessor;
                    if (parseArgs.schemaAware) {
                        object9 = "ee";
                    }
                    xProcConfiguration = parseArgs.saxonConfigFile != null ? new XProcConfiguration(parseArgs.saxonConfigFile) : (object9 != null ? new XProcConfiguration((String)object9, parseArgs.schemaAware) : new XProcConfiguration());
                }
                catch (Exception exception) {
                    System.err.println("FATAL: Failed to parse configuration file.");
                    System.err.println(exception);
                    System.exit(2);
                }
                if (parseArgs.configFile != null) {
                    object9 = URIUtils.cwdAsURI().resolve(parseArgs.configFile).toASCIIString();
                    object8 = new SAXSource(new InputSource((String)object9));
                    DocumentBuilder object72 = xProcConfiguration.getProcessor().newDocumentBuilder();
                    object3 = object72.build((Source)object8);
                    xProcConfiguration.parse((XdmNode)object3);
                }
                if (parseArgs.logStyle != null) {
                    xProcConfiguration.logOpt = parseArgs.logStyle.equals("off") ? LogOptions.OFF : (parseArgs.logStyle.equals("plain") ? LogOptions.PLAIN : (parseArgs.logStyle.equals("directory") ? LogOptions.DIRECTORY : LogOptions.WRAPPED));
                }
                if (parseArgs.uriResolverClass != null) {
                    xProcConfiguration.uriResolver = parseArgs.uriResolverClass;
                }
                if (parseArgs.entityResolverClass != null) {
                    xProcConfiguration.entityResolver = parseArgs.entityResolverClass;
                }
                if (parseArgs.safeModeExplicit) {
                    xProcConfiguration.safeMode = parseArgs.safeMode;
                }
                if (parseArgs.debugExplicit) {
                    xProcConfiguration.debug = parseArgs.debug;
                }
                xProcConfiguration.extensionValues |= parseArgs.extensionValues;
                xProcConfiguration.xpointerOnText |= parseArgs.allowXPointerOnText;
                xProcConfiguration.transparentJSON |= parseArgs.transparentJSON;
                if (parseArgs.jsonFlavor != null) {
                    xProcConfiguration.jsonFlavor = parseArgs.jsonFlavor;
                }
                this.debug = xProcConfiguration.debug;
                this.runtime = new XProcRuntime(xProcConfiguration);
                object9 = null;
                if (parseArgs.pipelineURI != null) {
                    object9 = this.runtime.load(parseArgs.pipelineURI);
                } else if (parseArgs.impliedPipeline()) {
                    object8 = parseArgs.implicitPipeline(this.runtime);
                    if (this.debug) {
                        System.err.println("Implicit pipeline:");
                        Serializer serializer = new Serializer();
                        serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
                        serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
                        serializer.setOutputStream((OutputStream)System.err);
                        S9apiUtils.serialize(this.runtime, (XdmNode)object8, serializer);
                    }
                    object9 = this.runtime.use((XdmNode)object8);
                } else if (xProcConfiguration.pipeline != null) {
                    object8 = xProcConfiguration.pipeline.read();
                    object9 = this.runtime.use((XdmNode)object8);
                }
                if (errors || object9 == null) {
                    this.usage();
                }
                for (String string : xProcConfiguration.params.keySet()) {
                    object3 = xProcConfiguration.params.get(string);
                    if ("*".equals(string)) {
                        for (Object object22 : ((Hashtable)object3).keySet()) {
                            ((XStep)object9).setParameter((QName)object22, new RuntimeValue((String)((Hashtable)object3).get(object22)));
                        }
                        continue;
                    }
                    for (Object object22 : ((Hashtable)object3).keySet()) {
                        ((XStep)object9).setParameter(string, (QName)object22, new RuntimeValue((String)((Hashtable)object3).get(object22)));
                    }
                }
                for (String string : parseArgs.getParameterPorts()) {
                    for (QName qName : parseArgs.getParameterNames(string)) {
                        if ("*".equals(string)) {
                            ((XStep)object9).setParameter(qName, new RuntimeValue(parseArgs.getParameter(string, qName)));
                            continue;
                        }
                        ((XStep)object9).setParameter(string, qName, new RuntimeValue(parseArgs.getParameter(string, qName)));
                    }
                }
                object8 = ((XPipeline)object9).getInputs();
                Set<String> set = parseArgs.getInputPorts();
                object3 = xProcConfiguration.inputs.keySet();
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.addAll(set);
                hashSet.addAll((Collection<String>)object3);
                for (Object object4 : hashSet) {
                    if (!object8.contains(object4)) {
                        throw new XProcException("There is a binding for the port '" + object4 + "' but the pipeline declares no such port.");
                    }
                    ((XPipeline)object9).clearInputs((String)object4);
                    if (set.contains(object4)) {
                        Object var11_30 = null;
                        for (String string : parseArgs.getInputs((String)object4)) {
                            void var11_36;
                            if (string.startsWith("xml:")) {
                                String string2 = string.substring(4);
                                object = null;
                                if ("-".equals(string2)) {
                                    XdmNode xdmNode = this.runtime.parse(new InputSource(System.in));
                                } else {
                                    XdmNode xdmNode = this.runtime.parse(new InputSource(string2));
                                }
                            } else if (string.startsWith("data:")) {
                                String string3 = string.substring(5);
                                object = new ReadableData(this.runtime, XProcConstants.c_data, string3, "text/plain");
                                XdmNode xdmNode = ((ReadableData)object).read();
                            } else {
                                throw new UnsupportedOperationException("Unexpected input type: " + string);
                            }
                            ((XPipeline)object9).writeTo((String)object4, (XdmNode)var11_36);
                        }
                        continue;
                    }
                    for (ReadablePipe readablePipe : xProcConfiguration.inputs.get(object4)) {
                        XdmNode xdmNode = readablePipe.read();
                        ((XPipeline)object9).writeTo((String)object4, xdmNode);
                    }
                }
                object22 = null;
                for (String string : ((XPipeline)object9).getOutputs()) {
                    void var12_55;
                    Object var12_52 = null;
                    if (parseArgs.outputs.containsKey(string)) {
                        String string4 = parseArgs.outputs.get(string);
                    } else if (xProcConfiguration.outputs.containsKey(string)) {
                        String string5 = xProcConfiguration.outputs.get(string);
                    }
                    if (!"-".equals(var12_55) || object22 != null) continue;
                    object22 = string;
                }
                for (String string : ((XPipeline)object9).getOutputs()) {
                    void var12_60;
                    Object var12_57 = null;
                    if (parseArgs.outputs.containsKey(string)) {
                        String string6 = parseArgs.outputs.get(string);
                    } else if (xProcConfiguration.outputs.containsKey(string)) {
                        String string7 = xProcConfiguration.outputs.get(string);
                    }
                    if (var12_60 != null) continue;
                    if (object22 == null) {
                        object22 = string;
                        continue;
                    }
                    this.warning(this.logger, null, "You didn't specify any binding for the output port '" + string + "', its output will be discard.");
                }
                for (QName qName : xProcConfiguration.options.keySet()) {
                    RuntimeValue runtimeValue = new RuntimeValue(xProcConfiguration.options.get(qName), null, null);
                    ((XPipeline)object9).passOption(qName, runtimeValue);
                }
                for (QName qName : parseArgs.getOptionNames()) {
                    RuntimeValue runtimeValue = new RuntimeValue(parseArgs.getOption(qName), null, null);
                    ((XPipeline)object9).passOption(qName, runtimeValue);
                }
                ((XPipeline)object9).run();
                for (String string : ((XPipeline)object9).getOutputs()) {
                    void var13_81;
                    void var12_71;
                    String string8;
                    Object var12_66 = null;
                    if (parseArgs.outputs.containsKey(string)) {
                        String string9 = parseArgs.outputs.get(string);
                    } else if (xProcConfiguration.outputs.containsKey(string)) {
                        String string10 = xProcConfiguration.outputs.get(string);
                    }
                    if (string.equals(object22)) {
                        this.finest(this.logger, null, "Copy output from " + string + " to stdout");
                        Object var12_70 = null;
                    } else {
                        void var12_69;
                        if (var12_69 == null) continue;
                        this.finest(this.logger, null, "Copy output from " + string + " to " + (String)var12_69);
                    }
                    Serialization serialization = ((XPipeline)object9).getSerialization(string);
                    if (serialization == null) {
                        Serialization serialization2 = new Serialization(this.runtime, ((XStep)object9).getNode());
                        for (String string11 : xProcConfiguration.serializationOptions.keySet()) {
                            string8 = xProcConfiguration.serializationOptions.get(string11);
                            if ("byte-order-mark".equals(string11)) {
                                serialization2.setByteOrderMark("true".equals(string8));
                            }
                            if ("escape-uri-attributes".equals(string11)) {
                                serialization2.setEscapeURIAttributes("true".equals(string8));
                            }
                            if ("include-content-type".equals(string11)) {
                                serialization2.setIncludeContentType("true".equals(string8));
                            }
                            if ("indent".equals(string11)) {
                                serialization2.setIndent("true".equals(string8));
                            }
                            if ("omit-xml-declaration".equals(string11)) {
                                serialization2.setOmitXMLDeclaration("true".equals(string8));
                            }
                            if ("undeclare-prefixes".equals(string11)) {
                                serialization2.setUndeclarePrefixes("true".equals(string8));
                            }
                            if ("method".equals(string11)) {
                                serialization2.setMethod(new QName("", string8));
                            }
                            if ("doctype-public".equals(string11)) {
                                serialization2.setDoctypePublic(string8);
                            }
                            if ("doctype-system".equals(string11)) {
                                serialization2.setDoctypeSystem(string8);
                            }
                            if ("encoding".equals(string11)) {
                                serialization2.setEncoding(string8);
                            }
                            if ("media-type".equals(string11)) {
                                serialization2.setMediaType(string8);
                            }
                            if ("normalization-form".equals(string11)) {
                                serialization2.setNormalizationForm(string8);
                            }
                            if ("standalone".equals(string11)) {
                                serialization2.setStandalone(string8);
                            }
                            if (!"version".equals(string11)) continue;
                            serialization2.setVersion(string8);
                        }
                    }
                    object = null;
                    if (var12_71 != null) {
                        URI uRI = new URI((String)var12_71);
                        string8 = uRI.getPath();
                        FileOutputStream fileOutputStream = new FileOutputStream(string8);
                        object = new WritableDocument(this.runtime, string8, (Serialization)var13_81, fileOutputStream);
                    } else {
                        object = new WritableDocument(this.runtime, (String)var12_71, (Serialization)var13_81);
                    }
                    ReadablePipe readablePipe = ((XPipeline)object9).readFrom(string);
                    while (readablePipe.moreDocuments()) {
                        ((WritableDocument)object).write(readablePipe.read());
                    }
                    if (var12_71 == null) continue;
                    ((WritableDocument)object).close();
                }
                if (object22 != null) {
                    System.out.println();
                }
            }
            catch (XProcException xProcException) {
                Throwable throwable;
                if (xProcException.getErrorCode() != null) {
                    this.error(this.logger, null, this.errorMessage(xProcException.getErrorCode()), xProcException.getErrorCode());
                } else {
                    this.error(this.logger, null, xProcException.toString(), null);
                }
                for (throwable = xProcException.getCause(); throwable != null && throwable instanceof XProcException; throwable = throwable.getCause()) {
                }
                if (throwable != null) {
                    this.error(this.logger, null, "Underlying exception: " + throwable, null);
                }
                if (this.debug) {
                    xProcException.printStackTrace();
                }
            }
            catch (Exception exception) {
                this.error(this.logger, null, "Pipeline failed: " + exception.toString(), null);
                if (exception.getCause() != null) {
                    Throwable throwable = exception.getCause();
                    this.error(this.logger, null, "Underlying exception: " + throwable, null);
                }
                if (!this.debug) break block86;
                exception.printStackTrace();
            }
        }
    }

    private void showVersion() {
        System.out.println("XML Calabash version " + XProcConstants.XPROC_VERSION + ", an XProc processor");
        System.out.println("Copyright (c) 2007-2012 Norman Walsh");
        System.out.println("See http://xmlcalabash.com/");
        System.out.println("");
    }

    private void usage() throws IOException {
        this.showVersion();
        InputStream inputStream = this.getClass().getResourceAsStream("/etc/usage.txt");
        if (inputStream == null) {
            throw new UnsupportedOperationException("Failed to load usage text from JAR file. This \"can't happen\".");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            System.err.println(string);
        }
        inputStream.close();
        bufferedReader.close();
        System.exit(1);
    }

    private String errorMessage(QName qName) {
        InputStream inputStream = this.getClass().getResourceAsStream("/etc/error-list.xml");
        if (inputStream != null) {
            XdmNode xdmNode = this.runtime.parse(new InputSource(inputStream));
            XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.DESCENDANT, new QName("http://www.w3.org/ns/xproc-error", "error"));
            while (xdmSequenceIterator.hasNext()) {
                XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
                if (!qName.getLocalName().equals(xdmNode2.getAttributeValue(_code))) continue;
                return xdmNode2.getStringValue();
            }
        }
        return "Unknown error";
    }

    private String message(XdmNode xdmNode, String string) {
        String string2 = "(unknown URI)";
        int n = -1;
        if (xdmNode != null) {
            string2 = xdmNode.getBaseURI().toASCIIString();
            n = xdmNode.getLineNumber();
            return string2 + ":" + n + ": " + string;
        }
        return string;
    }

    public void error(Logger logger, XdmNode xdmNode, String string, QName qName) {
        logger.severe(this.message(xdmNode, string));
    }

    public void warning(Logger logger, XdmNode xdmNode, String string) {
        logger.warning(this.message(xdmNode, string));
    }

    public void info(Logger logger, XdmNode xdmNode, String string) {
        logger.info(this.message(xdmNode, string));
    }

    public void fine(Logger logger, XdmNode xdmNode, String string) {
        logger.fine(this.message(xdmNode, string));
    }

    public void finer(Logger logger, XdmNode xdmNode, String string) {
        logger.finer(this.message(xdmNode, string));
    }

    public void finest(Logger logger, XdmNode xdmNode, String string) {
        logger.finest(this.message(xdmNode, string));
    }
}

