/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MemoSequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.value.Closure;

public class MemoClosure
extends Closure
implements ContextOriginator {
    private Sequence sequence;

    public MemoClosure() {
    }

    public MemoClosure(Expression expr, XPathContext context) throws XPathException {
        this.setExpression(expr);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        this.setSavedXPathContext(c2);
        this.saveContext(expr, context);
    }

    @Override
    public synchronized SequenceIterator iterate() {
        try {
            this.makeSequence();
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
        return this.sequence.iterate();
    }

    private void makeSequence() throws XPathException {
        if (this.sequence == null) {
            this.inputIterator = this.expression.iterate(this.savedXPathContext);
            this.inputIterator.discharge();
            this.sequence = this.inputIterator instanceof GroundedIterator && ((GroundedIterator)this.inputIterator).isActuallyGrounded() ? ((GroundedIterator)this.inputIterator).materialize() : SequenceTool.toMemoSequence(this.inputIterator);
        }
    }

    public synchronized Item itemAt(int n) throws XPathException {
        this.makeSequence();
        if (this.sequence instanceof GroundedValue) {
            return ((GroundedValue)this.sequence).itemAt(n);
        }
        if (this.sequence instanceof MemoSequence) {
            return ((MemoSequence)this.sequence).itemAt(n);
        }
        throw new IllegalStateException();
    }

    @Override
    public GroundedValue reduce() throws XPathException {
        try {
            if (this.sequence instanceof GroundedValue) {
                return (GroundedValue)this.sequence;
            }
            return SequenceTool.toGroundedValue(this.iterate());
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
    }

    @Override
    public Sequence makeRepeatable() {
        return this;
    }
}

