/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;

public class CodepointCollator
implements StringCollator,
SubstringMatcher {
    private static final CodepointCollator theInstance = new CodepointCollator();

    public static CodepointCollator getInstance() {
        return theInstance;
    }

    @Override
    public String getCollationURI() {
        return "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    @Override
    public int compareStrings(UnicodeString a, UnicodeString b) {
        return a.compareTo(b);
    }

    @Override
    public boolean comparesEqual(UnicodeString s1, UnicodeString s2) {
        return s1.equals(s2);
    }

    @Override
    public boolean contains(UnicodeString s1, UnicodeString s2) {
        return s1.indexOf(s2, 0L) >= 0L;
    }

    @Override
    public boolean endsWith(UnicodeString s1, UnicodeString s2) {
        if (s2.length() > s1.length()) {
            return false;
        }
        return s1.hasSubstring(s2, s1.length() - s2.length());
    }

    @Override
    public boolean startsWith(UnicodeString s1, UnicodeString s2) {
        return s1.hasSubstring(s2, 0L);
    }

    @Override
    public UnicodeString substringAfter(UnicodeString s1, UnicodeString s2) {
        long i = s1.indexOf(s2, 0L);
        if (i < 0L) {
            return EmptyUnicodeString.getInstance();
        }
        return s1.substring(i + s2.length());
    }

    @Override
    public UnicodeString substringBefore(UnicodeString s1, UnicodeString s2) {
        long j = s1.indexOf(s2, 0L);
        if (j < 0L) {
            return EmptyUnicodeString.getInstance();
        }
        return s1.prefix(j);
    }

    @Override
    public AtomicMatchKey getCollationKey(UnicodeString s) {
        return s;
    }
}

