/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.util.TreeWriter;
import java.util.Iterator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONtoXML {
    public static final String CALABASH_DEPRECATED = "calabash-deprecated";
    public static final String CALABASH = "calabash";
    public static final String JSONX = "jsonx";
    public static final String JXML = "jxml";
    public static final String MARKLOGIC = "marklogic";
    public static final String JSONX_NS = "http://www.ibm.com/xmlns/prod/2009/jsonx";
    public static final String MLJS_NS = "http://marklogic.com/json";
    public static final String JXML_NS = "http://www.xmlsh.org/jxml";
    private static final QName _type = new QName("", "type");
    private static final QName _name = new QName("", "name");
    private static final QName c_json = new QName("c", "http://www.w3.org/ns/xproc-step", "json");
    private static final QName c_pair = new QName("c", "http://www.w3.org/ns/xproc-step", "pair");
    private static final QName c_item = new QName("c", "http://www.w3.org/ns/xproc-step", "item");
    private static final QName _json = new QName("json");
    private static final QName _pair = new QName("pair");
    private static final QName _item = new QName("item");
    private static final QName j_object = new QName("j", "http://www.ibm.com/xmlns/prod/2009/jsonx", "object");
    private static final QName j_array = new QName("j", "http://www.ibm.com/xmlns/prod/2009/jsonx", "array");
    private static final QName j_string = new QName("j", "http://www.ibm.com/xmlns/prod/2009/jsonx", "string");
    private static final QName j_number = new QName("j", "http://www.ibm.com/xmlns/prod/2009/jsonx", "number");
    private static final QName j_boolean = new QName("j", "http://www.ibm.com/xmlns/prod/2009/jsonx", "boolean");
    private static final QName j_null = new QName("j", "http://www.ibm.com/xmlns/prod/2009/jsonx", "null");
    private static final QName mj_json = new QName("j", "http://marklogic.com/json", "json");
    private static final QName jx_object = new QName("j", "http://www.xmlsh.org/jxml", "object");
    private static final QName jx_member = new QName("j", "http://www.xmlsh.org/jxml", "member");
    private static final QName jx_boolean = new QName("j", "http://www.xmlsh.org/jxml", "boolean");
    private static final QName jx_array = new QName("j", "http://www.xmlsh.org/jxml", "array");
    private static final QName jx_string = new QName("j", "http://www.xmlsh.org/jxml", "string");
    private static final QName jx_number = new QName("j", "http://www.xmlsh.org/jxml", "number");
    private static final QName jx_null = new QName("j", "http://www.xmlsh.org/jxml", "null");

    public static boolean knownFlavor(String string) {
        return CALABASH_DEPRECATED.equals(string) || CALABASH.equals(string) || JSONX.equals(string) || JXML.equals(string) || MARKLOGIC.equals(string);
    }

    public static XdmNode convert(Processor processor, JSONTokener jSONTokener, String string) {
        TreeWriter treeWriter = new TreeWriter(processor);
        treeWriter.startDocument(null);
        if (JSONX.equals(string)) {
            JSONtoXML.buildJsonX(treeWriter, jSONTokener);
        } else if (MARKLOGIC.equals(string)) {
            JSONtoXML.buildMarkLogic(treeWriter, jSONTokener);
        } else if (JXML.equals(string)) {
            JSONtoXML.buildJxml(treeWriter, jSONTokener);
        } else if (CALABASH.equals(string)) {
            JSONtoXML.buildMine(treeWriter, jSONTokener, true);
        } else {
            JSONtoXML.buildMine(treeWriter, jSONTokener, false);
        }
        treeWriter.endDocument();
        return treeWriter.getResult();
    }

    private static void buildJsonX(TreeWriter treeWriter, JSONTokener jSONTokener) {
        try {
            char c = jSONTokener.next();
            jSONTokener.back();
            if (c == '{') {
                treeWriter.addStartElement(j_object);
                treeWriter.startContent();
                JSONtoXML.buildJsonXPairs(treeWriter, new JSONObject(jSONTokener));
            } else {
                treeWriter.addStartElement(j_array);
                JSONtoXML.buildJsonXArray(treeWriter, new JSONArray(jSONTokener));
            }
        }
        catch (JSONException jSONException) {
            throw new XProcException(jSONException);
        }
        treeWriter.addEndElement();
    }

    private static void buildJsonXPairs(TreeWriter treeWriter, JSONObject jSONObject) {
        try {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object = jSONObject.get(string);
                JSONtoXML.serializeJsonX(treeWriter, object, string);
            }
        }
        catch (JSONException jSONException) {
            throw new XProcException(jSONException);
        }
    }

    private static void buildJsonXArray(TreeWriter treeWriter, JSONArray jSONArray) {
        try {
            for (int i = 0; i < jSONArray.length(); ++i) {
                Object object = jSONArray.get(i);
                JSONtoXML.serializeJsonX(treeWriter, object, null);
            }
        }
        catch (JSONException jSONException) {
            throw new XProcException(jSONException);
        }
    }

    private static void serializeJsonX(TreeWriter treeWriter, Object object, String string) {
        if (object instanceof JSONObject) {
            treeWriter.addStartElement(j_object);
            if (string != null) {
                treeWriter.addAttribute(_name, string);
            }
            treeWriter.startContent();
            JSONtoXML.buildJsonXPairs(treeWriter, (JSONObject)object);
            treeWriter.addEndElement();
        } else if (object instanceof JSONArray) {
            treeWriter.addStartElement(j_array);
            if (string != null) {
                treeWriter.addAttribute(_name, string);
            }
            treeWriter.startContent();
            JSONtoXML.buildJsonXArray(treeWriter, (JSONArray)object);
            treeWriter.addEndElement();
        } else if (object instanceof Integer || object instanceof Double || object instanceof Long) {
            treeWriter.addStartElement(j_number);
            if (string != null) {
                treeWriter.addAttribute(_name, string);
            }
            treeWriter.startContent();
            treeWriter.addText(object.toString());
            treeWriter.addEndElement();
        } else if (object instanceof String) {
            treeWriter.addStartElement(j_string);
            if (string != null) {
                treeWriter.addAttribute(_name, string);
            }
            treeWriter.startContent();
            treeWriter.addText(object.toString());
            treeWriter.addEndElement();
        } else if (object instanceof Boolean) {
            treeWriter.addStartElement(j_boolean);
            if (string != null) {
                treeWriter.addAttribute(_name, string);
            }
            treeWriter.startContent();
            treeWriter.addText(object.toString());
            treeWriter.addEndElement();
        } else if (object == JSONObject.NULL) {
            treeWriter.addStartElement(j_null);
            if (string != null) {
                treeWriter.addAttribute(_name, string);
            }
            treeWriter.startContent();
            treeWriter.addEndElement();
        } else {
            throw new XProcException("Unexpected type in JSON conversion.");
        }
    }

    private static void buildMarkLogic(TreeWriter treeWriter, JSONTokener jSONTokener) {
        treeWriter.addStartElement(mj_json);
        try {
            char c = jSONTokener.next();
            jSONTokener.back();
            if (c == '{') {
                treeWriter.addAttribute(_type, "object");
                treeWriter.startContent();
                JSONtoXML.buildMarkLogicPairs(treeWriter, new JSONObject(jSONTokener));
            } else {
                treeWriter.addAttribute(_type, "object");
                JSONtoXML.buildMarkLogicArray(treeWriter, new JSONArray(jSONTokener));
            }
        }
        catch (JSONException jSONException) {
            throw new XProcException(jSONException);
        }
        treeWriter.addEndElement();
    }

    private static void buildMarkLogicPairs(TreeWriter treeWriter, JSONObject jSONObject) {
        try {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object = jSONObject.get(string);
                JSONtoXML.serializeMarkLogic(treeWriter, object, string);
            }
        }
        catch (JSONException jSONException) {
            throw new XProcException(jSONException);
        }
    }

    private static void buildMarkLogicArray(TreeWriter treeWriter, JSONArray jSONArray) {
        try {
            for (int i = 0; i < jSONArray.length(); ++i) {
                Object object = jSONArray.get(i);
                JSONtoXML.serializeMarkLogic(treeWriter, object, null);
            }
        }
        catch (JSONException jSONException) {
            throw new XProcException(jSONException);
        }
    }

    private static void serializeMarkLogic(TreeWriter treeWriter, Object object, String string) {
        String string2 = "item";
        if (string != null) {
            if ("".equals(string)) {
                string2 = "_";
            } else {
                string2 = "";
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    string2 = '_' != c && (i == 0 && XMLCharacterData.isNCNameStart10((int)c) || i > 0 && XMLCharacterData.isNCName10((int)c)) ? string2 + Character.toString(c) : string2 + String.format("_%04x", c);
                }
            }
        }
        QName qName = new QName("j", MLJS_NS, string2);
        treeWriter.addStartElement(qName);
        if (object instanceof JSONObject) {
            treeWriter.addAttribute(_type, "object");
            treeWriter.startContent();
            JSONtoXML.buildMarkLogicPairs(treeWriter, (JSONObject)object);
        } else if (object instanceof JSONArray) {
            treeWriter.addAttribute(_type, "array");
            treeWriter.startContent();
            JSONtoXML.buildMarkLogicArray(treeWriter, (JSONArray)object);
        } else if (object instanceof Integer || object instanceof Double || object instanceof Long) {
            treeWriter.addAttribute(_type, "number");
            treeWriter.startContent();
            treeWriter.addText(object.toString());
        } else if (object instanceof String) {
            treeWriter.addAttribute(_type, "string");
            treeWriter.startContent();
            treeWriter.addText(object.toString());
        } else if (object instanceof Boolean) {
            treeWriter.addAttribute(_type, "boolean");
            treeWriter.startContent();
            treeWriter.addText(object.toString());
        } else if (object == JSONObject.NULL) {
            treeWriter.addAttribute(_type, "null");
            treeWriter.startContent();
        } else {
            throw new XProcException("Unexpected type in JSON conversion.");
        }
        treeWriter.addEndElement();
    }

    private static void buildJxml(TreeWriter treeWriter, JSONTokener jSONTokener) {
        try {
            char c = jSONTokener.next();
            jSONTokener.back();
            if (c == '{') {
                treeWriter.addStartElement(jx_object);
                treeWriter.startContent();
                JSONtoXML.buildJxmlPairs(treeWriter, new JSONObject(jSONTokener));
            } else {
                treeWriter.addStartElement(jx_array);
                JSONtoXML.buildJxmlArray(treeWriter, new JSONArray(jSONTokener));
            }
        }
        catch (JSONException jSONException) {
            throw new XProcException(jSONException);
        }
        treeWriter.addEndElement();
    }

    private static void buildJxmlPairs(TreeWriter treeWriter, JSONObject jSONObject) {
        try {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object = jSONObject.get(string);
                JSONtoXML.serializeJxml(treeWriter, object, string);
            }
        }
        catch (JSONException jSONException) {
            throw new XProcException(jSONException);
        }
    }

    private static void buildJxmlArray(TreeWriter treeWriter, JSONArray jSONArray) {
        try {
            for (int i = 0; i < jSONArray.length(); ++i) {
                Object object = jSONArray.get(i);
                JSONtoXML.serializeJxml(treeWriter, object, null);
            }
        }
        catch (JSONException jSONException) {
            throw new XProcException(jSONException);
        }
    }

    private static void serializeJxml(TreeWriter treeWriter, Object object, String string) {
        if (string != null) {
            treeWriter.addStartElement(jx_member);
            treeWriter.addAttribute(_name, string);
            treeWriter.startContent();
        }
        if (object instanceof JSONObject) {
            treeWriter.addStartElement(jx_object);
            treeWriter.startContent();
            JSONtoXML.buildJxmlPairs(treeWriter, (JSONObject)object);
            treeWriter.addEndElement();
        } else if (object instanceof JSONArray) {
            treeWriter.addStartElement(jx_array);
            treeWriter.startContent();
            JSONtoXML.buildJxmlArray(treeWriter, (JSONArray)object);
            treeWriter.addEndElement();
        } else if (object instanceof Integer || object instanceof Double || object instanceof Long) {
            treeWriter.addStartElement(jx_number);
            treeWriter.startContent();
            treeWriter.addText(object.toString());
            treeWriter.addEndElement();
        } else if (object instanceof String) {
            treeWriter.addStartElement(jx_string);
            treeWriter.startContent();
            treeWriter.addText(object.toString());
            treeWriter.addEndElement();
        } else if (object instanceof Boolean) {
            treeWriter.addStartElement(jx_boolean);
            treeWriter.startContent();
            treeWriter.addText(object.toString());
            treeWriter.addEndElement();
        } else if (object == JSONObject.NULL) {
            treeWriter.addStartElement(jx_null);
            treeWriter.startContent();
            treeWriter.addEndElement();
        } else {
            throw new XProcException("Unexpected type in JSON conversion.");
        }
        if (string != null) {
            treeWriter.addEndElement();
        }
    }

    private static void buildMine(TreeWriter treeWriter, JSONTokener jSONTokener, boolean bl) {
        treeWriter.addStartElement(bl ? c_json : _json);
        try {
            char c = jSONTokener.next();
            jSONTokener.back();
            if (c == '{') {
                treeWriter.addAttribute(_type, "object");
                treeWriter.startContent();
                JSONtoXML.buildMyPairs(treeWriter, new JSONObject(jSONTokener), bl);
            } else {
                treeWriter.addAttribute(_type, "array");
                treeWriter.startContent();
                JSONtoXML.buildMyArray(treeWriter, new JSONArray(jSONTokener), bl);
            }
        }
        catch (JSONException jSONException) {
            throw new XProcException(jSONException);
        }
        treeWriter.addEndElement();
    }

    private static void buildMyPairs(TreeWriter treeWriter, JSONObject jSONObject, boolean bl) {
        try {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object = jSONObject.get(string);
                treeWriter.addStartElement(bl ? c_pair : _pair);
                treeWriter.addAttribute(_name, string);
                if (object instanceof JSONObject) {
                    treeWriter.addAttribute(_type, "object");
                    treeWriter.startContent();
                    JSONtoXML.buildMyPairs(treeWriter, (JSONObject)object, bl);
                } else if (object instanceof JSONArray) {
                    treeWriter.addAttribute(_type, "array");
                    treeWriter.startContent();
                    JSONtoXML.buildMyArray(treeWriter, (JSONArray)object, bl);
                } else if (object instanceof Integer) {
                    treeWriter.addAttribute(_type, "number");
                    treeWriter.startContent();
                    treeWriter.addText(object.toString());
                } else if (object instanceof Double) {
                    treeWriter.addAttribute(_type, "number");
                    treeWriter.startContent();
                    treeWriter.addText(object.toString());
                } else if (object instanceof Long) {
                    treeWriter.addAttribute(_type, "number");
                    treeWriter.startContent();
                    treeWriter.addText(object.toString());
                } else if (object instanceof String) {
                    treeWriter.addAttribute(_type, "string");
                    treeWriter.startContent();
                    treeWriter.addText(object.toString());
                } else if (object instanceof Boolean) {
                    treeWriter.addAttribute(_type, "boolean");
                    treeWriter.startContent();
                    treeWriter.addText(object.toString());
                } else if (object == JSONObject.NULL) {
                    treeWriter.addAttribute(_type, "null");
                    treeWriter.startContent();
                } else {
                    throw new XProcException("Unexpected type in JSON conversion.");
                }
                treeWriter.addEndElement();
            }
        }
        catch (JSONException jSONException) {
            throw new XProcException(jSONException);
        }
    }

    private static void buildMyArray(TreeWriter treeWriter, JSONArray jSONArray, boolean bl) {
        try {
            for (int i = 0; i < jSONArray.length(); ++i) {
                Object object = jSONArray.get(i);
                treeWriter.addStartElement(bl ? c_item : _item);
                if (object instanceof JSONObject) {
                    treeWriter.addAttribute(_type, "object");
                    treeWriter.startContent();
                    JSONtoXML.buildMyPairs(treeWriter, (JSONObject)object, bl);
                } else if (object instanceof JSONArray) {
                    treeWriter.addAttribute(_type, "array");
                    treeWriter.startContent();
                    JSONtoXML.buildMyArray(treeWriter, (JSONArray)object, bl);
                } else if (object instanceof Integer) {
                    treeWriter.addAttribute(_type, "number");
                    treeWriter.startContent();
                    treeWriter.addText(object.toString());
                } else if (object instanceof Double) {
                    treeWriter.addAttribute(_type, "number");
                    treeWriter.startContent();
                    treeWriter.addText(object.toString());
                } else if (object instanceof Long) {
                    treeWriter.addAttribute(_type, "number");
                    treeWriter.startContent();
                    treeWriter.addText(object.toString());
                } else if (object instanceof String) {
                    treeWriter.addAttribute(_type, "string");
                    treeWriter.startContent();
                    treeWriter.addText(object.toString());
                } else if (object instanceof Boolean) {
                    treeWriter.addAttribute(_type, "boolean");
                    treeWriter.startContent();
                    treeWriter.addText(object.toString());
                } else if (object == JSONObject.NULL) {
                    treeWriter.addAttribute(_type, "null");
                    treeWriter.startContent();
                } else {
                    throw new XProcException("Unexpected type in JSON conversion.");
                }
                treeWriter.addEndElement();
            }
        }
        catch (JSONException jSONException) {
            throw new XProcException(jSONException);
        }
    }
}

