/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.type.SimpleType;

public class NamespaceRename
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _from = new QName("from");
    private static final QName _to = new QName("to");
    private static final QName _apply_to = new QName("apply-to");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private String from = null;
    private String to = null;
    private String applyTo = null;

    public NamespaceRename(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        this.from = this.getOption(_from) != null ? this.getOption(_from).getString() : "";
        this.to = this.getOption(_to) != null ? this.getOption(_to).getString() : "";
        this.applyTo = this.getOption(_apply_to, "all");
        if ("http://www.w3.org/XML/1998/namespace".equals(this.from) || "http://www.w3.org/XML/1998/namespace".equals(this.to) || "http://www.w3.org/2000/xmlns/".equals(this.from) || "http://www.w3.org/2000/xmlns/".equals(this.to)) {
            throw XProcException.stepError(14);
        }
        if (this.from.equals(this.to)) {
            this.result.write(this.source.read());
        } else {
            this.matcher = new ProcessMatch(this.runtime, this);
            this.matcher.match(this.source.read(), new RuntimeValue("*", this.step.getNode()));
            this.result.write(this.matcher.getResult());
        }
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6);
        }
    }

    @Override
    public boolean processStartDocument(XdmNode xdmNode) throws SaxonApiException {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addEndElement();
    }

    @Override
    public boolean processStartElement(XdmNode xdmNode) throws SaxonApiException {
        String string;
        String string2;
        NameOfNode nameOfNode;
        String string3;
        String string4;
        NodeInfo nodeInfo = xdmNode.getUnderlyingNode();
        NamespaceBinding[] namespaceBindingArray = nodeInfo.getDeclaredNamespaces(null);
        NamespaceBinding[] namespaceBindingArray2 = null;
        if ("attributes".equals(this.applyTo)) {
            this.matcher.addStartElement((NodeName)new NameOfNode(nodeInfo), nodeInfo.getSchemaType(), namespaceBindingArray);
        } else {
            if (namespaceBindingArray.length > 0) {
                int n;
                int n2 = 0;
                for (n = 0; n < namespaceBindingArray.length; ++n) {
                    NamespaceBinding namespaceBinding = namespaceBindingArray[n];
                    string4 = namespaceBinding.getURI();
                    if (this.from.equals(string4) && "".equals(this.to)) continue;
                    ++n2;
                }
                namespaceBindingArray2 = new NamespaceBinding[n2];
                n = 0;
                for (int i = 0; i < namespaceBindingArray.length; ++i) {
                    string4 = namespaceBindingArray[i];
                    string3 = string4.getPrefix();
                    String string5 = string4.getURI();
                    if (this.from.equals(string5)) {
                        if ("".equals(this.to)) continue;
                        NamespaceBinding namespaceBinding = new NamespaceBinding(string3, this.to);
                        namespaceBindingArray2[n++] = namespaceBinding;
                        continue;
                    }
                    namespaceBindingArray2[n++] = string4;
                }
            }
            nameOfNode = new NameOfNode(nodeInfo);
            string2 = nameOfNode.getPrefix();
            string = nameOfNode.getURI();
            if (this.from.equals(string)) {
                if ("".equals(this.to)) {
                    string2 = "";
                }
                nameOfNode = new FingerprintedQName(string2, this.to, nameOfNode.getLocalPart());
            }
            this.matcher.addStartElement((NodeName)nameOfNode, nodeInfo.getSchemaType(), namespaceBindingArray2);
        }
        if (!"elements".equals(this.applyTo)) {
            nameOfNode = xdmNode.axisIterator(Axis.ATTRIBUTE);
            while (nameOfNode.hasNext()) {
                string2 = (XdmNode)nameOfNode.next();
                nodeInfo = string2.getUnderlyingNode();
                string = new NameOfNode(nodeInfo);
                string4 = string.getPrefix();
                string3 = string.getURI();
                if (this.from.equals(string3)) {
                    if ("".equals(string4)) {
                        string4 = "_1";
                    }
                    string = new FingerprintedQName(string4, this.to, string.getLocalPart());
                }
                this.matcher.addAttribute((NodeName)string, (SimpleType)nodeInfo.getSchemaType(), string2.getStringValue());
            }
        } else {
            this.matcher.addAttributes(xdmNode);
        }
        return true;
    }

    @Override
    public void processEndElement(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addText(xdmNode.getStringValue());
    }

    @Override
    public void processComment(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addComment(xdmNode.getStringValue());
    }

    @Override
    public void processPI(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addPI(xdmNode.getNodeName().getLocalName(), xdmNode.getStringValue());
    }

    @Override
    public void processAttribute(XdmNode xdmNode) throws SaxonApiException {
        throw new UnsupportedOperationException("processAttribute can't be called in NamespaceRename--but it was!?");
    }
}

