/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.extensions.UntilUnchanged;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.Catch;
import com.xmlcalabash.model.Choose;
import com.xmlcalabash.model.ComputableValue;
import com.xmlcalabash.model.DataBinding;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.DocumentBinding;
import com.xmlcalabash.model.EmptyBinding;
import com.xmlcalabash.model.EndPoint;
import com.xmlcalabash.model.ErrorBinding;
import com.xmlcalabash.model.ForEach;
import com.xmlcalabash.model.Group;
import com.xmlcalabash.model.Import;
import com.xmlcalabash.model.InlineBinding;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Log;
import com.xmlcalabash.model.NamespaceBinding;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Otherwise;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Parameter;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.PipelineLibrary;
import com.xmlcalabash.model.Port;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.model.SourceArtifact;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Try;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.model.Viewport;
import com.xmlcalabash.model.When;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TypeUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Parser {
    private static QName px_name = new QName("http://xmlcalabash.com/ns/extensions", "name");
    private static QName _name = new QName("name");
    private static QName _href = new QName("href");
    private static QName _type = new QName("type");
    private static QName _version = new QName("version");
    private static QName err_XS0063 = new QName("http://www.w3.org/ns/xproc-error", "XS0063");
    private static QName p_use_when = new QName("http://www.w3.org/ns/xproc", "use-when");
    private static QName _use_when = new QName("use-when");
    private static QName _exclude_inline_prefixes = new QName("exclude-inline-prefixes");
    private XProcRuntime runtime = null;
    private Stack<DeclareStep> declStack = null;
    protected HashSet<String> topLevelImports = new HashSet();
    private boolean loadingStandardLibrary = false;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public Parser(XProcRuntime xProcRuntime) {
        this.runtime = xProcRuntime;
        this.declStack = new Stack();
    }

    public DeclareStep loadPipeline(String string) throws SaxonApiException {
        XdmNode xdmNode = this.runtime.parse(string, URIUtils.cwdAsURI().toASCIIString());
        XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
        if (!XProcConstants.p_declare_step.equals((Object)xdmNode2.getNodeName()) && !XProcConstants.p_pipeline.equals((Object)xdmNode2.getNodeName())) {
            throw new UnsupportedOperationException("Pipelines must be p:pipeline or p:declare-step documents");
        }
        return this.usePipeline(xdmNode2);
    }

    public DeclareStep usePipeline(XdmNode xdmNode) {
        if (xdmNode.getNodeKind() == XdmNodeKind.DOCUMENT) {
            xdmNode = S9apiUtils.getDocumentElement(xdmNode);
        }
        DeclareStep declareStep = this.readDeclareStep(xdmNode);
        this.parseDeclareStepBodyPassTwo(declareStep);
        return declareStep;
    }

    public PipelineLibrary loadStandardLibrary() throws FileNotFoundException, URISyntaxException, SaxonApiException {
        URI uRI = URIUtils.homeAsURI();
        URI uRI2 = URIUtils.cwdAsURI();
        URI uRI3 = uRI;
        InputStream inputStream = this.getClass().getResourceAsStream("/etc/pipeline-library.xml");
        if (inputStream == null) {
            throw new UnsupportedOperationException("Failed to load standard pipeline library from JAR file");
        }
        XdmNode xdmNode = this.parse(inputStream, uRI3);
        XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
        if (!XProcConstants.p_library.equals((Object)xdmNode2.getNodeName())) {
            throw new UnsupportedOperationException("Pipeline libraries must be p:library documents");
        }
        this.loadingStandardLibrary = true;
        PipelineLibrary pipelineLibrary = this.readLibrary(null, xdmNode2);
        this.loadingStandardLibrary = false;
        return pipelineLibrary;
    }

    private XdmNode loadExtensionLibrary() throws FileNotFoundException, URISyntaxException, SaxonApiException {
        URI uRI;
        URI uRI2 = uRI = URIUtils.homeAsURI();
        InputStream inputStream = this.getClass().getResourceAsStream("/etc/extension-library.xml");
        if (inputStream == null) {
            throw new UnsupportedOperationException("Failed to load XProc pipeline library from JAR file");
        }
        XdmNode xdmNode = this.parse(inputStream, uRI2);
        XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
        if (!XProcConstants.p_library.equals((Object)xdmNode2.getNodeName())) {
            throw new UnsupportedOperationException("Pipeline libraries must be p:library documents");
        }
        return xdmNode;
    }

    public PipelineLibrary loadLibrary(String string) throws SaxonApiException {
        XdmNode xdmNode = this.runtime.parse(string, URIUtils.cwdAsURI().toASCIIString());
        XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
        return this.useLibrary(xdmNode2);
    }

    public PipelineLibrary useLibrary(XdmNode xdmNode) throws SaxonApiException {
        if (!XProcConstants.p_library.equals((Object)xdmNode.getNodeName())) {
            throw new UnsupportedOperationException("Pipelines libraries must be p:library documents");
        }
        if (this.declStack.isEmpty()) {
            this.topLevelImports.add(xdmNode.getBaseURI().toASCIIString());
        } else {
            this.declStack.peek().addImport(xdmNode.getBaseURI().toASCIIString());
        }
        return this.readLibrary(null, xdmNode);
    }

    private XdmNode parse(InputStream inputStream, URI uRI) throws SaxonApiException {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setEntityResolver(this.runtime.getResolver());
            SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(inputStream));
            DocumentBuilder documentBuilder = this.runtime.getProcessor().newDocumentBuilder();
            documentBuilder.setLineNumbering(true);
            documentBuilder.setDTDValidation(false);
            documentBuilder.setBaseURI(uRI);
            return documentBuilder.build((Source)sAXSource);
        }
        catch (SAXException sAXException) {
            throw new XProcException(sAXException);
        }
    }

    private PipelineLibrary readLibrary(Step step, XdmNode xdmNode) {
        if (!(XProcConstants.p_library.equals((Object)xdmNode.getNodeName()) || XProcConstants.p_pipeline.equals((Object)xdmNode.getNodeName()) || XProcConstants.p_declare_step.equals((Object)xdmNode.getNodeName()))) {
            this.runtime.error(null, xdmNode, "Not a pipeline or library: " + xdmNode.getNodeName(), XProcConstants.staticError(52));
            return null;
        }
        PipelineLibrary pipelineLibrary = new PipelineLibrary(this.runtime, xdmNode);
        if (XProcConstants.p_library.equals((Object)xdmNode.getNodeName())) {
            Step step2;
            this.checkAttributes(xdmNode, new String[]{"xpath-version", "psvi-required", "version", "exclude-inline-prefixes"}, false);
            pipelineLibrary.setVersion(this.inheritedVersion(xdmNode));
            for (XdmNode xdmNode2 : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
                if (xdmNode2.getNodeName().equals((Object)XProcConstants.p_import)) continue;
                step2 = this.readStep(pipelineLibrary, xdmNode2);
                if (step2 instanceof DeclareStep) {
                    pipelineLibrary.addStep((DeclareStep)step2);
                    continue;
                }
                throw new UnsupportedOperationException("A p:library must contain only p:pipeline and p:declare-steps.");
            }
            for (XdmNode xdmNode2 : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
                Import import_;
                XdmNode xdmNode3;
                if (!xdmNode2.getNodeName().equals((Object)XProcConstants.p_import) || (xdmNode3 = (import_ = (Import)(step2 = this.readStep(pipelineLibrary, xdmNode2))).getRoot()) == null) continue;
                import_.setLibrary(this.readLibrary(pipelineLibrary, xdmNode3));
            }
        } else {
            Step step3 = this.readStep(pipelineLibrary, xdmNode);
            if ("http://xmlcalabash.com/ns/extensions".equals(step3.getDeclaredType().getNamespaceURI()) && step3.getDeclaredType().getLocalName().startsWith("anonymousType")) {
                throw XProcException.staticError(53, xdmNode, "No type attribute on imported pipeline.");
            }
            if (step3 instanceof DeclareStep) {
                pipelineLibrary.addStep((DeclareStep)step3);
            } else {
                throw new UnsupportedOperationException("A p:library must contain only p:pipeline and p:declare-steps.");
            }
        }
        this.checkExtensionAttributes(xdmNode, pipelineLibrary);
        return pipelineLibrary;
    }

    /*
     * WARNING - void declaration
     */
    private Vector<XdmNode> readSignature(Step step) {
        void var16_30;
        Object object22;
        Vector<XdmNode> vector = new Vector<XdmNode>();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        HashSet<QName> hashSet = new HashSet<QName>();
        if (XProcConstants.p_pipeline.equals((Object)step.getType()) || XProcConstants.p_declare_step.equals((Object)step.getType())) {
            hashSet.add(XProcConstants.p_import);
            hashSet.add(XProcConstants.p_input);
            hashSet.add(XProcConstants.p_output);
            hashSet.add(XProcConstants.p_log);
            hashSet.add(XProcConstants.p_option);
            hashSet.add(XProcConstants.p_serialization);
            bl2 = true;
            bl = XProcConstants.p_declare_step.equals((Object)step.getType());
        } else if (XProcConstants.p_for_each.equals((Object)step.getType())) {
            hashSet.add(XProcConstants.p_iteration_source);
            hashSet.add(XProcConstants.p_output);
            hashSet.add(XProcConstants.p_log);
            bl2 = true;
            bl = true;
        } else if (XProcConstants.cx_until_unchanged.equals((Object)step.getType())) {
            hashSet.add(XProcConstants.p_iteration_source);
            hashSet.add(XProcConstants.p_output);
            hashSet.add(XProcConstants.p_log);
            bl2 = true;
            bl = true;
        } else if (XProcConstants.p_viewport.equals((Object)step.getType())) {
            hashSet.add(XProcConstants.p_viewport_source);
            hashSet.add(XProcConstants.p_output);
            hashSet.add(XProcConstants.p_log);
            bl2 = true;
            bl = true;
        } else if (XProcConstants.p_choose.equals((Object)step.getType())) {
            hashSet.add(XProcConstants.p_xpath_context);
            bl2 = true;
            bl = true;
        } else if (XProcConstants.p_when.equals((Object)step.getType())) {
            hashSet.add(XProcConstants.p_xpath_context);
            hashSet.add(XProcConstants.p_output);
            hashSet.add(XProcConstants.p_log);
            bl2 = true;
            bl = true;
        } else if (XProcConstants.p_group.equals((Object)step.getType()) || XProcConstants.p_catch.equals((Object)step.getType()) || XProcConstants.p_otherwise.equals((Object)step.getType())) {
            hashSet.add(XProcConstants.p_output);
            hashSet.add(XProcConstants.p_log);
            bl2 = true;
            bl = true;
        } else if (XProcConstants.p_try.equals((Object)step.getType())) {
            bl2 = true;
        } else {
            hashSet.add(XProcConstants.p_input);
            hashSet.add(XProcConstants.p_log);
            hashSet.add(XProcConstants.p_with_option);
            hashSet.add(XProcConstants.p_with_param);
        }
        Hashtable<Object, Serialization> hashtable = new Hashtable<Object, Serialization>();
        Hashtable<String, Log> hashtable2 = new Hashtable<String, Log>();
        int n4 = 1;
        boolean bl3 = false;
        for (Object object22 : new RelevantNodes(this.runtime, step.getNode(), Axis.CHILD)) {
            if (bl3) {
                if (object22.getNodeKind() == XdmNodeKind.TEXT) {
                    throw XProcException.staticError(37, (XdmNode)object22, "Unexpected text: " + object22.getStringValue());
                }
                vector.add((XdmNode)object22);
                continue;
            }
            if (hashSet.contains(object22.getNodeName())) {
                Object object;
                QName qName = object22.getNodeName();
                if (XProcConstants.p_input.equals((Object)qName) || XProcConstants.p_iteration_source.equals((Object)qName) || XProcConstants.p_viewport_source.equals((Object)qName) || XProcConstants.p_xpath_context.equals((Object)qName)) {
                    Input input = this.readInput(step, (XdmNode)object22);
                    if (input.getPrimarySet() && input.getPrimary()) {
                        if (!bl) {
                            throw XProcException.staticError(8, (XdmNode)object22, "The \"primary\" attribute is not allowed in this context.");
                        }
                        if (input.getParameterInput()) {
                            if (++n > 1) {
                                throw XProcException.staticError(30, (XdmNode)object22, "You cannot have more than one primary parameter input port.");
                            }
                        } else if (++n2 > 1) {
                            throw XProcException.staticError(30, (XdmNode)object22, "You cannot have more than one primary input port.");
                        }
                    }
                    input.setPosition(n4++);
                    if (step.getInput(input.getPort()) != null || step.getOutput(input.getPort()) != null) {
                        this.runtime.error(null, (XdmNode)object22, "Duplicate port name: " + input.getPort(), XProcConstants.staticError(11));
                        continue;
                    }
                    step.addInput(input);
                    continue;
                }
                if (XProcConstants.p_output.equals((Object)qName)) {
                    Output output = this.readOutput(step, (XdmNode)object22);
                    if (output.getPrimarySet() && output.getPrimary()) {
                        if (!bl) {
                            throw XProcException.staticError(8, (XdmNode)object22, "The \"primary\" attribute is not allowed in this context.");
                        }
                        if (++n3 > 1) {
                            throw XProcException.staticError(14, (XdmNode)object22, "You cannot have more than one primary output port.");
                        }
                    }
                    if (output.getBinding().size() != 0) {
                        object = new Input(this.runtime, output.getNode());
                        ((Port)object).setPort("|" + output.getPort());
                        for (Binding binding : output.getBinding()) {
                            ((EndPoint)object).addBinding(binding);
                        }
                        output.clearBindings();
                        ((Port)object).setPrimary(output.getPrimary());
                        ((Port)object).setSequence(output.getSequence());
                        step.addInput((Input)object);
                    }
                    if (step.getInput(output.getPort()) != null || step.getOutput(output.getPort()) != null) {
                        this.runtime.error(null, (XdmNode)object22, "Duplicate port name: " + output.getPort(), XProcConstants.staticError(11));
                        continue;
                    }
                    step.addOutput(output);
                    continue;
                }
                if (XProcConstants.p_option.equals((Object)qName) || XProcConstants.p_with_option.equals((Object)qName)) {
                    if (XProcConstants.p_pipeline.equals((Object)step.getType()) || XProcConstants.p_declare_step.equals((Object)step.getType())) {
                        if (XProcConstants.p_with_option.equals((Object)qName)) {
                            throw XProcException.staticError(44, (XdmNode)object22, "Can't use p:with-option here.");
                        }
                    } else if (XProcConstants.p_option.equals((Object)qName)) {
                        throw XProcException.staticError(44, (XdmNode)object22, "Can't use p:option here.");
                    }
                    Option option = this.readOption(step, (XdmNode)object22);
                    option.setStep(step);
                    step.addOption(option);
                    continue;
                }
                if (XProcConstants.p_with_param.equals((Object)qName)) {
                    Parameter parameter = this.readParameter(step, (XdmNode)object22);
                    parameter.setStep(step);
                    parameter.setPosition(n4++);
                    step.addParameter(parameter);
                    continue;
                }
                if (XProcConstants.p_log.equals((Object)qName)) {
                    Log log = this.readLog((XdmNode)object22);
                    if (log.getPort() == null) {
                        throw XProcException.staticError(26, (XdmNode)object22, "A p:log must specify a port.");
                    }
                    if (log.getPort() != null && hashtable2.containsKey(log.getPort())) {
                        throw XProcException.staticError(26, (XdmNode)object22, "A p:log was specified more than once for the same port: " + log.getPort());
                    }
                    hashtable2.put(log.getPort(), log);
                    continue;
                }
                if (XProcConstants.p_import.equals((Object)qName)) {
                    vector.add((XdmNode)object22);
                    continue;
                }
                if (XProcConstants.p_serialization.equals((Object)qName)) {
                    Serialization serialization = this.readSerialization((XdmNode)object22);
                    object = serialization.getPort();
                    if (object == null || hashtable.containsKey(object)) {
                        throw XProcException.staticError(39, (XdmNode)object22, "A p:serialization must specify a port and can only be specified once.");
                    }
                    hashtable.put(object, serialization);
                    continue;
                }
                throw XProcException.staticError(44, (XdmNode)object22, "Unexpected element: " + qName);
            }
            if (object22.getNodeKind() == XdmNodeKind.TEXT) {
                throw XProcException.staticError(37, (XdmNode)object22, "Unexpected text: " + object22.getStringValue());
            }
            bl3 = true;
            vector.add((XdmNode)object22);
        }
        int n5 = 0;
        object22 = null;
        for (Input input : step.inputs()) {
            if (input.getParameterInput()) continue;
            ++n5;
            object22 = input;
        }
        if (n5 == 1 && !((Port)object22).getPrimary() && !((Port)object22).getPrimarySet()) {
            ((Port)object22).setPrimary(true);
        }
        n5 = 0;
        object22 = null;
        for (Input input : step.inputs()) {
            if (!input.getParameterInput()) continue;
            ++n5;
            object22 = input;
        }
        if (n5 == 1 && !((Port)object22).getPrimary() && !((Port)object22).getPrimarySet()) {
            ((Port)object22).setPrimary(true);
        }
        int n6 = 0;
        Object var16_29 = null;
        for (Output output : step.outputs()) {
            ++n6;
            Output output2 = output;
        }
        if (n6 == 1 && !var16_30.getPrimary() && !var16_30.getPrimarySet()) {
            var16_30.setPrimary(true);
        }
        if (XProcConstants.p_declare_step.equals((Object)step.getType())) {
            for (Output output : step.outputs()) {
                String string = output.getPort();
                if (!hashtable.containsKey(string)) continue;
                Serialization serialization = (Serialization)hashtable.get(string);
                output.setSerialization(serialization);
                hashtable.remove(string);
            }
            if (hashtable.size() != 0) {
                throw XProcException.staticError(39, step.getNode(), "A p:serialization specifies a non-existant port.");
            }
        }
        for (String string : hashtable2.keySet()) {
            step.addLog((Log)hashtable2.get(string));
        }
        boolean bl4 = false;
        for (XdmNode xdmNode : vector) {
            bl4 = bl4 || XProcConstants.p_variable.equals((Object)xdmNode.getNodeName());
        }
        if (bl4) {
            if (!bl2) {
                throw XProcException.staticError(44, step.getNode(), "Variables are not allowed here");
            }
            if (!XProcConstants.p_pipeline.equals((Object)step.getType()) && !XProcConstants.p_declare_step.equals((Object)step.getType())) {
                while (vector.size() > 0 && XProcConstants.p_variable.equals((Object)vector.get(0).getNodeName())) {
                    Variable variable = this.readVariable(step, vector.remove(0));
                    step.addVariable(variable);
                }
            }
        }
        return vector.size() == 0 ? null : vector;
    }

    private Input readInput(Step step, XdmNode xdmNode) {
        QName qName = xdmNode.getNodeName();
        if (XProcConstants.p_input.equals((Object)qName)) {
            this.checkAttributes(xdmNode, new String[]{"kind", "port", "primary", "sequence", "select"}, false);
        } else if (XProcConstants.p_iteration_source.equals((Object)qName)) {
            this.checkAttributes(xdmNode, new String[]{"select"}, false);
        } else if (XProcConstants.p_viewport_source.equals((Object)qName) || XProcConstants.p_xpath_context.equals((Object)qName)) {
            this.checkAttributes(xdmNode, null, false);
        } else {
            throw new UnsupportedOperationException("Unexpected name in readInput: " + qName);
        }
        String string = xdmNode.getAttributeValue(new QName("kind"));
        String string2 = this.checkNCName(xdmNode.getAttributeValue(new QName("port")));
        String string3 = xdmNode.getAttributeValue(new QName("primary"));
        String string4 = xdmNode.getAttributeValue(new QName("sequence"));
        String string5 = xdmNode.getAttributeValue(new QName("select"));
        if (string2 == null && XProcConstants.p_input.equals((Object)xdmNode.getNodeName())) {
            throw XProcException.staticError(38, xdmNode, "You must specify a port name for all p:input ports.");
        }
        if (string == null) {
            string = "document";
        }
        if (!"document".equals(string) && !"parameter".equals(string)) {
            this.runtime.error(null, xdmNode, "Kind must be document or parameter", XProcConstants.staticError(33));
        }
        if (string3 != null && !"true".equals(string3) && !"false".equals(string3)) {
            this.runtime.error(null, xdmNode, "Primary must be 'true' or 'false'", XProcConstants.staticError(40));
        }
        if (string4 != null) {
            if ("parameter".equals(string)) {
                if (!"true".equals(string4)) {
                    this.runtime.error(null, xdmNode, "Sequence cannot be 'false' on a parameter input", XProcConstants.staticError(40));
                }
            } else if (!"true".equals(string4) && !"false".equals(string4)) {
                this.runtime.error(null, xdmNode, "Sequence must be 'true' or 'false'", XProcConstants.staticError(40));
            }
        }
        if (XProcConstants.p_iteration_source.equals((Object)qName)) {
            string2 = "#iteration-source";
            string4 = "true";
            string3 = "true";
        } else if (XProcConstants.p_viewport_source.equals((Object)qName)) {
            string2 = "#viewport-source";
            string4 = "false";
            string3 = "true";
        } else if (XProcConstants.p_xpath_context.equals((Object)qName)) {
            string2 = "#xpath-context";
            string4 = "false";
            string3 = "true";
        } else if (string2 == null) {
            throw XProcException.staticError(44, xdmNode, "No port name specified on input.");
        }
        Input input = new Input(this.runtime, xdmNode);
        input.setPort(string2);
        input.setSequence(string4);
        input.setPrimary(string3);
        if ("parameter".equals(string)) {
            input.setParameterInput();
            input.setSequence(true);
        }
        input.setDebugReader(xdmNode.getAttributeValue(new QName("http://xmlcalabash.com/ns/extensions", "debug-reader")) != null);
        input.setDebugWriter(xdmNode.getAttributeValue(new QName("http://xmlcalabash.com/ns/extensions", "debug-writer")) != null);
        if (string5 != null) {
            input.setSelect(string5);
        }
        for (XdmNode xdmNode2 : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
            Binding binding = this.readBinding(step, xdmNode2);
            if (binding == null) continue;
            input.addBinding(binding);
        }
        this.checkExtensionAttributes(xdmNode, input);
        return input;
    }

    private Output readOutput(Step step, XdmNode xdmNode) {
        this.checkAttributes(xdmNode, new String[]{"port", "primary", "sequence"}, false);
        String string = this.checkNCName(xdmNode.getAttributeValue(new QName("port")));
        if (string == null) {
            throw XProcException.staticError(38, xdmNode, "You must specify a port name for all p:output ports.");
        }
        String string2 = xdmNode.getAttributeValue(new QName("primary"));
        String string3 = xdmNode.getAttributeValue(new QName("sequence"));
        Output output = new Output(this.runtime, xdmNode);
        output.setPort(string);
        output.setSequence(string3);
        output.setPrimary(string2);
        for (XdmNode xdmNode2 : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
            Binding binding = this.readBinding(step, xdmNode2);
            if (binding == null) continue;
            output.addBinding(binding);
        }
        this.checkExtensionAttributes(xdmNode, output);
        return output;
    }

    private Binding readBinding(Step step, XdmNode xdmNode) {
        Binding binding = null;
        QName qName = xdmNode.getNodeName();
        if (XProcConstants.p_pipe.equals((Object)qName)) {
            binding = this.readPipe(xdmNode);
        } else if (XProcConstants.p_document.equals((Object)qName)) {
            binding = this.readDocument(xdmNode);
        } else if (XProcConstants.p_inline.equals((Object)qName)) {
            binding = this.readInline(step, xdmNode);
        } else if (XProcConstants.p_empty.equals((Object)qName)) {
            binding = this.readEmpty(xdmNode);
        } else if (XProcConstants.p_data.equals((Object)qName)) {
            binding = this.readData(xdmNode);
        } else {
            throw XProcException.staticError(44, xdmNode, "Unexpected in input: " + qName);
        }
        this.checkExtensionAttributes(xdmNode, binding);
        return binding;
    }

    private PipeNameBinding readPipe(XdmNode xdmNode) {
        this.checkAttributes(xdmNode, new String[]{"port", "step"}, false);
        String string = this.checkNCName(xdmNode.getAttributeValue(new QName("step")));
        String string2 = this.checkNCName(xdmNode.getAttributeValue(new QName("port")));
        if (string == null || string2 == null) {
            if (string == null) {
                throw XProcException.staticError(38, xdmNode, "Missing step attribute.");
            }
            throw XProcException.staticError(38, xdmNode, "Missing port attribute.");
        }
        PipeNameBinding pipeNameBinding = new PipeNameBinding(this.runtime, xdmNode);
        pipeNameBinding.setStep(string);
        pipeNameBinding.setPort(string2);
        RelevantNodes relevantNodes = new RelevantNodes(this.runtime, xdmNode, Axis.CHILD);
        Iterator<XdmNode> iterator = relevantNodes.iterator();
        if (iterator.hasNext()) {
            XdmNode xdmNode2 = iterator.next();
            throw new IllegalArgumentException("Unexpected in pipe: " + xdmNode2.getNodeName());
        }
        this.checkExtensionAttributes(xdmNode, pipeNameBinding);
        return pipeNameBinding;
    }

    private DocumentBinding readDocument(XdmNode xdmNode) {
        this.checkAttributes(xdmNode, new String[]{"href"}, false);
        String string = xdmNode.getAttributeValue(new QName("href"));
        DocumentBinding documentBinding = new DocumentBinding(this.runtime, xdmNode);
        documentBinding.setHref(string);
        Iterator<XdmNode> iterator = new RelevantNodes(this.runtime, xdmNode, Axis.CHILD).iterator();
        if (iterator.hasNext()) {
            XdmNode xdmNode2 = iterator.next();
            throw new IllegalArgumentException("Unexpected in document: " + xdmNode2.getNodeName());
        }
        this.checkExtensionAttributes(xdmNode, documentBinding);
        return documentBinding;
    }

    private DataBinding readData(XdmNode xdmNode) {
        Iterator<XdmNode> iterator;
        this.checkAttributes(xdmNode, new String[]{"href", "wrapper", "wrapper-namespace", "wrapper-prefix", "content-type"}, false);
        String string = xdmNode.getAttributeValue(new QName("href"));
        String string2 = xdmNode.getAttributeValue(new QName("wrapper"));
        String string3 = xdmNode.getAttributeValue(new QName("wrapper-prefix"));
        String string4 = xdmNode.getAttributeValue(new QName("wrapper-namespace"));
        String string5 = xdmNode.getAttributeValue(new QName("content-type"));
        if (string3 != null && string4 == null) {
            throw XProcException.dynamicError(34, xdmNode, "You cannot specify a prefix without a namespace.");
        }
        if (string4 != null && string2 == null) {
            throw XProcException.dynamicError(34, xdmNode, "You cannot specify a namespace without a wrapper.");
        }
        if (string4 != null && string2 != null && string2.indexOf(":") >= 0) {
            throw XProcException.dynamicError(34, xdmNode, "You cannot specify a namespace if the wrapper name contains a colon.");
        }
        if (string4 == null && string2 != null && string2.indexOf(":") <= 0) {
            throw XProcException.dynamicError(25, xdmNode, "FIXME: what error is this?");
        }
        DataBinding dataBinding = new DataBinding(this.runtime, xdmNode);
        dataBinding.setHref(string);
        if (string2 != null) {
            if (string2.indexOf(":") > 0) {
                dataBinding.setWrapper(new QName(string2, xdmNode));
            } else if (string3 != null) {
                dataBinding.setWrapper(new QName(string3, string4, string2));
            } else {
                dataBinding.setWrapper(new QName(string4, string2));
            }
        }
        if (string5 != null) {
            dataBinding.setContentType(string5);
        }
        if ((iterator = new RelevantNodes(this.runtime, xdmNode, Axis.CHILD).iterator()).hasNext()) {
            XdmNode xdmNode2 = iterator.next();
            throw new IllegalArgumentException("Unexpected in document: " + xdmNode2.getNodeName());
        }
        this.checkExtensionAttributes(xdmNode, dataBinding);
        return dataBinding;
    }

    private EmptyBinding readEmpty(XdmNode xdmNode) {
        this.checkAttributes(xdmNode, new String[0], false);
        EmptyBinding emptyBinding = new EmptyBinding(this.runtime, xdmNode);
        Iterator<XdmNode> iterator = new RelevantNodes(this.runtime, xdmNode, Axis.CHILD).iterator();
        if (iterator.hasNext()) {
            XdmNode xdmNode2 = iterator.next();
            throw new IllegalArgumentException("Unexpected in empty: " + xdmNode2.getNodeName());
        }
        this.checkExtensionAttributes(xdmNode, emptyBinding);
        return emptyBinding;
    }

    private InlineBinding readInline(Step step, XdmNode xdmNode) {
        Object object;
        this.checkAttributes(xdmNode, new String[]{"exclude-inline-prefixes"}, false);
        InlineBinding inlineBinding = new InlineBinding(this.runtime, xdmNode);
        boolean bl = false;
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
        while (xdmSequenceIterator.hasNext()) {
            object = (XdmNode)xdmSequenceIterator.next();
            if (object.getNodeKind() == XdmNodeKind.ELEMENT) {
                if (bl) {
                    throw new IllegalArgumentException("Not a well-formed inline document");
                }
                bl = true;
            }
            inlineBinding.addNode((XdmNode)object);
        }
        object = S9apiUtils.excludeInlinePrefixes(xdmNode, xdmNode.getAttributeValue(_exclude_inline_prefixes));
        while (!(step instanceof DeclareStep)) {
            step = step.parent;
        }
        if (step instanceof DeclareStep) {
            HashSet<String> hashSet = ((DeclareStep)step).getExcludeInlineNamespaces();
            if (hashSet != null) {
                for (String string : hashSet) {
                    ((HashSet)object).add(string);
                }
            }
        } else {
            throw new UnsupportedOperationException("This can't happen: parent of inline is not a step!?");
        }
        this.checkExtensionAttributes(xdmNode, inlineBinding);
        inlineBinding.excludeNamespaces((HashSet<String>)object);
        return inlineBinding;
    }

    private Option readOption(Step step, XdmNode xdmNode) {
        this.checkAttributes(xdmNode, new String[]{"name", "required", "select"}, false);
        String string = xdmNode.getAttributeValue(new QName("name"));
        String string2 = xdmNode.getAttributeValue(new QName("required"));
        String string3 = xdmNode.getAttributeValue(new QName("select"));
        String string4 = xdmNode.getAttributeValue(XProcConstants.cx_type);
        if (string == null) {
            throw XProcException.staticError(38, xdmNode, "Attribute \"name\" required on p:with-option");
        }
        QName qName = string.contains(":") ? new QName(string, xdmNode) : new QName(string);
        if ("http://www.w3.org/ns/xproc".equals(qName.getNamespaceURI())) {
            throw XProcException.staticError(28, xdmNode, "You cannot specify an option in the p: namespace.");
        }
        if (string2 != null && !"false".equals(string2) && !"true".equals(string2)) {
            throw XProcException.staticError(19, xdmNode, "The required attribute must be 'true' or 'false'.");
        }
        Option option = new Option(this.runtime, xdmNode);
        option.setName(qName);
        option.setRequired(string2);
        option.setSelect(string3);
        option.setType(string4, xdmNode);
        this.readNamespaceBindings(step, option, xdmNode, string3);
        this.checkExtensionAttributes(xdmNode, option);
        return option;
    }

    private Parameter readParameter(Step step, XdmNode xdmNode) {
        this.checkAttributes(xdmNode, new String[]{"port", "name", "select"}, false);
        String string = xdmNode.getAttributeValue(new QName("name"));
        String string2 = xdmNode.getAttributeValue(new QName("select"));
        String string3 = this.checkNCName(xdmNode.getAttributeValue(new QName("port")));
        if (string == null) {
            this.runtime.error(null, xdmNode, "Attribute \"name\" required on p:with-param", XProcConstants.staticError(38));
        }
        Parameter parameter = new Parameter(this.runtime, xdmNode);
        parameter.setPort(string3);
        if (string.contains(":")) {
            parameter.setName(new QName(string, xdmNode));
        } else {
            parameter.setName(new QName("", string));
        }
        parameter.setSelect(string2);
        this.readNamespaceBindings(step, parameter, xdmNode, string2);
        this.checkExtensionAttributes(xdmNode, parameter);
        return parameter;
    }

    private Variable readVariable(Step step, XdmNode xdmNode) {
        this.checkAttributes(xdmNode, new String[]{"name", "select"}, false);
        String string = xdmNode.getAttributeValue(new QName("name"));
        String string2 = xdmNode.getAttributeValue(new QName("select"));
        QName qName = new QName(string, xdmNode);
        if ("http://www.w3.org/ns/xproc".equals(qName.getNamespaceURI())) {
            throw XProcException.staticError(28, xdmNode, "You cannot specify a variable in the p: namespace.");
        }
        Variable variable = new Variable(this.runtime, xdmNode);
        variable.setName(qName);
        variable.setSelect(string2);
        this.readNamespaceBindings(step, variable, xdmNode, string2);
        this.checkExtensionAttributes(xdmNode, variable);
        return variable;
    }

    private void readNamespaceBindings(Step step, EndPoint endPoint, XdmNode xdmNode, String string) {
        boolean bl = false;
        for (XdmNode xdmNode2 : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
            Object object;
            QName qName = xdmNode2.getNodeName();
            if (XProcConstants.p_namespaces.equals((Object)qName)) {
                object = new NamespaceBinding(this.runtime, xdmNode2);
                this.checkAttributes(xdmNode2, new String[]{"binding", "element", "except-prefixes"}, false);
                String string2 = xdmNode2.getAttributeValue(new QName("binding"));
                if (string2 != null) {
                    ((NamespaceBinding)object).setBinding(string2);
                }
                if ((string2 = xdmNode2.getAttributeValue(new QName("element"))) != null) {
                    ((NamespaceBinding)object).setXPath(string2);
                }
                if ((string2 = xdmNode2.getAttributeValue(new QName("except-prefixes"))) != null) {
                    for (String string3 : string2.split("\\s+")) {
                        try {
                            QName qName2 = new QName(string3 + ":localName", xdmNode2);
                            ((NamespaceBinding)object).addExcludedNamespace(qName2.getNamespaceURI());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw XProcException.staticError(51, xdmNode, "Unbound prefix in except-prefixes: " + string3);
                        }
                    }
                }
                ((ComputableValue)((Object)endPoint)).addNamespaceBinding((NamespaceBinding)object);
                Iterator<XdmNode> iterator = new RelevantNodes(this.runtime, xdmNode2, Axis.CHILD).iterator();
                if (!iterator.hasNext()) continue;
                XdmNode xdmNode3 = (XdmNode)iterator.next();
                throw XProcException.staticError(44, xdmNode2, "p:namespaces must be empty");
            }
            object = this.readBinding(step, xdmNode2);
            if (object == null) continue;
            if (XProcConstants.p_option.equals((Object)xdmNode.getNodeName())) {
                throw XProcException.staticError(44, xdmNode, "No bindings allowed.");
            }
            endPoint.addBinding((Binding)object);
        }
        if (!bl) {
            Object object;
            if (string != null && string.matches("^\\$[a-zA-Z_][-a-zA-Z0-9_]*$")) {
                object = string.substring(1);
            }
            object = new NamespaceBinding(this.runtime, xdmNode);
            ((ComputableValue)((Object)endPoint)).addNamespaceBinding((NamespaceBinding)object);
        }
    }

    private Serialization readSerialization(XdmNode xdmNode) {
        String string;
        Object object;
        this.checkAttributes(xdmNode, new String[]{"port", "byte-order-mark", "cdata-section-elements", "doctype-public", "doctype-system", "encoding", "escape-uri-attributes", "include-content-type", "indent", "media-type", "method", "normalization-form", "omit-xml-declaration", "standalone", "undeclare-prefixes", "version"}, false);
        Serialization serialization = new Serialization(this.runtime, xdmNode);
        String string2 = xdmNode.getAttributeValue(new QName("port"));
        serialization.setPort(string2);
        string2 = xdmNode.getAttributeValue(new QName("byte-order-mark"));
        if (string2 != null) {
            this.checkBoolean(xdmNode, "byte-order-mark", string2);
            serialization.setByteOrderMark("true".equals(string2));
        }
        if ((string2 = xdmNode.getAttributeValue(new QName("cdata-section-elements"))) != null) {
            throw new UnsupportedOperationException("cdata-section-elements not yet supported");
        }
        string2 = xdmNode.getAttributeValue(new QName("doctype-public"));
        serialization.setDoctypePublic(string2);
        string2 = xdmNode.getAttributeValue(new QName("doctype-system"));
        serialization.setDoctypeSystem(string2);
        string2 = xdmNode.getAttributeValue(new QName("encoding"));
        serialization.setEncoding(string2);
        string2 = xdmNode.getAttributeValue(new QName("escape-uri-attributes"));
        if (string2 != null) {
            this.checkBoolean(xdmNode, "escape-uri-attributes", string2);
            serialization.setEscapeURIAttributes("true".equals(string2));
        }
        if ((string2 = xdmNode.getAttributeValue(new QName("include-content-type"))) != null) {
            this.checkBoolean(xdmNode, "include-content-type", string2);
            serialization.setIncludeContentType("true".equals(string2));
        }
        if ((string2 = xdmNode.getAttributeValue(new QName("indent"))) != null) {
            this.checkBoolean(xdmNode, "indent", string2);
            serialization.setIndent("true".equals(string2));
        }
        string2 = xdmNode.getAttributeValue(new QName("media-type"));
        serialization.setMediaType(string2);
        string2 = xdmNode.getAttributeValue(new QName("method"));
        if (string2 != null) {
            object = new QName(string2, xdmNode);
            if ("".equals(object.getPrefix())) {
                string = object.getLocalName();
                if ("html".equals(string) || "xhtml".equals(string) || "text".equals(string) || "xml".equals(string)) {
                    serialization.setMethod((QName)object);
                } else {
                    this.runtime.error(null, xdmNode, "Only the xml, xhtml, html, and text serialization methods are supported.", XProcConstants.stepError(1));
                }
            } else {
                this.runtime.error(null, xdmNode, "Only the xml, xhtml, html, and text serialization methods are supported.", XProcConstants.stepError(1));
            }
        }
        string2 = xdmNode.getAttributeValue(new QName("normalization-form"));
        serialization.setNormalizationForm(string2);
        string2 = xdmNode.getAttributeValue(new QName("omit-xml-declaration"));
        if (string2 != null) {
            this.checkBoolean(xdmNode, "omit-xml-declaration", string2);
            serialization.setOmitXMLDeclaration("true".equals(string2));
        }
        string2 = xdmNode.getAttributeValue(new QName("standalone"));
        serialization.setStandalone(string2);
        string2 = xdmNode.getAttributeValue(new QName("undeclare-prefixes"));
        if (string2 != null) {
            this.checkBoolean(xdmNode, "undeclare-prefixes", string2);
            serialization.setUndeclarePrefixes("true".equals(string2));
        }
        string2 = xdmNode.getAttributeValue(new QName("version"));
        serialization.setVersion(string2);
        object = new RelevantNodes(this.runtime, xdmNode, Axis.CHILD).iterator();
        if (object.hasNext()) {
            string = (XdmNode)object.next();
            throw XProcException.staticError(44, xdmNode, "p:serialization must be empty.");
        }
        this.checkExtensionAttributes(xdmNode, serialization);
        return serialization;
    }

    private void checkBoolean(XdmNode xdmNode, String string, String string2) {
        if (string2 != null && !"true".equals(string2) && !"false".equals(string2)) {
            this.runtime.error(null, xdmNode, string + " on serialization must be 'true' or 'false'", XProcConstants.staticError(40));
        }
    }

    private Log readLog(XdmNode xdmNode) {
        this.checkAttributes(xdmNode, new String[]{"port", "href"}, false);
        String string = this.checkNCName(xdmNode.getAttributeValue(new QName("port")));
        String string2 = xdmNode.getAttributeValue(new QName("href"));
        URI uRI = null;
        if (string2 != null) {
            uRI = xdmNode.getBaseURI().resolve(string2);
        }
        Log log = new Log(this.runtime, xdmNode);
        log.setPort(string);
        log.setHref(uRI);
        this.checkExtensionAttributes(xdmNode, log);
        Iterator<XdmNode> iterator = new RelevantNodes(this.runtime, xdmNode, Axis.CHILD).iterator();
        if (iterator.hasNext()) {
            XdmNode xdmNode2 = iterator.next();
            throw XProcException.staticError(44, xdmNode, "p:log must be empty");
        }
        this.checkExtensionAttributes(xdmNode, log);
        return log;
    }

    private Step readStep(Step step, XdmNode xdmNode) {
        QName qName = xdmNode.getNodeName();
        if (XProcConstants.p_declare_step.equals((Object)qName) || XProcConstants.p_pipeline.equals((Object)qName)) {
            return this.readDeclareStep(xdmNode);
        }
        if (XProcConstants.p_import.equals((Object)qName)) {
            return this.readImport(xdmNode);
        }
        if (XProcConstants.p_for_each.equals((Object)qName)) {
            return this.readForEach(step, xdmNode);
        }
        if (XProcConstants.p_viewport.equals((Object)qName)) {
            return this.readViewport(step, xdmNode);
        }
        if (XProcConstants.p_choose.equals((Object)qName)) {
            return this.readChoose(step, xdmNode);
        }
        if (XProcConstants.p_when.equals((Object)qName)) {
            return this.readWhen(step, xdmNode);
        }
        if (XProcConstants.p_otherwise.equals((Object)qName)) {
            return this.readOtherwise(step, xdmNode);
        }
        if (XProcConstants.p_group.equals((Object)qName)) {
            return this.readGroup(step, xdmNode);
        }
        if (XProcConstants.p_try.equals((Object)qName)) {
            return this.readTry(step, xdmNode);
        }
        if (XProcConstants.p_catch.equals((Object)qName)) {
            return this.readCatch(step, xdmNode);
        }
        if (XProcConstants.cx_until_unchanged.equals((Object)qName)) {
            return this.readUntilUnchanged(step, xdmNode);
        }
        DeclareStep declareStep = null;
        declareStep = step == null ? this.runtime.getBuiltinDeclaration(qName) : ((DeclareStep)step).getStepDeclaration(qName);
        if (declareStep == null) {
            throw XProcException.staticError(44, xdmNode, "Not a step: " + qName);
        }
        this.checkAttributes(xdmNode, new String[]{"name"}, true);
        String string = this.checkNCName(xdmNode.getAttributeValue(new QName("name")));
        Step step2 = new Step(this.runtime, xdmNode, qName, string);
        step2.setDeclaration(declareStep);
        step2.parent = step;
        boolean bl = "http://www.w3.org/ns/xproc".equals(xdmNode.getNodeName().getNamespaceURI());
        for (Object object : new RelevantNodes(this.runtime, xdmNode, Axis.ATTRIBUTE)) {
            QName qName2 = object.getNodeName();
            if (bl && qName2.equals((Object)_use_when) || !bl && qName2.equals((Object)p_use_when)) continue;
            if ("".equals(qName2.getNamespaceURI())) {
                if ("name".equals(qName2.getLocalName())) continue;
                Option option = new Option(this.runtime, xdmNode);
                option.setName(new QName("", qName2.getLocalName()));
                option.setSelect("'" + object.getStringValue().replace("'", "''") + "'");
                option.addNamespaceBinding(new NamespaceBinding(step2.getXProc(), xdmNode));
                step2.addOption(option);
                continue;
            }
            step2.addExtensionAttribute((XdmNode)object);
        }
        Vector<XdmNode> vector = this.readSignature(step2);
        if (vector != null) {
            Object object;
            object = "A " + qName + " step must contain only a signature.";
            object = XProcConstants.p_option.equals((Object)((XdmNode)vector.get(0)).getNodeName()) ? (String)object + " p:option is not allowed, did you mean p:with-option instead?" : (XProcConstants.p_parameter.equals((Object)((XdmNode)vector.get(0)).getNodeName()) ? (String)object + " p:parameter is not allowed, did you mean p:with-param instead?" : (String)object + " " + ((XdmNode)vector.get(0)).getNodeName() + " not allowed.");
            throw XProcException.staticError(44, (XdmNode)vector.get(0), (String)object);
        }
        return step2;
    }

    private DeclareStep readDeclareStep(XdmNode xdmNode) {
        Object object;
        Object object2;
        Object object322;
        QName qName = xdmNode.getNodeName();
        if (!qName.equals((Object)XProcConstants.p_declare_step) && !qName.equals((Object)XProcConstants.p_pipeline)) {
            throw XProcException.staticError(59, xdmNode, "Expected p:declare-step or p:pipeline, got " + qName);
        }
        this.checkAttributes(xdmNode, new String[]{"type", "name", "version", "psvi-required", "xpath-version", "exclude-inline-prefixes"}, false);
        String string = this.checkNCName(xdmNode.getAttributeValue(_name));
        String string2 = xdmNode.getAttributeValue(_type);
        QName qName2 = null;
        if (string2 == null) {
            qName2 = TypeUtils.generateUniqueType();
        } else {
            if (string2.indexOf(":") <= 0) {
                throw XProcException.staticError(25, xdmNode, "Type must be in a namespace.");
            }
            qName2 = new QName(string2, xdmNode);
            if (!this.loadingStandardLibrary && "http://www.w3.org/ns/xproc".equals(qName2.getNamespaceURI())) {
                throw XProcException.staticError(25, xdmNode, "Type cannot be in the p: namespace.");
            }
        }
        if ("http://www.w3.org/ns/xproc".equals(qName2.getNamespaceURI()) && !this.declStack.isEmpty()) {
            throw XProcException.staticError(25, xdmNode, "Additional steps must not be declared in the XProc namespace.");
        }
        DeclareStep declareStep = new DeclareStep(this.runtime, xdmNode, string);
        declareStep.setVersion(this.inheritedVersion(xdmNode));
        boolean bl = this.booleanAttr(xdmNode.getAttributeValue(new QName("psvi-required")));
        String string3 = xdmNode.getAttributeValue(new QName("xpath-version"));
        if (!"1.0".equals(string3) && string3 != null && !"2.0".equals(string3)) {
            throw XProcException.dynamicError(27, xdmNode, "XPath version must be 1.0 or 2.0.");
        }
        for (Object object322 : new RelevantNodes(this.runtime, xdmNode, Axis.ATTRIBUTE)) {
            object2 = object322.getNodeName();
            if ("".equals(object2.getNamespaceURI())) {
                if ("type".equals(object2.getLocalName()) || "name".equals(object2.getLocalName()) || "version".equals(object2.getLocalName()) || "use-when".equals(object2.getLocalName()) || "psvi-required".equals(object2.getLocalName()) || "xpath-version".equals(object2.getLocalName()) || "exclude-inline-prefixes".equals(object2.getLocalName())) continue;
                throw XProcException.staticError(44, xdmNode, "Attribute not allowed: " + object2.getLocalName());
            }
            declareStep.addExtensionAttribute((XdmNode)object322);
        }
        declareStep.setDeclaredType(qName2);
        declareStep.setPsviRequired(bl);
        declareStep.setXPathVersion(string3);
        HashSet<String> hashSet = S9apiUtils.excludeInlinePrefixes(xdmNode, xdmNode.getAttributeValue(_exclude_inline_prefixes));
        if (!this.declStack.isEmpty()) {
            object322 = this.declStack.peek();
            for (String iterator2 : ((DeclareStep)object322).getExcludeInlineNamespaces()) {
                hashSet.add(iterator2);
            }
        }
        if (xdmNode.getParent() != null && XProcConstants.p_library.equals((Object)(object322 = xdmNode.getParent()).getNodeName()) && object322.getAttributeValue(_exclude_inline_prefixes) != null) {
            object2 = S9apiUtils.excludeInlinePrefixes((XdmNode)object322, object322.getAttributeValue(_exclude_inline_prefixes));
            Iterator iterator = ((HashSet)object2).iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                hashSet.add((String)object);
            }
        }
        declareStep.setExcludeInlineNamespaces(hashSet);
        if (qName.equals((Object)XProcConstants.p_pipeline)) {
            object322 = new Input(this.runtime, xdmNode);
            ((Port)object322).setPort("source");
            ((Port)object322).setPrimary(true);
            ((Port)object322).setSequence(false);
            declareStep.addInput((Input)object322);
            object322 = new Input(this.runtime, xdmNode);
            ((Port)object322).setPort("parameters");
            ((Input)object322).setParameterInput(true);
            ((Port)object322).setPrimary(true);
            ((Port)object322).setSequence(true);
            declareStep.addInput((Input)object322);
            object2 = new Output(this.runtime, xdmNode);
            ((Port)object2).setPort("result");
            ((Port)object2).setPrimary(true);
            ((Port)object2).setSequence(false);
            declareStep.addOutput((Output)object2);
        }
        declareStep.setAtomic((object322 = this.readSignature(declareStep)) == null);
        if (this.declStack.isEmpty()) {
            this.runtime.declareStep(declareStep.getDeclaredType(), declareStep);
        } else {
            this.declStack.peek().declareStep(declareStep.getDeclaredType(), declareStep);
        }
        if (!this.declStack.isEmpty()) {
            declareStep.setParentDecl(this.declStack.peek());
        }
        this.declStack.push(declareStep);
        for (Input input : declareStep.inputs()) {
            if (declareStep.isAtomic()) {
                if (input.getBinding().size() == 0) continue;
                this.runtime.error(null, input.getNode(), "Input bindings are not allowed on an atomic step", XProcConstants.staticError(42));
                continue;
            }
            if (input.getPort().startsWith("|")) continue;
            for (Binding binding : input.getBinding()) {
                if (binding.getBindingType() != 1) continue;
                this.runtime.error(null, input.getNode(), "Default input bindings cannot use p:pipe", XProcConstants.staticError(44));
            }
        }
        for (Output output : declareStep.outputs()) {
            object = declareStep.getInput("|" + output.getPort());
            if (!declareStep.isAtomic() || object == null) continue;
            this.runtime.error(null, output.getNode(), "Output bindings are not allowed on an atomic step", XProcConstants.staticError(29));
        }
        object2 = new Vector();
        if (object322 != null) {
            Iterator iterator = ((Vector)object322).iterator();
            while (iterator.hasNext()) {
                object = (XdmNode)iterator.next();
                if (XProcConstants.p_variable.equals((Object)object.getNodeName())) {
                    Variable variable = this.readVariable(declareStep, (XdmNode)object);
                    declareStep.addVariable(variable);
                    continue;
                }
                if (XProcConstants.p_declare_step.equals((Object)object.getNodeName()) || XProcConstants.p_pipeline.equals((Object)object.getNodeName())) {
                    DeclareStep declareStep2 = (DeclareStep)this.readStep(declareStep, (XdmNode)object);
                    continue;
                }
                if (XProcConstants.p_import.equals((Object)object.getNodeName())) {
                    Import import_ = (Import)this.readStep(declareStep, (XdmNode)object);
                    XdmNode xdmNode2 = import_.getRoot();
                    if (xdmNode2 == null) continue;
                    import_.setLibrary(this.readLibrary(declareStep, xdmNode2));
                    continue;
                }
                ((Vector)object2).add(object);
            }
            declareStep.checkPrimaryIO();
            object322 = object2;
        }
        declareStep.setXmlContent((Vector<XdmNode>)object322);
        this.declStack.pop();
        return declareStep;
    }

    private void parseDeclareStepBodyPassTwo(DeclareStep declareStep) {
        declareStep.setBodyParsed(true);
        for (DeclareStep object : declareStep.getStepDeclarations()) {
            this.parseDeclareStepBodyPassTwo(object);
        }
        Vector<XdmNode> vector = declareStep.getXmlContent();
        if (vector != null) {
            for (XdmNode xdmNode : vector) {
                Step step = this.readStep(declareStep, xdmNode);
                declareStep.addStep(step);
            }
        }
    }

    private Double inheritedVersion(XdmNode xdmNode) {
        String string;
        XdmNode xdmNode2 = xdmNode.getParent();
        if ((XProcConstants.p_declare_step.equals((Object)xdmNode.getNodeName()) || XProcConstants.p_pipeline.equals((Object)xdmNode.getNodeName()) || XProcConstants.p_library.equals((Object)xdmNode.getNodeName())) && (string = xdmNode.getAttributeValue(_version)) != null) {
            TypeUtils.checkType(this.runtime, string, XProcConstants.xs_decimal, xdmNode, err_XS0063);
            return Double.parseDouble(string);
        }
        if (xdmNode2 == null) {
            throw XProcException.staticError(62, xdmNode, "Version attribute is required.");
        }
        return this.inheritedVersion(xdmNode2);
    }

    private Import readImport(XdmNode xdmNode) {
        XdmNode xdmNode2;
        this.checkAttributes(xdmNode, new String[]{"href"}, false);
        String string = xdmNode.getAttributeValue(_href);
        URI uRI = xdmNode.getBaseURI().resolve(string);
        XdmNode xdmNode3 = null;
        Object object = new RelevantNodes(this.runtime, xdmNode, Axis.CHILD).iterator();
        while (object.hasNext()) {
            xdmNode3 = xdmNode2 = object.next();
        }
        if (xdmNode3 != null) {
            throw new UnsupportedOperationException("p:import must be empty.");
        }
        object = new Import(this.runtime, xdmNode);
        ((Import)object).setHref(uRI);
        try {
            xdmNode2 = uRI.toASCIIString().equals("http://xmlcalabash.com/extension/steps/library-1.0.xpl") ? this.loadExtensionLibrary() : this.runtime.parse(string, xdmNode.getBaseURI().toASCIIString());
        }
        catch (XProcException xProcException) {
            if (XProcConstants.dynamicError(11).equals((Object)xProcException.getErrorCode())) {
                throw XProcException.staticError(52, xdmNode, xProcException.getCause(), "Cannot import: " + uRI.toASCIIString());
            }
            throw xProcException;
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
        uRI = xdmNode2.getBaseURI();
        XdmNode xdmNode4 = S9apiUtils.getDocumentElement(xdmNode2);
        boolean bl = this.topLevelImports.contains(uRI.toASCIIString());
        if (!bl && !this.declStack.isEmpty()) {
            bl = this.declStack.peek().imported(uRI.toASCIIString());
        }
        if (bl) {
            return object;
        }
        if (!this.declStack.isEmpty()) {
            this.declStack.peek().addImport(uRI.toASCIIString());
        } else {
            this.topLevelImports.add(uRI.toASCIIString());
        }
        ((Import)object).setRoot(xdmNode4);
        this.checkExtensionAttributes(xdmNode, (SourceArtifact)object);
        return object;
    }

    private ForEach readForEach(Step step, XdmNode xdmNode) {
        QName qName = xdmNode.getNodeName();
        if (!XProcConstants.p_for_each.equals((Object)qName)) {
            throw new UnsupportedOperationException("Can't parse " + qName + " as a pipeline!");
        }
        this.checkAttributes(xdmNode, new String[]{"name"}, false);
        String string = this.checkNCName(xdmNode.getAttributeValue(_name));
        ForEach forEach = new ForEach(this.runtime, xdmNode, string);
        this.checkExtensionAttributes(xdmNode, forEach);
        forEach.setParentDecl((DeclareStep)step);
        forEach.parent = step;
        Vector<XdmNode> vector = this.readSignature(forEach);
        if (vector == null) {
            throw XProcException.staticError(15, xdmNode, "A p:for-each must contain a subpipeline.");
        }
        for (XdmNode xdmNode2 : vector) {
            Step step2 = this.readStep(forEach, xdmNode2);
            forEach.addStep(step2);
        }
        forEach.checkPrimaryIO();
        return forEach;
    }

    private UntilUnchanged readUntilUnchanged(Step step, XdmNode xdmNode) {
        QName qName = xdmNode.getNodeName();
        if (!XProcConstants.cx_until_unchanged.equals((Object)qName)) {
            throw new UnsupportedOperationException("Can't parse " + qName + " as a cx:until-unchanged!");
        }
        this.checkAttributes(xdmNode, new String[]{"name"}, false);
        String string = this.checkNCName(xdmNode.getAttributeValue(_name));
        UntilUnchanged untilUnchanged = new UntilUnchanged(this.runtime, xdmNode, string);
        this.checkExtensionAttributes(xdmNode, untilUnchanged);
        untilUnchanged.setParentDecl((DeclareStep)step);
        untilUnchanged.parent = step;
        Vector<XdmNode> vector = this.readSignature(untilUnchanged);
        if (vector == null) {
            throw XProcException.staticError(15, xdmNode, "A cx:until-unchanged must contain a subpipeline.");
        }
        for (XdmNode xdmNode2 : vector) {
            Step step2 = this.readStep(untilUnchanged, xdmNode2);
            untilUnchanged.addStep(step2);
        }
        untilUnchanged.checkPrimaryIO();
        return untilUnchanged;
    }

    private Viewport readViewport(Step step, XdmNode xdmNode) {
        QName qName = xdmNode.getNodeName();
        if (!XProcConstants.p_viewport.equals((Object)qName)) {
            throw new UnsupportedOperationException("Can't parse " + qName + " as a pipeline!");
        }
        this.checkAttributes(xdmNode, new String[]{"name", "match"}, false);
        String string = this.checkNCName(xdmNode.getAttributeValue(_name));
        RuntimeValue runtimeValue = new RuntimeValue(xdmNode.getAttributeValue(new QName("match")), xdmNode);
        Viewport viewport = new Viewport(this.runtime, xdmNode, string);
        this.checkExtensionAttributes(xdmNode, viewport);
        viewport.setParentDecl((DeclareStep)step);
        viewport.parent = step;
        viewport.setMatch(runtimeValue);
        Vector<XdmNode> vector = this.readSignature(viewport);
        if (vector == null) {
            throw XProcException.staticError(15, xdmNode, "A p:viewport must contain a subpipeline.");
        }
        for (XdmNode xdmNode2 : vector) {
            Step step2 = this.readStep(viewport, xdmNode2);
            viewport.addStep(step2);
        }
        viewport.checkPrimaryIO();
        return viewport;
    }

    private Choose readChoose(Step step, XdmNode xdmNode) {
        this.checkAttributes(xdmNode, new String[]{"name"}, false);
        String string = this.checkNCName(xdmNode.getAttributeValue(_name));
        Choose choose = new Choose(this.runtime, xdmNode, string);
        this.checkExtensionAttributes(xdmNode, choose);
        choose.setParentDecl((DeclareStep)step);
        choose.parent = step;
        Vector<XdmNode> vector = this.readSignature(choose);
        if (vector == null) {
            throw XProcException.staticError(15, xdmNode, "A p:choose must contain at least one p:when.");
        }
        for (XdmNode xdmNode2 : vector) {
            DeclareStep declareStep;
            if (XProcConstants.p_when.equals((Object)xdmNode2.getNodeName())) {
                declareStep = this.readWhen(choose, xdmNode2);
                choose.addStep(declareStep);
                continue;
            }
            if (XProcConstants.p_otherwise.equals((Object)xdmNode2.getNodeName())) {
                declareStep = this.readOtherwise(choose, xdmNode2);
                choose.addStep(declareStep);
                continue;
            }
            throw new UnsupportedOperationException("Not valid in a choose: " + xdmNode2.getNodeName());
        }
        choose.checkPrimaryIO();
        return choose;
    }

    private When readWhen(Step step, XdmNode xdmNode) {
        this.checkAttributes(xdmNode, new String[]{"test"}, false);
        String string = this.checkNCName(xdmNode.getAttributeValue(px_name));
        String string2 = xdmNode.getAttributeValue(new QName("test"));
        When when = new When(this.runtime, xdmNode, string);
        this.checkExtensionAttributes(xdmNode, when);
        when.setTest(string2);
        when.setParentDecl((DeclareStep)step);
        when.parent = step;
        Vector<XdmNode> vector = this.readSignature(when);
        if (vector == null) {
            throw XProcException.staticError(15, xdmNode, "A p:when must contain a subpipeline.");
        }
        for (XdmNode xdmNode2 : vector) {
            Step step2 = this.readStep(when, xdmNode2);
            when.addStep(step2);
        }
        when.checkPrimaryIO();
        return when;
    }

    private Otherwise readOtherwise(Step step, XdmNode xdmNode) {
        this.checkAttributes(xdmNode, null, false);
        String string = this.checkNCName(xdmNode.getAttributeValue(px_name));
        Otherwise otherwise = new Otherwise(this.runtime, xdmNode, string);
        this.checkExtensionAttributes(xdmNode, otherwise);
        otherwise.setParentDecl((DeclareStep)step);
        otherwise.parent = step;
        Vector<XdmNode> vector = this.readSignature(otherwise);
        if (vector == null) {
            throw XProcException.staticError(15, xdmNode, "A p:otherwise must contain a subpipeline.");
        }
        for (XdmNode xdmNode2 : vector) {
            Step step2 = this.readStep(otherwise, xdmNode2);
            otherwise.addStep(step2);
        }
        otherwise.checkPrimaryIO();
        return otherwise;
    }

    private Group readGroup(Step step, XdmNode xdmNode) {
        this.checkAttributes(xdmNode, new String[]{"name"}, false);
        String string = this.checkNCName(xdmNode.getAttributeValue(_name));
        Group group = new Group(this.runtime, xdmNode, string);
        this.checkExtensionAttributes(xdmNode, group);
        group.setParentDecl((DeclareStep)step);
        group.parent = step;
        Vector<XdmNode> vector = this.readSignature(group);
        if (vector == null) {
            throw XProcException.staticError(15, xdmNode, "A p:group must contain a subpipeline.");
        }
        for (XdmNode xdmNode2 : vector) {
            Step step2 = this.readStep(group, xdmNode2);
            group.addStep(step2);
        }
        group.checkPrimaryIO();
        return group;
    }

    private Try readTry(Step step, XdmNode xdmNode) {
        this.checkAttributes(xdmNode, new String[]{"name"}, false);
        String string = this.checkNCName(xdmNode.getAttributeValue(_name));
        Try try_ = new Try(this.runtime, xdmNode, string);
        this.checkExtensionAttributes(xdmNode, try_);
        try_.setParentDecl((DeclareStep)step);
        try_.parent = step;
        Vector<XdmNode> vector = this.readSignature(try_);
        if (vector == null) {
            throw XProcException.staticError(15, xdmNode, "A p:try must contain a subpipeline.");
        }
        for (XdmNode xdmNode2 : vector) {
            Step step2 = this.readStep(try_, xdmNode2);
            try_.addStep(step2);
        }
        try_.checkPrimaryIO();
        return try_;
    }

    private Catch readCatch(Step step, XdmNode xdmNode) {
        this.checkAttributes(xdmNode, new String[]{"name"}, false);
        String string = this.checkNCName(xdmNode.getAttributeValue(_name));
        Catch catch_ = new Catch(this.runtime, xdmNode, string);
        this.checkExtensionAttributes(xdmNode, catch_);
        catch_.setParentDecl((DeclareStep)step);
        catch_.parent = step;
        Vector<XdmNode> vector = this.readSignature(catch_);
        Input input = new Input(this.runtime, catch_.getNode());
        input.setPort("error");
        input.addBinding(new ErrorBinding(this.runtime, catch_.getNode()));
        input.setPrimary(false);
        input.setSequence(true);
        catch_.addInput(input);
        if (vector == null) {
            throw XProcException.staticError(15, xdmNode, "A p:catch must contain a subpipeline.");
        }
        for (XdmNode xdmNode2 : vector) {
            Step step2 = this.readStep(catch_, xdmNode2);
            catch_.addStep(step2);
        }
        catch_.checkPrimaryIO();
        return catch_;
    }

    /*
     * WARNING - void declaration
     */
    private HashSet<String> checkAttributes(XdmNode xdmNode, String[] stringArray, boolean bl) {
        void var5_7;
        HashSet<String> hashSet = null;
        if (stringArray != null) {
            hashSet = new HashSet<String>();
            for (String string : stringArray) {
                hashSet.add(string);
            }
        }
        Object var5_6 = null;
        Double d = this.inheritedVersion(xdmNode);
        for (String string : new RelevantNodes(this.runtime, xdmNode, Axis.ATTRIBUTE)) {
            QName qName = string.getNodeName();
            if ("http://www.w3.org/ns/xproc".equals(xdmNode.getNodeName().getNamespaceURI()) && qName.equals((Object)_use_when) || !"http://www.w3.org/ns/xproc".equals(xdmNode.getNodeName().getNamespaceURI()) && qName.equals((Object)p_use_when)) continue;
            if ("".equals(qName.getNamespaceURI())) {
                if (hashSet.contains(qName.getLocalName())) continue;
                if (bl) {
                    if (var5_7 == null) {
                        HashSet hashSet2 = new HashSet();
                    }
                    var5_7.add(qName.getLocalName());
                    continue;
                }
                if (d > 1.0) continue;
                this.runtime.error(null, xdmNode, "Attribute \"" + qName + "\" not allowed on " + xdmNode.getNodeName(), XProcConstants.staticError(8));
                continue;
            }
            if (!"http://www.w3.org/ns/xproc".equals(qName.getNamespaceURI())) continue;
            this.runtime.error(null, xdmNode, "Attribute \"" + qName + "\" not allowed on " + xdmNode.getNodeName(), XProcConstants.staticError(8));
            return null;
        }
        return var5_7;
    }

    private void checkExtensionAttributes(XdmNode xdmNode, SourceArtifact sourceArtifact) {
        for (XdmNode xdmNode2 : new RelevantNodes(this.runtime, xdmNode, Axis.ATTRIBUTE)) {
            QName qName = xdmNode2.getNodeName();
            if ("".equals(qName.getNamespaceURI())) continue;
            if ("http://www.w3.org/ns/xproc".equals(qName.getNamespaceURI())) {
                this.runtime.error(null, xdmNode, "Attribute \"" + qName + "\" not allowed on " + xdmNode.getNodeName(), XProcConstants.staticError(8));
                continue;
            }
            sourceArtifact.addExtensionAttribute(xdmNode2);
        }
    }

    private boolean booleanAttr(String string) {
        return this.booleanAttr(string, false);
    }

    private boolean booleanAttr(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        if ("true".equals(string)) {
            return true;
        }
        if ("false".equals(string)) {
            return false;
        }
        throw new IllegalArgumentException("Boolean value must be 'true' or 'false'.");
    }

    private String checkNCName(String string) {
        if (string != null) {
            try {
                TypeUtils.checkType(this.runtime, string, XProcConstants.xs_NCName, null);
            }
            catch (XProcException xProcException) {
                throw new XProcException("Invalid name: \"" + string + "\". Step and port names must be NCNames.", xProcException.getCause());
            }
        }
        return string;
    }
}

