/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.BuilderMonitor;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.CommentImpl;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.LinkedBuilderMonitor;
import net.sf.saxon.tree.linked.NodeFactory;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.ParentNodeImpl;
import net.sf.saxon.tree.linked.ProcInstImpl;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;

public class LinkedTreeBuilder
extends Builder {
    private ParentNodeImpl currentNode;
    private boolean contentStarted = false;
    private NodeFactory nodeFactory;
    private int[] size = new int[100];
    private int depth = 0;
    private ArrayList<NodeImpl[]> arrays = new ArrayList(20);
    private NodeName elementNodeName;
    private SchemaType elementType;
    private boolean isNilled;
    private Location pendingLocation;
    private AttributeCollectionImpl attributes;
    private NamespaceBinding[] namespaces;
    private int namespacesUsed;
    private boolean allocateSequenceNumbers = true;
    private int nextNodeNumber = 1;
    private static final NamespaceBinding[] EMPTY_NAMESPACE_LIST = new NamespaceBinding[0];

    public LinkedTreeBuilder(PipelineConfiguration pipe) {
        super(pipe);
        this.nodeFactory = DefaultNodeFactory.THE_INSTANCE;
    }

    public NodeInfo getCurrentRoot() {
        NodeInfo physicalRoot = this.currentRoot;
        if (physicalRoot instanceof DocumentImpl && ((DocumentImpl)physicalRoot).isImaginary()) {
            return ((DocumentImpl)physicalRoot).getDocumentElement();
        }
        return physicalRoot;
    }

    public void reset() {
        super.reset();
        this.currentNode = null;
        this.nodeFactory = DefaultNodeFactory.THE_INSTANCE;
        this.depth = 0;
        this.allocateSequenceNumbers = true;
        this.nextNodeNumber = 1;
    }

    public void setAllocateSequenceNumbers(boolean allocate) {
        this.allocateSequenceNumbers = allocate;
    }

    public void setNodeFactory(NodeFactory factory) {
        this.nodeFactory = factory;
    }

    public void open() {
        this.started = true;
        this.depth = 0;
        this.size[this.depth] = 0;
        if (this.arrays == null) {
            this.arrays = new ArrayList(20);
        }
        super.open();
    }

    public void startDocument(int properties) throws XPathException {
        DocumentImpl doc = new DocumentImpl();
        this.currentRoot = doc;
        doc.setSystemId(this.getSystemId());
        doc.setBaseURI(this.getBaseURI());
        doc.setConfiguration(this.config);
        this.currentNode = doc;
        this.depth = 0;
        this.size[this.depth] = 0;
        if (this.arrays == null) {
            this.arrays = new ArrayList(20);
        }
        doc.setRawSequenceNumber(0);
        if (this.lineNumbering) {
            doc.setLineNumbering();
        }
        this.contentStarted = true;
    }

    public void endDocument() throws XPathException {
        this.currentNode.compact(this.size[this.depth]);
    }

    public void close() throws XPathException {
        if (this.currentNode == null) {
            return;
        }
        this.currentNode.compact(this.size[this.depth]);
        this.currentNode = null;
        this.arrays = null;
        super.close();
        this.nodeFactory = DefaultNodeFactory.THE_INSTANCE;
    }

    public void startElement(NodeName nodeName, SchemaType type, Location location, int properties) throws XPathException {
        if (this.currentNode == null) {
            this.startDocument(0);
            ((DocumentImpl)this.currentRoot).setImaginary(true);
        }
        this.elementNodeName = nodeName;
        this.elementType = type;
        this.isNilled = (properties & 0x10) != 0;
        this.pendingLocation = location;
        this.namespacesUsed = 0;
        this.attributes = null;
        this.contentStarted = false;
    }

    public void namespace(NamespaceBindingSet namespaceBindings, int properties) {
        if (this.contentStarted) {
            throw new IllegalStateException("namespace() called after startContent()");
        }
        if (this.namespaces == null) {
            this.namespaces = new NamespaceBinding[5];
        }
        for (NamespaceBinding ns : namespaceBindings) {
            if (this.namespacesUsed == this.namespaces.length) {
                this.namespaces = Arrays.copyOf(this.namespaces, this.namespaces.length * 2);
            }
            this.namespaces[this.namespacesUsed++] = ns;
        }
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        properties &= 0xFFFFFFFE;
        if (this.contentStarted) {
            throw new IllegalStateException("attribute() called after startContent()");
        }
        if (this.attributes == null) {
            this.attributes = new AttributeCollectionImpl(this.config);
        }
        if (attName.hasURI("http://www.w3.org/XML/1998/namespace") && attName.getLocalPart().equals("id")) {
            value = Whitespace.trim(value);
        }
        this.attributes.addAttribute(attName, typeCode, value.toString(), locationId, properties);
    }

    public void startContent() throws XPathException {
        int n;
        if (this.contentStarted) {
            throw new IllegalStateException("startContent() called more than once");
        }
        this.contentStarted = true;
        if (this.attributes == null) {
            this.attributes = AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION;
        } else {
            this.attributes.compact();
        }
        NamespaceBinding[] nslist = this.namespaces;
        if (nslist == null || this.namespacesUsed == 0) {
            nslist = EMPTY_NAMESPACE_LIST;
        }
        if (this.allocateSequenceNumbers) {
            int n2 = this.nextNodeNumber;
            n = n2;
            this.nextNodeNumber = n2 + 1;
        } else {
            n = -1;
        }
        ElementImpl elem = this.nodeFactory.makeElementNode(this.currentNode, this.elementNodeName, this.elementType, this.isNilled, this.attributes, nslist, this.namespacesUsed, this.pipe, this.pendingLocation, n);
        this.namespacesUsed = 0;
        this.attributes = null;
        while (this.depth >= this.arrays.size()) {
            this.arrays.add(new NodeImpl[20]);
        }
        elem.setChildren(this.arrays.get(this.depth));
        int n3 = this.depth;
        int n4 = this.size[n3];
        this.size[n3] = n4 + 1;
        this.currentNode.addChild(elem, n4);
        if (this.depth >= this.size.length - 1) {
            this.size = Arrays.copyOf(this.size, this.size.length * 2);
        }
        this.size[++this.depth] = 0;
        this.namespacesUsed = 0;
        if (this.currentNode instanceof TreeInfo) {
            ((DocumentImpl)this.currentNode).setDocumentElement(elem);
        }
        this.currentNode = elem;
    }

    public void endElement() throws XPathException {
        if (!this.contentStarted) {
            throw new IllegalStateException("missing call on startContent()");
        }
        this.currentNode.compact(this.size[this.depth]);
        --this.depth;
        this.currentNode = (ParentNodeImpl)this.currentNode.getParent();
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (!this.contentStarted) {
            throw new IllegalStateException("missing call on startContent()");
        }
        if (chars.length() > 0) {
            NodeImpl prev = this.currentNode.getNthChild(this.size[this.depth] - 1);
            if (prev instanceof TextImpl) {
                ((TextImpl)prev).appendStringValue(chars.toString());
            } else {
                TextImpl n = this.nodeFactory.makeTextNode(this.currentNode, chars);
                int n2 = this.depth;
                int n3 = this.size[n2];
                this.size[n2] = n3 + 1;
                this.currentNode.addChild(n, n3);
            }
        }
    }

    public void processingInstruction(String name, CharSequence remainder, Location locationId, int properties) {
        if (!this.contentStarted) {
            throw new IllegalStateException("missing call on startContent()");
        }
        ProcInstImpl pi = new ProcInstImpl(name, remainder.toString());
        int n = this.depth;
        int n2 = this.size[n];
        this.size[n] = n2 + 1;
        this.currentNode.addChild(pi, n2);
        pi.setLocation(locationId.getSystemId(), locationId.getLineNumber());
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (!this.contentStarted) {
            throw new IllegalStateException("missing call on startContent()");
        }
        CommentImpl comment = new CommentImpl(chars.toString());
        int n = this.depth;
        int n2 = this.size[n];
        this.size[n] = n2 + 1;
        this.currentNode.addChild(comment, n2);
    }

    public ParentNodeImpl getCurrentParentNode() {
        return this.currentNode;
    }

    public NodeImpl getCurrentLeafNode() {
        return this.currentNode.getLastChild();
    }

    public void graftElement(ElementImpl element) {
        int n = this.depth;
        int n2 = this.size[n];
        this.size[n] = n2 + 1;
        this.currentNode.addChild(element, n2);
    }

    public void setUnparsedEntity(String name, String uri, String publicId) {
        if (((DocumentImpl)this.currentRoot).getUnparsedEntity(name) == null) {
            ((DocumentImpl)this.currentRoot).setUnparsedEntity(name, uri, publicId);
        }
    }

    public BuilderMonitor getBuilderMonitor() {
        return new LinkedBuilderMonitor(this);
    }

    private static class DefaultNodeFactory
    implements NodeFactory {
        public static DefaultNodeFactory THE_INSTANCE = new DefaultNodeFactory();

        private DefaultNodeFactory() {
        }

        public ElementImpl makeElementNode(NodeInfo parent, NodeName nodeName, SchemaType elementType, boolean isNilled, AttributeCollectionImpl attlist, NamespaceBinding[] namespaces, int namespacesUsed, PipelineConfiguration pipe, Location locationId, int sequenceNumber) {
            ElementImpl e = new ElementImpl();
            if (namespacesUsed > 0) {
                e.setNamespaceDeclarations(namespaces, namespacesUsed);
            }
            e.initialise(nodeName, elementType, attlist, parent, sequenceNumber);
            if (isNilled) {
                e.setNilled();
            }
            if (locationId != ExplicitLocation.UNKNOWN_LOCATION && sequenceNumber >= 0) {
                String baseURI = locationId.getSystemId();
                int lineNumber = locationId.getLineNumber();
                int columnNumber = locationId.getColumnNumber();
                e.setLocation(baseURI, lineNumber, columnNumber);
            }
            return e;
        }

        public TextImpl makeTextNode(NodeInfo parent, CharSequence content) {
            return new TextImpl(content.toString());
        }
    }
}

