/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.config.CssProcessor;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Vector;
import jp.co.antenna.XfoJavaCtl.MessageListener;
import jp.co.antenna.XfoJavaCtl.XfoException;
import jp.co.antenna.XfoJavaCtl.XfoFormatPageListener;
import jp.co.antenna.XfoJavaCtl.XfoObj;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class CssAH
implements CssProcessor {
    private static final QName _content_type = new QName("content-type");
    private static final QName _encoding = new QName("", "encoding");
    XProcRuntime runtime = null;
    Properties options = null;
    String primarySS = null;
    Vector<String> userSS = new Vector();
    XStep step = null;
    XfoObj ah = null;

    @Override
    public void initialize(XProcRuntime xProcRuntime, XStep xStep, Properties properties) {
        this.runtime = xProcRuntime;
        this.step = xStep;
        this.options = properties;
        try {
            Boolean bl;
            this.ah = new XfoObj();
            this.ah.setFormatterType(3);
            FoMessages foMessages = new FoMessages();
            this.ah.setMessageListener((MessageListener)foMessages);
            String string = this.getStringProp("OptionsFileURI");
            if (string != null) {
                this.ah.setOptionFileURI(string);
            }
            this.ah.setExitLevel(4);
            Integer n = this.getIntProp("ExitLevel");
            if (n != null) {
                this.ah.setExitLevel(n.intValue());
            }
            if ((string = this.getStringProp("EmbedAllFontsEx")) != null) {
                if ("part".equals(string.toLowerCase())) {
                    this.ah.setPdfEmbedAllFontsEx(0);
                } else if ("base14".equals(string.toLowerCase())) {
                    this.ah.setPdfEmbedAllFontsEx(2);
                } else if ("all".equals(string.toLowerCase())) {
                    this.ah.setPdfEmbedAllFontsEx(1);
                } else {
                    throw new XProcException("Unrecognized value for EmbedAllFontsEx");
                }
            }
            if ((n = this.getIntProp("ImageCompression")) != null) {
                this.ah.setPdfImageCompression(n.intValue());
            }
            if ((bl = this.getBooleanProp("NoAccessibility")) != null) {
                this.ah.setPdfNoAccessibility(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("NoAddingOrChangingComments")) != null) {
                this.ah.setPdfNoAddingOrChangingComments(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("NoAssembleDoc")) != null) {
                this.ah.setPdfNoAssembleDoc(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("NoChanging")) != null) {
                this.ah.setPdfNoChanging(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("NoContentCopying")) != null) {
                this.ah.setPdfNoContentCopying(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("NoFillForm")) != null) {
                this.ah.setPdfNoFillForm(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("NoPrinting")) != null) {
                this.ah.setPdfNoPrinting(bl.booleanValue());
            }
            if ((string = this.getStringProp("OwnersPassword")) != null) {
                this.ah.setPdfOwnerPassword(string);
            }
            if ((bl = this.getBooleanProp("TwoPassFormatting")) != null) {
                this.ah.setTwoPassFormatting(bl.booleanValue());
            }
        }
        catch (XfoException xfoException) {
            throw new XProcException(xfoException);
        }
    }

    @Override
    public void addStylesheet(XdmNode xdmNode) {
        File file;
        Object object;
        xdmNode = S9apiUtils.getDocumentElement(xdmNode);
        String string = null;
        if (XProcConstants.c_data.equals((Object)xdmNode.getNodeName()) && "application/octet-stream".equals(xdmNode.getAttributeValue(_content_type)) || "base64".equals(xdmNode.getAttributeValue(_encoding))) {
            object = Base64.decode(xdmNode.getStringValue());
            string = new String((byte[])object);
        } else {
            string = xdmNode.getStringValue();
        }
        object = "temp";
        String string2 = ".css";
        try {
            file = File.createTempFile((String)object, string2);
        }
        catch (IOException iOException) {
            throw new XProcException(this.step.getNode(), "Failed to create temporary file for CSS");
        }
        file.deleteOnExit();
        try {
            PrintStream printStream = new PrintStream(file);
            printStream.print(string);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new XProcException(this.step.getNode(), "Failed to write to temporary CSS file");
        }
        if (this.primarySS == null) {
            this.primarySS = file.toURI().toASCIIString();
        } else {
            this.userSS.add(file.toURI().toASCIIString());
        }
    }

    @Override
    public void format(XdmNode xdmNode, OutputStream outputStream, String string) {
        String string2 = null;
        if (string == null || "application/pdf".equals(string)) {
            string2 = "@PDF";
        } else if ("application/PostScript".equals(string)) {
            string2 = "@PS";
        } else if ("image/svg+xml".equals(string)) {
            string2 = "@SVG";
        } else if ("application/vnd.inx".equals(string)) {
            string2 = "@INX";
        } else if ("application/vnd.mif".equals(string)) {
            string2 = "@MIF";
        } else if ("text/plain".equals(string)) {
            string2 = "@TXT";
        } else {
            throw new XProcException(this.step.getNode(), "Unsupported content-type on p:xsl-formatter: " + string);
        }
        try {
            if (this.primarySS == null) {
                throw new XProcException("No CSS stylesheets provided");
            }
            this.ah.setStylesheetURI(this.primarySS);
            for (String string3 : this.userSS) {
                this.ah.addUserStylesheetURI(string3);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdmNode.toString().getBytes("UTF-8"));
            this.ah.render((InputStream)byteArrayInputStream, outputStream, string2);
            this.ah.releaseObjectEx();
        }
        catch (XfoException xfoException) {
            if (this.runtime.getDebug()) {
                System.out.println("ErrorLevel = " + xfoException.getErrorLevel() + "\nErrorCode = " + xfoException.getErrorCode() + "\n" + xfoException.getErrorMessage());
                xfoException.printStackTrace();
            }
            throw new XProcException(xfoException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XProcException(unsupportedEncodingException);
        }
    }

    private String getStringProp(String string) {
        return this.options.getProperty(string);
    }

    private Integer getIntProp(String string) {
        String string2 = this.getStringProp(string);
        if (string2 != null) {
            try {
                int n = Integer.parseInt(string2);
                return new Integer(n);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    private Boolean getBooleanProp(String string) {
        String string2 = this.options.getProperty(string);
        if (string2 != null) {
            return "true".equals(string2);
        }
        return null;
    }

    private class FoMessages
    implements MessageListener,
    XfoFormatPageListener {
        private FoMessages() {
        }

        public void onMessage(int n, int n2, String string) {
            switch (n) {
                case 1: {
                    CssAH.this.step.info(CssAH.this.step.getNode(), string);
                    return;
                }
                case 2: {
                    CssAH.this.step.warning(CssAH.this.step.getNode(), string);
                    return;
                }
            }
            CssAH.this.step.error(CssAH.this.step.getNode(), string, XProcConstants.stepError(n2));
        }

        public void onFormatPage(int n) {
            CssAH.this.step.finest(CssAH.this.step.getNode(), "Formatted PDF page " + n);
        }
    }
}

