/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.tree.wrapper.VirtualDocumentCopy;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class VirtualUntypedCopy
extends VirtualCopy {
    public static VirtualCopy makeVirtualUntypedCopy(NodeInfo original, NodeInfo root) {
        while (original instanceof VirtualUntypedCopy) {
            original = ((VirtualUntypedCopy)original).original;
        }
        while (root instanceof VirtualUntypedCopy) {
            root = ((VirtualUntypedCopy)root).original;
        }
        VirtualCopy vc = original.getNodeKind() == 9 ? new VirtualDocumentCopy((DocumentInfo)original) : new VirtualUntypedCopy(original);
        vc.root = root;
        return vc;
    }

    protected VirtualUntypedCopy(NodeInfo base) {
        super(base);
    }

    public int getTypeAnnotation() {
        switch (this.getNodeKind()) {
            case 1: {
                return 630;
            }
            case 2: {
                return 631;
            }
        }
        return super.getTypeAnnotation();
    }

    public SchemaType getSchemaType() {
        switch (this.getNodeKind()) {
            case 1: {
                return Untyped.getInstance();
            }
            case 2: {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
        }
        return super.getSchemaType();
    }

    public Value atomize() throws XPathException {
        switch (this.getNodeKind()) {
            case 1: 
            case 2: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        return super.atomize();
    }

    public SequenceIterator getTypedValue() throws XPathException {
        switch (this.getNodeKind()) {
            case 1: 
            case 2: {
                return SingletonIterator.makeIterator(new UntypedAtomicValue(this.getStringValueCS()));
            }
        }
        return super.getTypedValue();
    }

    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        super.copy(out, copyOptions & 0xFFFFFFFB, locationId);
    }

    protected VirtualCopy.VirtualCopier makeCopier(AxisIterator axis, VirtualCopy newParent, NodeInfo root) {
        return new VirtualUntypedCopier(axis, newParent, root);
    }

    protected class VirtualUntypedCopier
    extends VirtualCopy.VirtualCopier {
        public VirtualUntypedCopier(AxisIterator base, VirtualCopy parent, NodeInfo subtreeRoot) {
            super(base, parent, subtreeRoot);
        }

        protected VirtualCopy createCopy(NodeInfo node, NodeInfo root) {
            return VirtualUntypedCopy.makeVirtualUntypedCopy(node, root);
        }

        public AxisIterator getAnother() {
            return new VirtualUntypedCopier(this.base.getAnother(), VirtualUntypedCopy.this.parent, this.subtreeRoot);
        }
    }
}

