/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.CollectionResolver;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Result;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;

public class XSLT
extends DefaultStep {
    private static final QName _initial_mode = new QName("", "initial-mode");
    private static final QName _template_name = new QName("", "template-name");
    private static final QName _output_base_uri = new QName("", "output-base-uri");
    private static final QName _version = new QName("", "version");
    private ReadablePipe sourcePipe = null;
    private ReadablePipe stylesheetPipe = null;
    private WritablePipe resultPipe = null;
    private WritablePipe secondaryPipe = null;
    private Hashtable<QName, RuntimeValue> params = new Hashtable();
    private Hashtable<String, XdmDestination> secondaryResults = new Hashtable();

    public XSLT(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.sourcePipe = readablePipe;
        } else {
            this.stylesheetPipe = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        if ("result".equals(string)) {
            this.resultPipe = writablePipe;
        } else {
            this.secondaryPipe = writablePipe;
        }
    }

    @Override
    public void setParameter(QName qName, RuntimeValue runtimeValue) {
        this.params.put(qName, runtimeValue);
    }

    @Override
    public void reset() {
        this.sourcePipe.resetReader();
        this.stylesheetPipe.resetReader();
        this.resultPipe.resetWriter();
        this.secondaryPipe.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        Object object;
        QName qName3;
        XdmNode xdmNode;
        super.run();
        XdmNode xdmNode2 = this.stylesheetPipe.read();
        if (xdmNode2 == null) {
            throw XProcException.dynamicError(6, this.step.getNode(), "No stylesheet provided.");
        }
        Vector<XdmNode> vector = new Vector<XdmNode>();
        while (this.sourcePipe.moreDocuments()) {
            vector.add(this.sourcePipe.read());
        }
        XdmNode xdmNode3 = null;
        if (vector.size() > 0) {
            xdmNode3 = (XdmNode)vector.firstElement();
        }
        String string = null;
        if (this.getOption(_version) == null) {
            xdmNode = S9apiUtils.getDocumentElement(xdmNode2);
            string = xdmNode.getAttributeValue(new QName("", "version"));
            if (string == null) {
                string = xdmNode.getAttributeValue(new QName("http://www.w3.org/1999/XSL/Transform", "version"));
            }
            if (string == null) {
                string = "2.0";
            }
        } else {
            string = this.getOption(_version).getString();
        }
        if (!"1.0".equals(string) && !"2.0".equals(string)) {
            throw XProcException.stepError(38, "XSLT version '" + string + "' is not supported.");
        }
        if ("1.0".equals(string) && vector.size() > 1) {
            throw XProcException.stepError(39);
        }
        xdmNode = null;
        QName qName2 = null;
        String string2 = null;
        RuntimeValue runtimeValue = this.getOption(_initial_mode);
        if (runtimeValue != null) {
            xdmNode = runtimeValue.getQName();
        }
        if ((runtimeValue = this.getOption(_template_name)) != null) {
            qName2 = runtimeValue.getQName();
        }
        if ((runtimeValue = this.getOption(_output_base_uri)) != null) {
            string2 = runtimeValue.getString();
        }
        Processor processor = this.runtime.getProcessor();
        Configuration configuration = processor.getUnderlyingConfiguration();
        this.runtime.getConfigurer().getSaxonConfigurer().configXSLT(configuration);
        OutputURIResolver outputURIResolver = configuration.getOutputURIResolver();
        CollectionURIResolver collectionURIResolver = configuration.getCollectionURIResolver();
        configuration.setOutputURIResolver((OutputURIResolver)new OutputResolver());
        configuration.setCollectionURIResolver((CollectionURIResolver)new CollectionResolver(this.runtime, vector, collectionURIResolver));
        XsltCompiler xsltCompiler = this.runtime.getProcessor().newXsltCompiler();
        xsltCompiler.setSchemaAware(processor.isSchemaAware());
        XsltExecutable xsltExecutable = xsltCompiler.compile(xdmNode2.asSource());
        XsltTransformer xsltTransformer = xsltExecutable.load();
        for (QName qName3 : this.params.keySet()) {
            object = this.params.get(qName3);
            if (this.runtime.getAllowGeneralExpressions()) {
                xsltTransformer.setParameter(qName3, ((RuntimeValue)object).getValue());
                continue;
            }
            xsltTransformer.setParameter(qName3, (XdmValue)new XdmAtomicValue(((RuntimeValue)object).getString()));
        }
        if (xdmNode3 != null) {
            xsltTransformer.setInitialContextNode(xdmNode3);
        }
        xsltTransformer.setMessageListener((MessageListener)new CatchMessages());
        XdmDestination xdmDestination = new XdmDestination();
        xsltTransformer.setDestination((Destination)xdmDestination);
        if (xdmNode != null) {
            xsltTransformer.setInitialMode((QName)xdmNode);
        }
        if (qName2 != null) {
            xsltTransformer.setInitialTemplate(qName2);
        }
        if (string2 != null) {
            xsltTransformer.setBaseOutputURI(string2);
        }
        xsltTransformer.setSchemaValidationMode(ValidationMode.DEFAULT);
        xsltTransformer.transform();
        configuration.setOutputURIResolver(outputURIResolver);
        configuration.setCollectionURIResolver(collectionURIResolver);
        qName3 = xdmDestination.getXdmNode();
        if (qName3 != null) {
            if (xdmNode3 != null && (qName3.getBaseURI() == null || "".equals(qName3.getBaseURI().toASCIIString()))) {
                object = xdmNode3.getBaseURI().toASCIIString();
                qName3.getUnderlyingNode().setSystemId((String)object);
            }
            this.resultPipe.write((XdmNode)qName3);
        }
    }

    class CatchMessages
    implements MessageListener {
        public void message(XdmNode xdmNode, boolean bl, SourceLocator sourceLocator) {
            TreeWriter treeWriter = new TreeWriter(XSLT.this.runtime);
            treeWriter.startDocument(xdmNode.getBaseURI());
            treeWriter.addStartElement(XProcConstants.c_error);
            treeWriter.startContent();
            treeWriter.addSubtree(xdmNode);
            treeWriter.addEndElement();
            treeWriter.endDocument();
            XSLT.this.step.reportError(treeWriter.getResult());
            XSLT.this.step.info(XSLT.this.step.getNode(), xdmNode.toString());
        }
    }

    class OutputResolver
    implements OutputURIResolver {
        public Result resolve(String string, String string2) throws TransformerException {
            URI uRI = null;
            try {
                uRI = new URI(string2);
                uRI = uRI.resolve(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XProcException(uRISyntaxException);
            }
            XSLT.this.finest(XSLT.this.step.getNode(), "XSLT secondary result document: " + uRI);
            try {
                XdmDestination xdmDestination = new XdmDestination();
                XSLT.this.secondaryResults.put(uRI.toASCIIString(), xdmDestination);
                Receiver receiver = xdmDestination.getReceiver(XSLT.this.runtime.getProcessor().getUnderlyingConfiguration());
                receiver.setSystemId(uRI.toASCIIString());
                return receiver;
            }
            catch (SaxonApiException saxonApiException) {
                throw new XProcException(saxonApiException);
            }
        }

        public void close(Result result) throws TransformerException {
            String string = result.getSystemId();
            XdmDestination xdmDestination = (XdmDestination)XSLT.this.secondaryResults.get(string);
            XdmNode xdmNode = xdmDestination.getXdmNode();
            XSLT.this.secondaryPipe.write(xdmNode);
        }
    }
}

