/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.DocumentSequenceIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public class SplitSequence
extends DefaultStep {
    private static final QName _test = new QName("", "test");
    private static final QName _initial_only = new QName("", "initial-only");
    private ReadablePipe source = null;
    private WritablePipe matched = null;
    private WritablePipe notMatched = null;
    private boolean initialOnly = false;

    public SplitSequence(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        if ("matched".equals(string)) {
            this.matched = writablePipe;
        } else {
            this.notMatched = writablePipe;
        }
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.matched.resetWriter();
        this.notMatched.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue runtimeValue = this.getOption(_test);
        this.initialOnly = this.getOption(_initial_only, false);
        boolean bl = true;
        int n = 0;
        while (this.source.moreDocuments()) {
            ++n;
            this.source.read();
        }
        this.source.resetReader();
        DocumentSequenceIterator documentSequenceIterator = new DocumentSequenceIterator();
        documentSequenceIterator.setLast(n);
        int n2 = 0;
        while (this.source.moreDocuments()) {
            XdmNode xdmNode = this.source.read();
            ++n2;
            Item item = null;
            try {
                String string2;
                XPathCompiler xPathCompiler = this.runtime.getProcessor().newXPathCompiler();
                xPathCompiler.setBaseURI(this.step.getNode().getBaseURI());
                for (String string2 : runtimeValue.getNamespaceBindings().keySet()) {
                    xPathCompiler.declareNamespace(string2, runtimeValue.getNamespaceBindings().get(string2));
                }
                XPathExecutable xPathExecutable = xPathCompiler.compile(runtimeValue.getString());
                string2 = xPathExecutable.getUnderlyingExpression();
                XPathDynamicContext xPathDynamicContext = string2.createDynamicContext((Item)xdmNode.getUnderlyingNode());
                XPathContext xPathContext = xPathDynamicContext.getXPathContextObject();
                documentSequenceIterator.setPosition(n2);
                documentSequenceIterator.setItem((Item)xdmNode.getUnderlyingNode());
                xPathContext.setCurrentIterator((SequenceIterator)documentSequenceIterator);
                SequenceIterator sequenceIterator = string2.iterate(xPathDynamicContext);
                item = sequenceIterator.next();
            }
            catch (XPathException xPathException) {
                throw new XProcException(xPathException);
            }
            boolean bl2 = false;
            bl2 = item instanceof BooleanValue ? ((BooleanValue)item).getBooleanValue() : item != null;
            boolean bl3 = bl = bl && bl2;
            if (bl2 && (!this.initialOnly || bl)) {
                this.matched.write(xdmNode);
                continue;
            }
            this.notMatched.write(xdmNode);
        }
    }
}

