/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.List;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.ActiveSource;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;

public abstract class Sender {
    private Sender() {
    }

    public static void send(Source source, Receiver receiver, ParseOptions options) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        options = options == null ? new ParseOptions(pipe.getParseOptions()) : new ParseOptions(options);
        String systemId = source.getSystemId();
        AugmentedSource originalAugmentedSource = null;
        if (source instanceof AugmentedSource) {
            originalAugmentedSource = (AugmentedSource)source;
            options.merge(((AugmentedSource)source).getParseOptions());
            systemId = source.getSystemId();
            source = ((AugmentedSource)source).getContainedSource();
        }
        Configuration config = pipe.getConfiguration();
        options.applyDefaults(config);
        receiver.setSystemId(systemId);
        Receiver next = receiver;
        List<FilterFactory> filters = options.getFilters();
        if (filters != null) {
            for (int i = filters.size() - 1; i >= 0; --i) {
                FilterFactory ff = filters.get(i);
                Receiver filter = ff.makeFilter(next);
                filter.setSystemId(source.getSystemId());
                next = filter;
            }
        }
        next = Sender.makeValidator(next, source.getSystemId(), options);
        SpaceStrippingRule strippingRule = options.getSpaceStrippingRule();
        if (strippingRule != null && !(strippingRule instanceof NoElementsSpaceStrippingRule)) {
            next = strippingRule.makeStripper(next);
        }
        if (!(source instanceof ActiveSource)) {
            source = config.resolveSource(source, config);
        }
        if (source == null) {
            throw new XPathException("A source of type " + source.getClass().getName() + " is not supported in this environment");
        }
        ((ActiveSource)source).deliver(next, options);
        if (originalAugmentedSource != null && originalAugmentedSource.isPleaseCloseAfterUse()) {
            originalAugmentedSource.close();
        }
    }

    public static void sendDocumentInfo(NodeInfo top, Receiver receiver, Location location) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        NamePool targetNamePool = pipe.getConfiguration().getNamePool();
        if (top.getConfiguration().getNamePool() != targetNamePool) {
            receiver = new NamePoolConverter(receiver, top.getConfiguration().getNamePool(), targetNamePool);
        }
        LocationCopier copier = new LocationCopier(top.getNodeKind() == 9, location.getSystemId());
        pipe.setComponent(CopyInformee.class.getName(), copier);
        pipe.setCopyInformee(element -> copier.notifyElementNode((NodeInfo)element));
        receiver.open();
        switch (top.getNodeKind()) {
            case 9: {
                top.copy(receiver, 6, location);
                break;
            }
            case 1: {
                receiver.startDocument(0);
                top.copy(receiver, 6, location);
                receiver.endDocument();
                break;
            }
            default: {
                throw new IllegalArgumentException("Expected document or element node");
            }
        }
        receiver.close();
    }

    public static Receiver makeValidator(Receiver receiver, String systemId, ParseOptions options) throws XPathException {
        Controller controller;
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        Configuration config = pipe.getConfiguration();
        int sv = options.getSchemaValidationMode();
        if (sv != 3 && sv != 0 && (controller = pipe.getController()) != null && !controller.getExecutable().isSchemaAware() && sv != 4) {
            throw new XPathException("Cannot use schema-validated input documents when the query/stylesheet is not schema-aware");
        }
        return receiver;
    }
}

