--
--  spotcolors.lua
--  speedata publisher
--
--  for a list of authors see `git blame'
--  see file copying in the root directory for license info.

local colorprofiles = {
   ["FOGRA39"] =  { identifier = "FOGRA39", objectid = 0, registry = "http://www.color.org", info = "Coated FOGRA39 (ISO 12647-2:2004)", condition = "Offset printing, according to ISO 12647-2:2004/Amd 1, OFCOM, paper type 1 or 2 = coated art, 115 g/m2, tone value increase curves A (CMY) and B (K)", filename = "ISOcoated_v2_eci.icc", colors = 4 }
}

local currentcolorprofile = colorprofiles["FOGRA39"]



local colorprofile_objectid = 0
local colorprofile_filename = nil

-- index: color number
-- value: { colorname, pdfobject for the color definition }
-- The object number is 0 until the color is actually used (by color.pdfstring)
local colorobjects = {}

local set_colorprofile_filename, write_colorprofile, use_color, getresource, register

local spotcolors =  {
    ["pantone 100"] = {0, 0, 51, 0},
    ["pantone 101"] = {0, 0, 79, 0},
    ["pantone 102"] = {0, 1, 95, 0},
    ["pantone 103"] = {0, 3, 100, 18},
    ["pantone 104"] = {0, 3, 100, 30},
    ["pantone 105"] = {0, 3, 100, 50},
    ["pantone 106"] = {0, 2, 69, 0},
    ["pantone 107"] = {0, 4, 79, 0},
    ["pantone 108"] = {0, 6, 95, 0},
    ["pantone 109"] = {0, 10, 100, 0},
    ["pantone 110"] = {0, 12, 100, 7},
    ["pantone 111"] = {0, 11, 100, 27},
    ["pantone 112"] = {0, 10, 100, 38},
    ["pantone 113"] = {0, 7, 66, 0},
    ["pantone 114"] = {0, 8, 73, 0},
    ["pantone 115"] = {0, 9, 80, 0},
    ["pantone 116"] = {0, 16, 100, 0},
    ["pantone 117"] = {0, 18, 100, 15},
    ["pantone 118"] = {0, 18, 100, 27},
    ["pantone 119"] = {0, 12, 100, 49},
    ["pantone 120"] = {0, 9, 58, 0},
    ["pantone 1205"] = {0, 5, 31, 0},
    ["pantone 121"] = {0, 11, 69, 0},
    ["pantone 1215"] = {0, 9, 45, 0},
    ["pantone 122"] = {0, 17, 80, 0},
    ["pantone 1225"] = {0, 17, 62, 0},
    ["pantone 123"] = {0, 24, 94, 0},
    ["pantone 1235"] = {0, 29, 91, 0},
    ["pantone 124"] = {0, 28, 100, 18},
    ["pantone 1245"] = {0, 28, 100, 6},
    ["pantone 125"] = {0, 26, 100, 26},
    ["pantone 1255"] = {0, 27, 100, 34},
    ["pantone 126"] = {0, 25, 100, 37},
    ["pantone 1265"] = {0, 27, 100, 51},
    ["pantone 127"] = {0, 7, 50, 0},
    ["pantone 128"] = {0, 11, 65, 0},
    ["pantone 129"] = {0, 16, 77, 0},
    ["pantone 130"] = {0, 30, 100, 0},
    ["pantone 131"] = {0, 32, 100, 9},
    ["pantone 132"] = {0, 28, 100, 30},
    ["pantone 133"] = {0, 20, 100, 56},
    ["pantone 134"] = {0, 11, 45, 0},
    ["pantone 1345"] = {0, 14, 47, 0},
    ["pantone 135"] = {0, 19, 60, 0},
    ["pantone 1355"] = {0, 20, 56, 0},
    ["pantone 136"] = {0, 27, 76, 0},
    ["pantone 1365"] = {0, 29, 72, 0},
    ["pantone 137"] = {0, 35, 90, 0},
    ["pantone 1375"] = {0, 40, 90, 0},
    ["pantone 138"] = {0, 42, 100, 1},
    ["pantone 1385"] = {0, 44, 100, 7},
    ["pantone 139"] = {0, 37, 100, 23},
    ["pantone 1395"] = {0, 41, 100, 37},
    ["pantone 140"] = {0, 27, 100, 54},
    ["pantone 1405"] = {0, 36, 100, 63},
    ["pantone 141"] = {0, 19, 51, 0},
    ["pantone 142"] = {0, 28, 76, 0},
    ["pantone 143"] = {0, 35, 85, 0},
    ["pantone 144"] = {0, 48, 100, 0},
    ["pantone 145"] = {0, 47, 100, 8},
    ["pantone 146"] = {0, 43, 100, 33},
    ["pantone 147"] = {0, 28, 100, 56},
    ["pantone 148"] = {0, 16, 37, 0},
    ["pantone 1485"] = {0, 27, 54, 0},
    ["pantone 149"] = {0, 23, 47, 0},
    ["pantone 1495"] = {0, 33, 67, 0},
    ["pantone 150"] = {0, 35, 70, 0},
    ["pantone 1505"] = {0, 42, 77, 0},
    ["pantone 151"] = {0, 48, 95, 0},
    ["pantone 152"] = {0, 51, 100, 1},
    ["pantone 1525"] = {0, 58, 100, 10},
    ["pantone 153"] = {0, 46, 100, 18},
    ["pantone 1535"] = {0, 53, 100, 38},
    ["pantone 154"] = {0, 46, 100, 34},
    ["pantone 1545"] = {0, 53, 100, 72},
    ["pantone 155"] = {0, 12, 28, 0},
    ["pantone 1555"] = {0, 22, 34, 0},
    ["pantone 156"] = {0, 22, 42, 0},
    ["pantone 1565"] = {0, 34, 49, 0},
    ["pantone 157"] = {0, 43, 70, 0},
    ["pantone 1575"] = {0, 45, 72, 0},
    ["pantone 158"] = {0, 61, 97, 0},
    ["pantone 1585"] = {0, 56, 90, 0},
    ["pantone 159"] = {0, 66, 100, 7},
    ["pantone 1595"] = {0, 59, 100, 5},
    ["pantone 160"] = {0, 62, 100, 32},
    ["pantone 1605"] = {0, 56, 100, 30},
    ["pantone 161"] = {0, 52, 100, 64},
    ["pantone 1615"] = {0, 56, 100, 43},
    ["pantone 162"] = {0, 15, 22, 0},
    ["pantone 1625"] = {0, 31, 37, 0},
    ["pantone 163"] = {0, 31, 44, 0},
    ["pantone 1635"] = {0, 39, 48, 0},
    ["pantone 164"] = {0, 46, 73, 0},
    ["pantone 1645"] = {0, 49, 66, 0},
    ["pantone 165"] = {0, 59, 96, 0},
    ["pantone 1655"] = {0, 63, 91, 0},
    ["pantone 166"] = {0, 64, 100, 0},
    ["pantone 1665"] = {0, 68, 100, 0},
    ["pantone 167"] = {0, 60, 100, 17},
    ["pantone 1675"] = {0, 67, 100, 28},
    ["pantone 168"] = {0, 57, 100, 59},
    ["pantone 1685"] = {0, 68, 100, 44},
    ["pantone 169"] = {0, 20, 20, 0},
    ["pantone 170"] = {0, 40, 44, 0},
    ["pantone 171"] = {0, 53, 68, 0},
    ["pantone 172"] = {0, 66, 88, 0},
    ["pantone 173"] = {0, 69, 100, 4},
    ["pantone 174"] = {0, 70, 100, 36},
    ["pantone 175"] = {0, 65, 100, 60},
    ["pantone 176"] = {0, 25, 18, 0},
    ["pantone 1765"] = {0, 38, 21, 0},
    ["pantone 1767"] = {0, 27, 12, 0},
    ["pantone 177"] = {0, 45, 40, 0},
    ["pantone 1775"] = {0, 47, 29, 0},
    ["pantone 1777"] = {0, 58, 36, 0},
    ["pantone 178"] = {0, 59, 56, 0},
    ["pantone 1785"] = {0, 67, 50, 0},
    ["pantone 1787"] = {0, 76, 60, 0},
    ["pantone 1788"] = {0, 84, 88, 0},
    ["pantone 179"] = {0, 79, 100, 0},
    ["pantone 1795"] = {0, 94, 100, 0},
    ["pantone 1797"] = {0, 100, 99, 4},
    ["pantone 180"] = {0, 79, 100, 11},
    ["pantone 1805"] = {0, 91, 100, 23},
    ["pantone 1807"] = {0, 100, 96, 28},
    ["pantone 181"] = {0, 74, 100, 47},
    ["pantone 1815"] = {0, 90, 100, 51},
    ["pantone 1817"] = {0, 90, 100, 66},
    ["pantone 182"] = {0, 26, 10, 0},
    ["pantone 183"] = {0, 46, 21, 0},
    ["pantone 184"] = {0, 68, 41, 0},
    ["pantone 185"] = {0, 91, 76, 0},
    ["pantone 186"] = {0, 100, 81, 4},
    ["pantone 187"] = {0, 100, 79, 20},
    ["pantone 188"] = {0, 97, 100, 50},
    ["pantone 189"] = {0, 37, 10, 0},
    ["pantone 1895"] = {0, 28, 7, 0},
    ["pantone 190"] = {0, 55, 22, 0},
    ["pantone 1905"] = {0, 41, 9, 0},
    ["pantone 191"] = {0, 76, 38, 0},
    ["pantone 1915"] = {0, 71, 20, 0},
    ["pantone 192"] = {0, 100, 68, 0},
    ["pantone 1925"] = {0, 100, 55, 0},
    ["pantone 193"] = {0, 100, 66, 13},
    ["pantone 1935"] = {0, 100, 57, 5},
    ["pantone 194"] = {0, 100, 64, 33},
    ["pantone 1945"] = {0, 100, 56, 19},
    ["pantone 195"] = {0, 100, 60, 55},
    ["pantone 1955"] = {0, 100, 60, 37},
    ["pantone 196"] = {0, 25, 4, 0},
    ["pantone 197"] = {0, 45, 10, 0},
    ["pantone 198"] = {0, 78, 33, 0},
    ["pantone 199"] = {0, 100, 62, 0},
    ["pantone 200"] = {0, 100, 63, 12},
    ["pantone 201"] = {0, 100, 63, 29},
    ["pantone 202"] = {0, 100, 61, 43},
    ["pantone 203"] = {0, 34, 3, 0},
    ["pantone 204"] = {0, 58, 3, 0},
    ["pantone 205"] = {0, 84, 9, 0},
    ["pantone 206"] = {0, 100, 38, 3},
    ["pantone 207"] = {0, 100, 43, 19},
    ["pantone 208"] = {0, 100, 36, 37},
    ["pantone 209"] = {0, 100, 34, 53},
    ["pantone 210"] = {0, 39, 6, 0},
    ["pantone 211"] = {0, 55, 8, 0},
    ["pantone 212"] = {0, 72, 11, 0},
    ["pantone 213"] = {0, 95, 27, 0},
    ["pantone 214"] = {0, 100, 34, 8},
    ["pantone 215"] = {0, 100, 35, 27},
    ["pantone 216"] = {0, 95, 40, 49},
    ["pantone 217"] = {0, 28, 0, 0},
    ["pantone 218"] = {2, 61, 0, 0},
    ["pantone 219"] = {1, 88, 0, 0},
    ["pantone 220"] = {0, 100, 13, 17},
    ["pantone 221"] = {0, 100, 15, 30},
    ["pantone 222"] = {0, 100, 10, 59},
    ["pantone 223"] = {0, 46, 0, 0},
    ["pantone 224"] = {1, 63, 0, 0},
    ["pantone 225"] = {1, 83, 0, 0},
    ["pantone 226"] = {0, 100, 0, 0},
    ["pantone 227"] = {0, 100, 7, 19},
    ["pantone 228"] = {0, 100, 4, 41},
    ["pantone 229"] = {0, 100, 15, 60},
    ["pantone 230"] = {0, 34, 0, 0},
    ["pantone 231"] = {1, 52, 0, 0},
    ["pantone 232"] = {3, 67, 0, 0},
    ["pantone 233"] = {11, 100, 0, 0},
    ["pantone 234"] = {6, 100, 0, 26},
    ["pantone 235"] = {5, 100, 0, 40},
    ["pantone 236"] = {1, 30, 0, 0},
    ["pantone 2365"] = {2, 27, 0, 0},
    ["pantone 237"] = {3, 49, 0, 0},
    ["pantone 2375"] = {10, 57, 0, 0},
    ["pantone 238"] = {6, 63, 0, 0},
    ["pantone 2385"] = {19, 79, 0, 0},
    ["pantone 239"] = {11, 79, 0, 0},
    ["pantone 2395"] = {27, 95, 0, 0},
    ["pantone 240"] = {18, 94, 0, 0},
    ["pantone 2405"] = {34, 100, 0, 0},
    ["pantone 241"] = {27, 100, 0, 2},
    ["pantone 2415"] = {33, 100, 0, 8},
    ["pantone 242"] = {10, 100, 0, 49},
    ["pantone 2425"] = {37, 100, 0, 26},
    ["pantone 243"] = {5, 29, 0, 0},
    ["pantone 244"] = {9, 38, 0, 0},
    ["pantone 245"] = {14, 53, 0, 0},
    ["pantone 246"] = {29, 90, 0, 0},
    ["pantone 247"] = {36, 100, 0, 0},
    ["pantone 248"] = {40, 100, 0, 2},
    ["pantone 249"] = {40, 100, 0, 28},
    ["pantone 250"] = {5, 18, 0, 0},
    ["pantone 251"] = {13, 39, 0, 0},
    ["pantone 252"] = {24, 56, 0, 0},
    ["pantone 253"] = {43, 95, 0, 0},
    ["pantone 254"] = {50, 100, 0, 0},
    ["pantone 255"] = {51, 100, 0, 25},
    ["pantone 256"] = {7, 20, 0, 0},
    ["pantone 2562"] = {19, 35, 0, 0},
    ["pantone 2563"] = {22, 33, 0, 0},
    ["pantone 2567"] = {29, 36, 0, 0},
    ["pantone 257"] = {14, 34, 0, 0},
    ["pantone 2572"] = {30, 47, 0, 0},
    ["pantone 2573"] = {30, 43, 0, 0},
    ["pantone 2577"] = {40, 45, 0, 0},
    ["pantone 258"] = {43, 76, 0, 0},
    ["pantone 2582"] = {46, 72, 0, 0},
    ["pantone 2583"] = {46, 63, 0, 0},
    ["pantone 2587"] = {59, 66, 0, 0},
    ["pantone 259"] = {56, 100, 0, 15},
    ["pantone 2592"] = {60, 90, 0, 0},
    ["pantone 2593"] = {61, 89, 0, 0},
    ["pantone 2597"] = {85, 100, 0, 0},
    ["pantone 260"] = {52, 100, 0, 26},
    ["pantone 2602"] = {63, 100, 0, 3},
    ["pantone 2603"] = {69, 100, 0, 2},
    ["pantone 2607"] = {81, 100, 0, 7},
    ["pantone 261"] = {48, 100, 0, 40},
    ["pantone 2612"] = {64, 100, 0, 14},
    ["pantone 2613"] = {63, 100, 0, 15},
    ["pantone 2617"] = {79, 100, 0, 15},
    ["pantone 262"] = {45, 100, 0, 55},
    ["pantone 2622"] = {58, 100, 0, 44},
    ["pantone 2623"] = {59, 100, 0, 32},
    ["pantone 2627"] = {77, 100, 0, 31},
    ["pantone 263"] = {10, 14, 0, 0},
    ["pantone 2635"] = {28, 27, 0, 0},
    ["pantone 264"] = {26, 28, 0, 0},
    ["pantone 2645"] = {40, 36, 0, 0},
    ["pantone 265"] = {54, 56, 0, 0},
    ["pantone 2655"] = {54, 49, 0, 0},
    ["pantone 266"] = {79, 90, 0, 0},
    ["pantone 2665"] = {62, 60, 0, 0},
    ["pantone 267"] = {89, 100, 0, 0},
    ["pantone 268"] = {82, 100, 0, 12},
    ["pantone 2685"] = {96, 100, 0, 10},
    ["pantone 269"] = {78, 100, 0, 33},
    ["pantone 2695"] = {91, 100, 0, 49},
    ["pantone 270"] = {31, 27, 0, 0},
    ["pantone 2705"] = {40, 30, 0, 0},
    ["pantone 2706"] = {19, 9, 0, 0},
    ["pantone 2707"] = {17, 6, 0, 0},
    ["pantone 2708"] = {26, 10, 0, 0},
    ["pantone 271"] = {43, 37, 0, 0},
    ["pantone 2715"] = {57, 45, 0, 0},
    ["pantone 2716"] = {45, 29, 0, 0},
    ["pantone 2717"] = {29, 12, 0, 0},
    ["pantone 2718"] = {67, 41, 0, 0},
    ["pantone 272"] = {58, 48, 0, 0},
    ["pantone 2725"] = {77, 68, 0, 0},
    ["pantone 2726"] = {79, 66, 0, 0},
    ["pantone 2727"] = {71, 42, 0, 0},
    ["pantone 2728"] = {96, 69, 0, 0},
    ["pantone 273"] = {100, 96, 0, 8},
    ["pantone 2735"] = {100, 95, 0, 0},
    ["pantone 2736"] = {100, 91, 0, 0},
    ["pantone 2738"] = {100, 87, 0, 2},
    ["pantone 274"] = {100, 100, 0, 28},
    ["pantone 2745"] = {100, 95, 0, 15},
    ["pantone 2746"] = {100, 92, 0, 10},
    ["pantone 2747"] = {100, 86, 0, 15},
    ["pantone 2748"] = {100, 88, 0, 15},
    ["pantone 275"] = {98, 100, 0, 43},
    ["pantone 2755"] = {100, 97, 0, 30},
    ["pantone 2756"] = {100, 94, 0, 29},
    ["pantone 2757"] = {100, 82, 0, 30},
    ["pantone 2758"] = {100, 80, 0, 26},
    ["pantone 276"] = {98, 100, 0, 55},
    ["pantone 2765"] = {100, 97, 0, 45},
    ["pantone 2766"] = {100, 94, 0, 47},
    ["pantone 2767"] = {100, 78, 0, 54},
    ["pantone 2768"] = {100, 78, 0, 44},
    ["pantone 277"] = {27, 7, 0, 0},
    ["pantone 278"] = {39, 14, 0, 0},
    ["pantone 279"] = {68, 34, 0, 0},
    ["pantone 280"] = {100, 72, 0, 18},
    ["pantone 281"] = {100, 72, 0, 32},
    ["pantone 282"] = {100, 68, 0, 54},
    ["pantone 283"] = {35, 9, 0, 0},
    ["pantone 284"] = {55, 19, 0, 0},
    ["pantone 285"] = {89, 43, 0, 0},
    ["pantone 286"] = {100, 66, 0, 2},
    ["pantone 287"] = {100, 68, 0, 12},
    ["pantone 288"] = {100, 67, 0, 23},
    ["pantone 289"] = {100, 66, 0, 58},
    ["pantone 290"] = {25, 2, 0, 0},
    ["pantone 291"] = {33, 3, 0, 0},
    ["pantone 2915"] = {59, 7, 0, 0},
    ["pantone 292"] = {49, 11, 0, 0},
    ["pantone 2925"] = {85, 24, 0, 0},
    ["pantone 293"] = {100, 57, 0, 2},
    ["pantone 2935"] = {100, 46, 0, 0},
    ["pantone 294"] = {100, 58, 0, 21},
    ["pantone 2945"] = {100, 45, 0, 14},
    ["pantone 295"] = {100, 57, 0, 37},
    ["pantone 2955"] = {100, 45, 0, 37},
    ["pantone 296"] = {100, 46, 0, 70},
    ["pantone 2965"] = {100, 38, 0, 64},
    ["pantone 297"] = {49, 1, 0, 0},
    ["pantone 2975"] = {30, 0, 5, 0},
    ["pantone 298"] = {69, 7, 0, 0},
    ["pantone 2985"] = {59, 0, 6, 0},
    ["pantone 299"] = {85, 19, 0, 0},
    ["pantone 2995"] = {90, 11, 0, 0},
    ["pantone 300"] = {100, 44, 0, 0},
    ["pantone 3005"] = {100, 36, 0, 2},
    ["pantone 301"] = {100, 45, 0, 18},
    ["pantone 3015"] = {100, 33, 0, 20},
    ["pantone 302"] = {100, 25, 0, 50},
    ["pantone 3025"] = {100, 17, 0, 51},
    ["pantone 303"] = {100, 11, 0, 74},
    ["pantone 3035"] = {100, 0, 5, 72},
    ["pantone 304"] = {30, 0, 8, 0},
    ["pantone 305"] = {51, 0, 9, 0},
    ["pantone 306"] = {75, 0, 7, 0},
    ["pantone 307"] = {100, 16, 0, 27},
    ["pantone 308"] = {100, 5, 0, 47},
    ["pantone 309"] = {100, 0, 9, 72},
    ["pantone 310"] = {43, 0, 10, 0},
    ["pantone 3105"] = {43, 0, 12, 0},
    ["pantone 311"] = {63, 0, 12, 0},
    ["pantone 3115"] = {63, 0, 18, 0},
    ["pantone 312"] = {96, 0, 11, 0},
    ["pantone 3125"] = {83, 0, 21, 0},
    ["pantone 313"] = {100, 0, 8, 13},
    ["pantone 3135"] = {100, 0, 16, 9},
    ["pantone 314"] = {100, 0, 9, 30},
    ["pantone 3145"] = {100, 0, 19, 23},
    ["pantone 315"] = {100, 0, 12, 43},
    ["pantone 3155"] = {100, 0, 24, 38},
    ["pantone 316"] = {100, 0, 27, 68},
    ["pantone 3165"] = {100, 0, 28, 65},
    ["pantone 317"] = {18, 0, 8, 0},
    ["pantone 318"] = {38, 0, 15, 0},
    ["pantone 319"] = {52, 0, 19, 0},
    ["pantone 320"] = {100, 0, 31, 7},
    ["pantone 321"] = {100, 0, 31, 23},
    ["pantone 322"] = {100, 0, 33, 35},
    ["pantone 323"] = {100, 0, 38, 47},
    ["pantone 324"] = {28, 0, 12, 0},
    ["pantone 3242"] = {37, 0, 18, 0},
    ["pantone 3245"] = {34, 0, 19, 0},
    ["pantone 3248"] = {43, 0, 24, 0},
    ["pantone 325"] = {56, 0, 26, 0},
    ["pantone 3252"] = {47, 0, 24, 0},
    ["pantone 3255"] = {49, 0, 28, 0},
    ["pantone 3258"] = {59, 0, 33, 0},
    ["pantone 326"] = {87, 0, 38, 0},
    ["pantone 3262"] = {71, 0, 33, 0},
    ["pantone 3265"] = {69, 0, 37, 0},
    ["pantone 3268"] = {90, 0, 49, 0},
    ["pantone 327"] = {100, 0, 44, 17},
    ["pantone 3272"] = {100, 0, 44, 0},
    ["pantone 3275"] = {95, 0, 47, 0},
    ["pantone 3278"] = {100, 0, 55, 5},
    ["pantone 328"] = {100, 0, 45, 32},
    ["pantone 3282"] = {100, 0, 46, 15},
    ["pantone 3285"] = {100, 0, 50, 7},
    ["pantone 3288"] = {100, 0, 54, 20},
    ["pantone 329"] = {100, 0, 46, 46},
    ["pantone 3292"] = {100, 0, 49, 46},
    ["pantone 3295"] = {100, 0, 53, 21},
    ["pantone 3298"] = {100, 0, 57, 42},
    ["pantone 330"] = {100, 0, 48, 60},
    ["pantone 3302"] = {100, 0, 54, 69},
    ["pantone 3305"] = {100, 0, 61, 61},
    ["pantone 3308"] = {100, 0, 60, 72},
    ["pantone 331"] = {24, 0, 16, 0},
    ["pantone 332"] = {30, 0, 20, 0},
    ["pantone 333"] = {43, 0, 27, 0},
    ["pantone 334"] = {100, 0, 60, 3},
    ["pantone 335"] = {100, 0, 65, 30},
    ["pantone 336"] = {100, 0, 67, 47},
    ["pantone 337"] = {31, 0, 20, 0},
    ["pantone 3375"] = {35, 0, 25, 0},
    ["pantone 338"] = {47, 0, 32, 0},
    ["pantone 3385"] = {45, 0, 33, 0},
    ["pantone 339"] = {84, 0, 56, 0},
    ["pantone 3395"] = {61, 0, 45, 0},
    ["pantone 340"] = {100, 0, 66, 9},
    ["pantone 3405"] = {85, 0, 65, 0},
    ["pantone 341"] = {100, 0, 67, 29},
    ["pantone 3415"] = {100, 0, 77, 22},
    ["pantone 342"] = {100, 0, 71, 43},
    ["pantone 3425"] = {100, 0, 78, 42},
    ["pantone 343"] = {98, 0, 72, 61},
    ["pantone 3435"] = {100, 0, 81, 66},
    ["pantone 344"] = {27, 0, 23, 0},
    ["pantone 345"] = {38, 0, 32, 0},
    ["pantone 346"] = {55, 0, 47, 0},
    ["pantone 347"] = {100, 0, 86, 3},
    ["pantone 348"] = {100, 0, 85, 24},
    ["pantone 349"] = {100, 0, 91, 42},
    ["pantone 350"] = {79, 0, 100, 75},
    ["pantone 351"] = {17, 0, 16, 0},
    ["pantone 352"] = {27, 0, 25, 0},
    ["pantone 353"] = {38, 0, 36, 0},
    ["pantone 354"] = {80, 0, 90, 0},
    ["pantone 355"] = {94, 0, 100, 0},
    ["pantone 356"] = {95, 0, 100, 27},
    ["pantone 357"] = {80, 0, 100, 56},
    ["pantone 358"] = {27, 0, 38, 0},
    ["pantone 359"] = {36, 0, 49, 0},
    ["pantone 360"] = {58, 0, 80, 0},
    ["pantone 361"] = {69, 0, 100, 0},
    ["pantone 362"] = {70, 0, 100, 9},
    ["pantone 363"] = {68, 0, 100, 24},
    ["pantone 364"] = {65, 0, 100, 42},
    ["pantone 365"] = {12, 0, 29, 0},
    ["pantone 366"] = {20, 0, 44, 0},
    ["pantone 367"] = {32, 0, 59, 0},
    ["pantone 368"] = {57, 0, 100, 0},
    ["pantone 369"] = {59, 0, 100, 7},
    ["pantone 370"] = {56, 0, 100, 27},
    ["pantone 371"] = {43, 0, 100, 56},
    ["pantone 372"] = {10, 0, 33, 0},
    ["pantone 373"] = {16, 0, 46, 0},
    ["pantone 374"] = {24, 0, 57, 0},
    ["pantone 375"] = {41, 0, 78, 0},
    ["pantone 376"] = {52, 0, 100, 5},
    ["pantone 377"] = {45, 0, 100, 24},
    ["pantone 378"] = {34, 0, 100, 60},
    ["pantone 379"] = {9, 0, 58, 0},
    ["pantone 380"] = {13, 0, 72, 0},
    ["pantone 381"] = {20, 0, 91, 0},
    ["pantone 382"] = {29, 0, 100, 0},
    ["pantone 383"] = {20, 0, 100, 19},
    ["pantone 384"] = {18, 0, 100, 31},
    ["pantone 385"] = {3, 0, 100, 58},
    ["pantone 386"] = {6, 0, 56, 0},
    ["pantone 387"] = {10, 0, 74, 0},
    ["pantone 388"] = {14, 0, 79, 0},
    ["pantone 389"] = {20, 0, 85, 0},
    ["pantone 390"] = {22, 0, 100, 8},
    ["pantone 391"] = {13, 0, 100, 33},
    ["pantone 392"] = {7, 0, 100, 49},
    ["pantone 393"] = {3, 0, 55, 0},
    ["pantone 3935"] = {1, 0, 68, 0},
    ["pantone 394"] = {6, 0, 76, 0},
    ["pantone 3945"] = {3, 0, 85, 0},
    ["pantone 395"] = {8, 0, 85, 0},
    ["pantone 3955"] = {6, 0, 100, 0},
    ["pantone 396"] = {11, 0, 94, 0},
    ["pantone 3965"] = {8, 0, 100, 0},
    ["pantone 397"] = {10, 0, 100, 11},
    ["pantone 3975"] = {0, 0, 100, 29},
    ["pantone 398"] = {7, 0, 100, 28},
    ["pantone 3985"] = {0, 3, 100, 41},
    ["pantone 399"] = {0, 0, 100, 43},
    ["pantone 3995"] = {0, 3, 100, 64},
    ["pantone 400"] = {0, 3, 6, 16},
    ["pantone 401"] = {0, 5, 11, 23},
    ["pantone 402"] = {0, 6, 14, 31},
    ["pantone 403"] = {0, 7, 17, 43},
    ["pantone 404"] = {0, 8, 22, 56},
    ["pantone 405"] = {0, 10, 33, 72},
    ["pantone 406"] = {0, 5, 6, 16},
    ["pantone 407"] = {0, 8, 9, 26},
    ["pantone 408"] = {0, 10, 11, 34},
    ["pantone 409"] = {0, 13, 15, 45},
    ["pantone 410"] = {0, 18, 21, 56},
    ["pantone 411"] = {0, 27, 36, 72},
    ["pantone 412"] = {0, 30, 66, 98},
    ["pantone 413"] = {0, 0, 9, 20},
    ["pantone 414"] = {0, 0, 10, 30},
    ["pantone 415"] = {0, 0, 12, 41},
    ["pantone 416"] = {0, 0, 16, 50},
    ["pantone 417"] = {1, 0, 25, 65},
    ["pantone 418"] = {3, 0, 31, 75},
    ["pantone 419"] = {29, 0, 36, 100},
    ["pantone 420"] = {0, 0, 0, 15},
    ["pantone 421"] = {0, 0, 0, 26},
    ["pantone 422"] = {0, 0, 0, 33},
    ["pantone 423"] = {0, 0, 0, 44},
    ["pantone 424"] = {0, 0, 0, 61},
    ["pantone 425"] = {0, 0, 0, 77},
    ["pantone 426"] = {0, 0, 0, 100},
    ["pantone 427"] = {0, 0, 0, 11},
    ["pantone 428"] = {2, 0, 0, 18},
    ["pantone 429"] = {3, 0, 0, 32},
    ["pantone 430"] = {5, 0, 0, 45},
    ["pantone 431"] = {11, 1, 0, 64},
    ["pantone 432"] = {23, 2, 0, 77},
    ["pantone 433"] = {33, 3, 0, 95},
    ["pantone 434"] = {7, 10, 9, 0},
    ["pantone 435"] = {13, 16, 14, 0},
    ["pantone 436"] = {24, 25, 25, 0},
    ["pantone 437"] = {46, 45, 46, 0},
    ["pantone 438"] = {75, 70, 100, 10},
    ["pantone 439"] = {80, 75, 100, 20},
    ["pantone 440"] = {82, 78, 100, 30},
    ["pantone 441"] = {6, 0, 7, 9},
    ["pantone 442"] = {8, 0, 9, 19},
    ["pantone 443"] = {12, 0, 12, 30},
    ["pantone 444"] = {15, 0, 15, 42},
    ["pantone 445"] = {20, 0, 20, 65},
    ["pantone 446"] = {21, 0, 23, 75},
    ["pantone 447"] = {16, 0, 31, 82},
    ["pantone 448"] = {75, 65, 100, 30},
    ["pantone 4485"] = {0, 26, 100, 69},
    ["pantone 449"] = {70, 60, 100, 20},
    ["pantone 4495"] = {0, 20, 95, 46},
    ["pantone 450"] = {65, 55, 100, 10},
    ["pantone 451"] = {33, 29, 55, 0},
    ["pantone 4515"] = {0, 9, 50, 24},
    ["pantone 452"] = {24, 19, 39, 0},
    ["pantone 4525"] = {0, 7, 39, 17},
    ["pantone 453"] = {14, 11, 25, 0},
    ["pantone 4535"] = {0, 4, 30, 11},
    ["pantone 454"] = {9, 7, 16, 0},
    ["pantone 4545"] = {0, 3, 19, 6},
    ["pantone 455"] = {0, 17, 100, 65},
    ["pantone 456"] = {0, 15, 100, 43},
    ["pantone 457"] = {0, 15, 100, 28},
    ["pantone 458"] = {10, 10, 73, 0},
    ["pantone 459"] = {6, 7, 55, 0},
    ["pantone 460"] = {4, 5, 44, 0},
    ["pantone 461"] = {3, 3, 35, 0},
    ["pantone 462"] = {50, 70, 100, 50},
    ["pantone 4625"] = {0, 60, 100, 79},
    ["pantone 463"] = {30, 60, 100, 40},
    ["pantone 4635"] = {0, 48, 96, 44},
    ["pantone 464"] = {10, 50, 100, 35},
    ["pantone 4645"] = {0, 37, 68, 28},
    ["pantone 465"] = {20, 32, 58, 0},
    ["pantone 4655"] = {0, 26, 45, 18},
    ["pantone 466"] = {12, 22, 43, 0},
    ["pantone 4665"] = {0, 18, 32, 10},
    ["pantone 467"] = {9, 15, 34, 0},
    ["pantone 4675"] = {0, 11, 21, 6},
    ["pantone 468"] = {6, 9, 23, 0},
    ["pantone 4685"] = {0, 7, 14, 4},
    ["pantone 469"] = {0, 65, 100, 71},
    ["pantone 4695"] = {0, 81, 100, 74},
    ["pantone 470"] = {0, 58, 100, 33},
    ["pantone 4705"] = {0, 62, 71, 49},
    ["pantone 471"] = {0, 59, 100, 18},
    ["pantone 4715"] = {0, 42, 45, 34},
    ["pantone 472"] = {0, 34, 52, 0},
    ["pantone 4725"] = {0, 32, 35, 25},
    ["pantone 473"] = {0, 23, 36, 0},
    ["pantone 4735"] = {0, 22, 23, 15},
    ["pantone 474"] = {0, 15, 26, 0},
    ["pantone 4745"] = {0, 17, 18, 10},
    ["pantone 475"] = {0, 11, 20, 0},
    ["pantone 4755"] = {0, 10, 12, 6},
    ["pantone 476"] = {60, 80, 100, 45},
    ["pantone 477"] = {50, 85, 100, 38},
    ["pantone 478"] = {40, 90, 100, 30},
    ["pantone 479"] = {31, 48, 55, 0},
    ["pantone 480"] = {15, 29, 31, 0},
    ["pantone 481"] = {9, 19, 21, 0},
    ["pantone 482"] = {5, 12, 13, 0},
    ["pantone 483"] = {0, 93, 100, 60},
    ["pantone 484"] = {0, 95, 100, 29},
    ["pantone 485"] = {0, 95, 100, 0},
    ["pantone 486"] = {0, 47, 41, 0},
    ["pantone 487"] = {0, 35, 28, 0},
    ["pantone 488"] = {0, 26, 19, 0},
    ["pantone 489"] = {0, 15, 11, 0},
    ["pantone 490"] = {0, 74, 100, 72},
    ["pantone 491"] = {0, 79, 100, 52},
    ["pantone 492"] = {0, 77, 100, 42},
    ["pantone 493"] = {0, 46, 23, 5},
    ["pantone 494"] = {0, 33, 13, 0},
    ["pantone 495"] = {0, 24, 11, 0},
    ["pantone 496"] = {0, 16, 9, 0},
    ["pantone 497"] = {0, 70, 100, 78},
    ["pantone 4975"] = {0, 73, 100, 80},
    ["pantone 498"] = {0, 64, 100, 60},
    ["pantone 4985"] = {0, 62, 51, 48},
    ["pantone 499"] = {0, 63, 100, 48},
    ["pantone 4995"] = {0, 48, 38, 34},
    ["pantone 500"] = {0, 38, 21, 11},
    ["pantone 5005"] = {0, 38, 27, 23},
    ["pantone 501"] = {0, 27, 13, 3},
    ["pantone 5015"] = {0, 25, 15, 11},
    ["pantone 502"] = {0, 18, 10, 1},
    ["pantone 5025"] = {0, 18, 12, 7},
    ["pantone 503"] = {0, 11, 8, 0},
    ["pantone 5035"] = {0, 10, 9, 3},
    ["pantone 504"] = {70, 100, 100, 35},
    ["pantone 505"] = {50, 100, 100, 25},
    ["pantone 506"] = {45, 100, 100, 15},
    ["pantone 507"] = {13, 49, 23, 0},
    ["pantone 508"] = {5, 36, 11, 0},
    ["pantone 509"] = {0, 24, 7, 0},
    ["pantone 510"] = {0, 17, 6, 0},
    ["pantone 511"] = {70, 100, 50, 20},
    ["pantone 5115"] = {80, 100, 70, 15},
    ["pantone 512"] = {60, 100, 15, 5},
    ["pantone 5125"] = {65, 86, 49, 0},
    ["pantone 513"] = {46, 88, 0, 0},
    ["pantone 5135"] = {49, 66, 28, 0},
    ["pantone 514"] = {15, 50, 0, 0},
    ["pantone 5145"] = {30, 45, 12, 0},
    ["pantone 515"] = {7, 38, 0, 0},
    ["pantone 5155"] = {17, 30, 8, 0},
    ["pantone 516"] = {3, 27, 0, 0},
    ["pantone 5165"] = {9, 19, 5, 0},
    ["pantone 517"] = {0, 18, 0, 0},
    ["pantone 5175"] = {5, 12, 3, 0},
    ["pantone 518"] = {80, 100, 60, 10},
    ["pantone 5185"] = {88, 100, 85, 10},
    ["pantone 519"] = {72, 100, 35, 5},
    ["pantone 5195"] = {75, 95, 68, 5},
    ["pantone 520"] = {64, 100, 12, 0},
    ["pantone 5205"] = {52, 63, 48, 0},
    ["pantone 521"] = {27, 47, 0, 0},
    ["pantone 5215"] = {29, 38, 24, 0},
    ["pantone 522"] = {17, 37, 0, 0},
    ["pantone 5225"] = {17, 27, 15, 0},
    ["pantone 523"] = {10, 26, 0, 0},
    ["pantone 5235"] = {10, 17, 10, 0},
    ["pantone 524"] = {6, 15, 0, 0},
    ["pantone 5245"] = {6, 10, 7, 0},
    ["pantone 525"] = {84, 100, 45, 5},
    ["pantone 5255"] = {83, 85, 0, 70},
    ["pantone 526"] = {77, 100, 7, 0},
    ["pantone 5265"] = {77, 73, 0, 46},
    ["pantone 527"] = {73, 100, 0, 0},
    ["pantone 5275"] = {67, 57, 0, 34},
    ["pantone 528"] = {41, 55, 0, 0},
    ["pantone 5285"] = {42, 35, 0, 23},
    ["pantone 529"] = {26, 40, 0, 0},
    ["pantone 5295"] = {27, 22, 0, 10},
    ["pantone 530"] = {18, 31, 0, 0},
    ["pantone 5305"] = {16, 13, 0, 7},
    ["pantone 531"] = {10, 20, 0, 0},
    ["pantone 5315"] = {6, 6, 0, 5},
    ["pantone 532"] = {100, 88, 70, 18},
    ["pantone 533"] = {100, 85, 46, 11},
    ["pantone 534"] = {100, 82, 30, 5},
    ["pantone 535"] = {42, 30, 7, 0},
    ["pantone 536"] = {31, 22, 5, 0},
    ["pantone 537"] = {22, 14, 3, 0},
    ["pantone 538"] = {13, 9, 2, 0},
    ["pantone 539"] = {100, 49, 0, 70},
    ["pantone 5395"] = {100, 44, 0, 76},
    ["pantone 540"] = {100, 55, 0, 55},
    ["pantone 5405"] = {58, 17, 0, 46},
    ["pantone 541"] = {100, 57, 0, 38},
    ["pantone 5415"] = {40, 8, 0, 41},
    ["pantone 542"] = {62, 22, 0, 3},
    ["pantone 5425"] = {30, 4, 0, 31},
    ["pantone 543"] = {41, 11, 0, 0},
    ["pantone 5435"] = {13, 3, 0, 17},
    ["pantone 544"] = {30, 6, 0, 0},
    ["pantone 5445"] = {8, 1, 0, 13},
    ["pantone 545"] = {22, 3, 0, 0},
    ["pantone 5455"] = {6, 0, 0, 9},
    ["pantone 546"] = {95, 9, 0, 83},
    ["pantone 5463"] = {100, 0, 18, 83},
    ["pantone 5467"] = {100, 0, 30, 95},
    ["pantone 547"] = {100, 19, 0, 75},
    ["pantone 5473"] = {82, 0, 28, 52},
    ["pantone 5477"] = {56, 0, 27, 74},
    ["pantone 548"] = {100, 24, 0, 64},
    ["pantone 5483"] = {62, 0, 21, 31},
    ["pantone 5487"] = {36, 0, 17, 56},
    ["pantone 549"] = {54, 7, 0, 27},
    ["pantone 5493"] = {43, 0, 14, 21},
    ["pantone 5497"] = {18, 0, 9, 38},
    ["pantone 550"] = {39, 4, 0, 21},
    ["pantone 5503"] = {29, 0, 10, 14},
    ["pantone 5507"] = {11, 0, 7, 29},
    ["pantone 551"] = {27, 3, 0, 13},
    ["pantone 5513"] = {18, 0, 7, 5},
    ["pantone 5517"] = {9, 0, 6, 18},
    ["pantone 552"] = {15, 0, 0, 9},
    ["pantone 5523"] = {11, 0, 5, 3},
    ["pantone 5527"] = {6, 0, 4, 11},
    ["pantone 553"] = {60, 0, 51, 80},
    ["pantone 5535"] = {66, 0, 57, 82},
    ["pantone 554"] = {80, 0, 60, 67},
    ["pantone 5545"] = {59, 0, 50, 52},
    ["pantone 555"] = {79, 0, 56, 56},
    ["pantone 5555"] = {43, 0, 34, 38},
    ["pantone 556"] = {45, 0, 31, 27},
    ["pantone 5565"] = {30, 0, 24, 26},
    ["pantone 557"] = {30, 0, 20, 15},
    ["pantone 5575"] = {20, 0, 16, 17},
    ["pantone 558"] = {20, 0, 13, 9},
    ["pantone 5585"] = {12, 0, 11, 10},
    ["pantone 559"] = {14, 0, 10, 6},
    ["pantone 5595"] = {7, 0, 8, 7},
    ["pantone 560"] = {80, 0, 63, 75},
    ["pantone 5605"] = {65, 0, 56, 94},
    ["pantone 561"] = {85, 0, 54, 52},
    ["pantone 5615"] = {44, 0, 47, 68},
    ["pantone 562"] = {85, 0, 50, 31},
    ["pantone 5625"] = {28, 0, 30, 51},
    ["pantone 563"] = {52, 0, 32, 1},
    ["pantone 5635"] = {16, 0, 18, 36},
    ["pantone 564"] = {37, 0, 20, 0},
    ["pantone 5645"] = {9, 0, 13, 25},
    ["pantone 565"] = {23, 0, 13, 0},
    ["pantone 5655"] = {6, 0, 9, 18},
    ["pantone 566"] = {14, 0, 9, 0},
    ["pantone 5665"] = {5, 0, 7, 10},
    ["pantone 567"] = {82, 0, 64, 70},
    ["pantone 568"] = {88, 0, 57, 36},
    ["pantone 569"] = {98, 0, 57, 17},
    ["pantone 570"] = {48, 0, 29, 0},
    ["pantone 571"] = {32, 0, 19, 0},
    ["pantone 572"] = {23, 0, 14, 0},
    ["pantone 573"] = {14, 0, 9, 0},
    ["pantone 574"] = {34, 0, 81, 71},
    ["pantone 5743"] = {33, 0, 85, 82},
    ["pantone 5747"] = {32, 0, 100, 79},
    ["pantone 575"] = {48, 0, 100, 53},
    ["pantone 5753"] = {25, 0, 81, 67},
    ["pantone 5757"] = {27, 0, 95, 55},
    ["pantone 576"] = {49, 0, 100, 39},
    ["pantone 5763"] = {16, 0, 74, 57},
    ["pantone 5767"] = {15, 0, 68, 39},
    ["pantone 577"] = {24, 0, 46, 10},
    ["pantone 5773"] = {9, 0, 43, 38},
    ["pantone 5777"] = {10, 0, 49, 28},
    ["pantone 578"] = {20, 0, 40, 6},
    ["pantone 5783"] = {6, 0, 28, 27},
    ["pantone 5787"] = {7, 0, 31, 13},
    ["pantone 579"] = {17, 0, 34, 3},
    ["pantone 5793"] = {4, 0, 21, 18},
    ["pantone 5797"] = {5, 0, 24, 9},
    ["pantone 580"] = {12, 0, 26, 2},
    ["pantone 5803"] = {2, 0, 12, 11},
    ["pantone 5807"] = {3, 0, 14, 6},
    ["pantone 581"] = {2, 0, 100, 72},
    ["pantone 5815"] = {0, 0, 91, 79},
    ["pantone 582"] = {13, 0, 100, 46},
    ["pantone 5825"] = {0, 2, 87, 59},
    ["pantone 583"] = {23, 0, 100, 17},
    ["pantone 5835"] = {0, 2, 67, 40},
    ["pantone 584"] = {12, 0, 79, 6},
    ["pantone 5845"] = {0, 1, 47, 30},
    ["pantone 585"] = {11, 0, 66, 2},
    ["pantone 5855"] = {0, 0, 31, 18},
    ["pantone 586"] = {9, 0, 53, 0},
    ["pantone 5865"] = {0, 0, 25, 13},
    ["pantone 587"] = {5, 0, 40, 0},
    ["pantone 5875"] = {0, 0, 18, 8},
    ["pantone 600"] = {0, 0, 29, 0},
    ["pantone 601"] = {0, 0, 40, 0},
    ["pantone 602"] = {0, 0, 51, 0},
    ["pantone 603"] = {0, 0, 69, 1},
    ["pantone 604"] = {0, 0, 88, 3},
    ["pantone 605"] = {0, 2, 100, 7},
    ["pantone 606"] = {0, 4, 100, 12},
    ["pantone 607"] = {0, 0, 18, 1},
    ["pantone 608"] = {0, 0, 32, 2},
    ["pantone 609"] = {0, 0, 46, 4},
    ["pantone 610"] = {0, 0, 58, 6},
    ["pantone 611"] = {0, 1, 92, 11},
    ["pantone 612"] = {0, 2, 100, 20},
    ["pantone 613"] = {0, 4, 100, 30},
    ["pantone 614"] = {0, 0, 20, 4},
    ["pantone 615"] = {0, 1, 27, 6},
    ["pantone 616"] = {0, 2, 35, 9},
    ["pantone 617"] = {0, 2, 48, 17},
    ["pantone 618"] = {0, 3, 87, 30},
    ["pantone 619"] = {0, 4, 100, 43},
    ["pantone 620"] = {0, 5, 100, 53},
    ["pantone 621"] = {13, 0, 10, 2},
    ["pantone 622"] = {24, 0, 19, 4},
    ["pantone 623"] = {32, 0, 24, 10},
    ["pantone 624"] = {44, 0, 35, 20},
    ["pantone 625"] = {56, 0, 44, 33},
    ["pantone 626"] = {76, 0, 64, 63},
    ["pantone 627"] = {90, 0, 76, 84},
    ["pantone 628"] = {19, 0, 6, 0},
    ["pantone 629"] = {34, 0, 9, 0},
    ["pantone 630"] = {47, 0, 11, 0},
    ["pantone 631"] = {67, 0, 12, 2},
    ["pantone 632"] = {92, 0, 15, 5},
    ["pantone 633"] = {100, 0, 10, 25},
    ["pantone 634"] = {100, 0, 9, 40},
    ["pantone 635"] = {32, 0, 8, 0},
    ["pantone 636"] = {45, 0, 9, 0},
    ["pantone 637"] = {55, 0, 9, 0},
    ["pantone 638"] = {83, 0, 10, 0},
    ["pantone 639"] = {100, 0, 5, 5},
    ["pantone 640"] = {100, 0, 0, 22},
    ["pantone 641"] = {100, 4, 0, 30},
    ["pantone 642"] = {16, 4, 0, 2},
    ["pantone 643"] = {25, 7, 0, 4},
    ["pantone 644"] = {42, 15, 0, 6},
    ["pantone 645"] = {57, 28, 0, 9},
    ["pantone 646"] = {69, 34, 0, 11},
    ["pantone 647"] = {100, 56, 0, 23},
    ["pantone 648"] = {100, 62, 0, 54},
    ["pantone 649"] = {14, 6, 0, 1},
    ["pantone 650"] = {24, 9, 0, 2},
    ["pantone 651"] = {38, 18, 0, 6},
    ["pantone 652"] = {60, 34, 0, 10},
    ["pantone 653"] = {100, 62, 0, 20},
    ["pantone 654"] = {100, 64, 0, 38},
    ["pantone 655"] = {100, 65, 0, 52},
    ["pantone 656"] = {14, 4, 0, 0},
    ["pantone 657"] = {24, 8, 0, 0},
    ["pantone 658"] = {41, 20, 0, 0},
    ["pantone 659"] = {64, 35, 0, 0},
    ["pantone 660"] = {90, 57, 0, 0},
    ["pantone 661"] = {100, 69, 0, 9},
    ["pantone 662"] = {100, 72, 0, 18},
    ["pantone 663"] = {7, 6, 0, 0},
    ["pantone 664"] = {11, 9, 0, 0},
    ["pantone 665"] = {20, 17, 0, 2},
    ["pantone 666"] = {31, 30, 0, 7},
    ["pantone 667"] = {52, 49, 0, 14},
    ["pantone 668"] = {65, 64, 0, 30},
    ["pantone 669"] = {76, 78, 0, 47},
    ["pantone 670"] = {0, 13, 0, 0},
    ["pantone 671"] = {1, 20, 0, 0},
    ["pantone 672"] = {3, 34, 0, 0},
    ["pantone 673"] = {6, 49, 0, 0},
    ["pantone 674"] = {9, 67, 0, 0},
    ["pantone 675"] = {17, 100, 0, 3},
    ["pantone 676"] = {6, 100, 0, 22},
    ["pantone 677"] = {2, 13, 0, 0},
    ["pantone 678"] = {3, 21, 0, 0},
    ["pantone 679"] = {5, 27, 0, 0},
    ["pantone 680"] = {10, 43, 0, 2},
    ["pantone 681"] = {21, 61, 0, 4},
    ["pantone 682"] = {25, 79, 0, 12},
    ["pantone 683"] = {11, 100, 0, 43},
    ["pantone 684"] = {0, 17, 0, 2},
    ["pantone 685"] = {0, 25, 0, 3},
    ["pantone 686"] = {0, 30, 0, 5},
    ["pantone 687"] = {2, 44, 0, 12},
    ["pantone 688"] = {5, 57, 0, 19},
    ["pantone 689"] = {7, 77, 0, 34},
    ["pantone 690"] = {0, 97, 0, 59},
    ["pantone 691"] = {0, 15, 8, 1},
    ["pantone 692"] = {0, 23, 10, 2},
    ["pantone 693"] = {0, 30, 12, 6},
    ["pantone 694"] = {0, 43, 19, 10},
    ["pantone 695"] = {0, 58, 28, 25},
    ["pantone 696"] = {0, 84, 54, 40},
    ["pantone 697"] = {0, 93, 70, 51},
    ["pantone 698"] = {0, 16, 8, 0},
    ["pantone 699"] = {0, 24, 10, 0},
    ["pantone 700"] = {0, 36, 14, 0},
    ["pantone 701"] = {0, 53, 20, 0},
    ["pantone 702"] = {0, 69, 34, 5},
    ["pantone 703"] = {0, 83, 54, 16},
    ["pantone 704"] = {0, 100, 80, 27},
    ["pantone 705"] = {0, 9, 5, 0},
    ["pantone 706"] = {0, 17, 10, 0},
    ["pantone 707"] = {0, 30, 14, 0},
    ["pantone 708"] = {0, 46, 22, 0},
    ["pantone 709"] = {0, 66, 38, 0},
    ["pantone 710"] = {0, 79, 58, 0},
    ["pantone 711"] = {0, 100, 80, 2},
    ["pantone 712"] = {0, 14, 31, 0},
    ["pantone 713"] = {0, 19, 41, 0},
    ["pantone 714"] = {0, 28, 54, 0},
    ["pantone 715"] = {0, 37, 71, 0},
    ["pantone 716"] = {0, 47, 91, 0},
    ["pantone 717"] = {0, 55, 100, 2},
    ["pantone 718"] = {0, 58, 100, 8},
    ["pantone 719"] = {0, 10, 25, 0},
    ["pantone 720"] = {0, 15, 34, 1},
    ["pantone 721"] = {0, 24, 52, 3},
    ["pantone 722"] = {0, 36, 76, 9},
    ["pantone 723"] = {0, 45, 95, 17},
    ["pantone 724"] = {0, 53, 100, 37},
    ["pantone 725"] = {0, 55, 100, 49},
    ["pantone 726"] = {0, 8, 23, 2},
    ["pantone 727"] = {0, 15, 34, 5},
    ["pantone 728"] = {0, 21, 48, 10},
    ["pantone 729"] = {0, 31, 61, 18},
    ["pantone 730"] = {0, 39, 76, 29},
    ["pantone 731"] = {0, 53, 100, 54},
    ["pantone 732"] = {0, 56, 100, 64},
    ["pantone 7401"] = {0, 4, 18, 0},
    ["pantone 7402"] = {0, 6, 30, 0},
    ["pantone 7403"] = {0, 10, 50, 0},
    ["pantone 7404"] = {0, 9, 80, 0},
    ["pantone 7405"] = {0, 10, 100, 0},
    ["pantone 7406"] = {0, 18, 100, 0},
    ["pantone 7407"] = {0, 22, 85, 11},
    ["pantone 7408"] = {0, 25, 95, 0},
    ["pantone 7409"] = {0, 30, 95, 0},
    ["pantone 7410"] = {0, 30, 55, 0},
    ["pantone 7411"] = {0, 35, 69, 0},
    ["pantone 7412"] = {0, 42, 100, 7},
    ["pantone 7413"] = {0, 53, 100, 4},
    ["pantone 7414"] = {0, 46, 100, 11},
    ["pantone 7415"] = {0, 18, 15, 0},
    ["pantone 7416"] = {0, 60, 60, 0},
    ["pantone 7417"] = {0, 75, 75, 0},
    ["pantone 7418"] = {0, 70, 60, 5},
    ["pantone 7419"] = {0, 60, 45, 18},
    ["pantone 7420"] = {0, 80, 42, 20},
    ["pantone 7421"] = {0, 100, 30, 61},
    ["pantone 7422"] = {0, 9, 5, 0},
    ["pantone 7423"] = {0, 55, 22, 0},
    ["pantone 7424"] = {0, 75, 30, 0},
    ["pantone 7425"] = {0, 90, 30, 7},
    ["pantone 7426"] = {0, 100, 45, 18},
    ["pantone 7427"] = {0, 100, 65, 28},
    ["pantone 7428"] = {0, 80, 45, 55},
    ["pantone 7429"] = {0, 18, 3, 0},
    ["pantone 7430"] = {2, 31, 0, 0},
    ["pantone 7431"] = {0, 38, 2, 5},
    ["pantone 7432"] = {0, 55, 3, 10},
    ["pantone 7433"] = {0, 75, 15, 15},
    ["pantone 7434"] = {0, 80, 15, 20},
    ["pantone 7435"] = {0, 100, 10, 35},
    ["pantone 7436"] = {3, 8, 0, 0},
    ["pantone 7437"] = {6, 20, 0, 0},
    ["pantone 7438"] = {15, 35, 0, 0},
    ["pantone 7439"] = {20, 35, 0, 0},
    ["pantone 7440"] = {30, 40, 0, 0},
    ["pantone 7441"] = {36, 50, 0, 0},
    ["pantone 7442"] = {50, 70, 0, 0},
    ["pantone 7443"] = {6, 5, 0, 0},
    ["pantone 7444"] = {20, 17, 0, 0},
    ["pantone 7445"] = {30, 20, 0, 3},
    ["pantone 7446"] = {43, 38, 0, 0},
    ["pantone 7447"] = {60, 58, 0, 19},
    ["pantone 7448"] = {32, 42, 0, 55},
    ["pantone 7449"] = {72, 100, 77, 46},
    ["pantone 7450"] = {20, 10, 0, 0},
    ["pantone 7451"] = {40, 21, 0, 0},
    ["pantone 7452"] = {50, 32, 0, 0},
    ["pantone 7453"] = {50, 26, 0, 0},
    ["pantone 7454"] = {50, 24, 0, 10},
    ["pantone 7455"] = {80, 53, 0, 0},
    ["pantone 7456"] = {55, 35, 0, 7},
    ["pantone 7457"] = {12, 0, 2, 0},
    ["pantone 7458"] = {40, 0, 5, 6},
    ["pantone 7459"] = {57, 0, 6, 13},
    ["pantone 7460"] = {100, 0, 0, 5},
    ["pantone 7461"] = {78, 28, 0, 0},
    ["pantone 7462"] = {100, 50, 0, 10},
    ["pantone 7463"] = {100, 43, 0, 65},
    ["pantone 7464"] = {25, 0, 10, 0},
    ["pantone 7465"] = {50, 0, 25, 0},
    ["pantone 7466"] = {70, 0, 23, 0},
    ["pantone 7467"] = {95, 0, 25, 0},
    ["pantone 7468"] = {100, 10, 0, 28},
    ["pantone 7469"] = {100, 20, 0, 40},
    ["pantone 7470"] = {80, 15, 0, 45},
    ["pantone 7471"] = {28, 0, 14, 0},
    ["pantone 7472"] = {52, 0, 25, 0},
    ["pantone 7473"] = {70, 0, 38, 8},
    ["pantone 7474"] = {90, 0, 28, 22},
    ["pantone 7475"] = {50, 0, 25, 30},
    ["pantone 7476"] = {100, 0, 43, 60},
    ["pantone 7477"] = {80, 0, 10, 68},
    ["pantone 7478"] = {18, 0, 14, 0},
    ["pantone 7479"] = {55, 0, 50, 0},
    ["pantone 7480"] = {60, 0, 50, 0},
    ["pantone 7481"] = {60, 0, 55, 0},
    ["pantone 7482"] = {80, 0, 75, 0},
    ["pantone 7483"] = {85, 0, 100, 55},
    ["pantone 7484"] = {100, 0, 85, 50},
    ["pantone 7485"] = {6, 0, 10, 0},
    ["pantone 7486"] = {20, 0, 30, 0},
    ["pantone 7487"] = {30, 0, 45, 0},
    ["pantone 7488"] = {43, 0, 60, 0},
    ["pantone 7489"] = {60, 0, 80, 7},
    ["pantone 7490"] = {45, 0, 80, 35},
    ["pantone 7491"] = {32, 0, 100, 40},
    ["pantone 7492"] = {12, 0, 50, 7},
    ["pantone 7493"] = {14, 0, 36, 10},
    ["pantone 7494"] = {25, 0, 40, 15},
    ["pantone 7495"] = {25, 0, 80, 30},
    ["pantone 7496"] = {40, 0, 100, 38},
    ["pantone 7497"] = {40, 30, 70, 25},
    ["pantone 7498"] = {25, 0, 100, 80},
    ["pantone 7499"] = {0, 2, 15, 0},
    ["pantone 7500"] = {0, 2, 15, 3},
    ["pantone 7501"] = {0, 4, 20, 6},
    ["pantone 7502"] = {0, 8, 35, 10},
    ["pantone 7503"] = {0, 12, 35, 25},
    ["pantone 7504"] = {0, 25, 45, 40},
    ["pantone 7505"] = {0, 30, 70, 55},
    ["pantone 7506"] = {0, 5, 15, 0},
    ["pantone 7507"] = {0, 10, 30, 0},
    ["pantone 7508"] = {0, 15, 40, 4},
    ["pantone 7509"] = {0, 20, 50, 5},
    ["pantone 7510"] = {0, 30, 72, 11},
    ["pantone 7511"] = {0, 45, 100, 25},
    ["pantone 7512"] = {0, 46, 100, 33},
    ["pantone 7513"] = {0, 18, 28, 3},
    ["pantone 7514"] = {0, 24, 38, 5},
    ["pantone 7515"] = {0, 35, 50, 12},
    ["pantone 7516"] = {0, 52, 100, 35},
    ["pantone 7517"] = {0, 60, 100, 44},
    ["pantone 7518"] = {0, 40, 55, 60},
    ["pantone 7519"] = {50, 60, 100, 48},
    ["pantone 7520"] = {0, 16, 19, 0},
    ["pantone 7521"] = {0, 25, 20, 10},
    ["pantone 7522"] = {0, 40, 30, 16},
    ["pantone 7523"] = {0, 40, 35, 20},
    ["pantone 7524"] = {0, 55, 60, 27},
    ["pantone 7525"] = {0, 45, 50, 30},
    ["pantone 7526"] = {0, 65, 100, 35},
    ["pantone 7527"] = {0, 2, 6, 7},
    ["pantone 7528"] = {0, 3, 10, 10},
    ["pantone 7529"] = {0, 4, 12, 17},
    ["pantone 7530"] = {0, 8, 21, 32},
    ["pantone 7531"] = {0, 10, 27, 50},
    ["pantone 7532"] = {0, 17, 50, 65},
    ["pantone 7533"] = {0, 22, 85, 85},
    ["pantone 7534"] = {0, 2, 8, 10},
    ["pantone 7535"] = {0, 3, 15, 20},
    ["pantone 7536"] = {0, 4, 22, 32},
    ["pantone 7537"] = {3, 0, 10, 20},
    ["pantone 7538"] = {9, 0, 13, 30},
    ["pantone 7539"] = {2, 0, 9, 36},
    ["pantone 7540"] = {0, 0, 0, 72},
    ["pantone 7541"] = {2, 0, 0, 5},
    ["pantone 7542"] = {10, 0, 3, 16},
    ["pantone 7543"] = {7, 0, 0, 30},
    ["pantone 7544"] = {10, 1, 0, 40},
    ["pantone 7545"] = {23, 2, 0, 63},
    ["pantone 7546"] = {33, 4, 0, 72},
    ["pantone 7547"] = {35, 4, 0, 94},
    ["pantone black"] = {0, 13, 49, 98},
    ["pantone yellow"] = {0, 3, 100, 0},
    ["pantone orange 021"] = {0, 53, 100, 0},
    ["pantone warm red"] = {0, 75, 90, 0},
    ["pantone red 032"] = {0, 90, 86, 0},
    ["pantone rubine red"] = {0, 100, 15, 4},
    ["pantone rhodamine red"] = {3, 89, 0, 0},
    ["pantone green"] = {100, 0, 59, 0},
    ["pantone purple"] = {38, 88, 0, 0},
    ["pantone violet"] = {98, 100, 0, 0},
    ["pantone reflex blue"] = {100, 73, 0, 2},
    ["pantone blue 072"] = {100, 88, 0, 5},
    ["pantone process black"] = {0, 0, 0, 100},
    ["pantone process cyan"] = {100, 0, 0, 0},
    ["pantone process magenta"] = {0, 100, 0, 0},
    ["pantone process yellow"] = {0, 0, 100, 0},
    ["pantone process blue"] = {100, 10, 0, 10},
    ["pantone black 1"] = {0, 13, 49, 98},
    ["pantone black 2"] = {0, 3, 55, 87},
    ["pantone black 3"] = {60, 0, 60, 91},
    ["pantone black 4"] = {0, 22, 100, 89},
    ["pantone black 5"] = {0, 38, 20, 89},
    ["pantone black 6"] = {100, 35, 0, 100},
    ["pantone black 7"] = {0, 0, 15, 82},
    ["pantone cool grey 1"] = {0, 0, 0, 6},
    ["pantone cool grey 2"] = {0, 0, 0, 10},
    ["pantone cool grey 3"] = {0, 0, 0, 17},
    ["pantone cool grey 4"] = {0, 0, 0, 24},
    ["pantone cool grey 5"] = {0, 0, 0, 29},
    ["pantone cool grey 6"] = {0, 0, 0, 31},
    ["pantone cool grey 7"] = {0, 1, 0, 37},
    ["pantone cool grey 8"] = {0, 1, 0, 43},
    ["pantone cool grey 9"] = {0, 0, 0, 51},
    ["pantone cool grey 10"] = {0, 2, 0, 60},
    ["pantone cool grey 11"] = {0, 2, 0, 68},
    ["pantone warm grey 1"] = {0, 2, 3, 6},
    ["pantone warm grey 2"] = {0, 2, 5, 9},
    ["pantone warm grey 3"] = {0, 4, 8, 17},
    ["pantone warm grey 4"] = {0, 4, 9, 24},
    ["pantone warm grey 5"] = {0, 5, 10, 29},
    ["pantone warm grey 6"] = {0, 6, 12, 31},
    ["pantone warm grey 7"] = {0, 8, 14, 38},
    ["pantone warm grey 8"] = {0, 9, 16, 43},
    ["pantone warm grey 9"] = {0, 11, 20, 47},
    ["pantone warm grey 10"] = {0, 14, 28, 55},
    ["pantone warm grey 11"] = {0, 17, 34, 62},
    ["hks 1"] = { 0, 10, 60, 0 },
    ["hks 2"] = { 5, 0, 100, 0 },
    ["hks 3"] = { 0, 0, 100, 0 },
    ["hks 4"] = { 0, 20, 100, 0 },
    ["hks 5"] = { 0, 30, 100, 0 },
    ["hks 6"] = { 0, 45, 100, 0 },
    ["hks 7"] = { 0, 60, 100, 0 },
    ["hks 8"] = { 0, 65, 100, 0 },
    ["hks 10"] = { 0, 85, 100, 0 },
    ["hks 11"] = { 0, 45, 50, 0 },
    ["hks 12"] = { 0, 85, 95, 0 },
    ["hks 13"] = { 0, 100, 95, 0 },
    ["hks 14"] = { 0, 100, 100, 0 },
    ["hks 15"] = { 10, 100, 80, 0 },
    ["hks 16"] = { 16, 100, 90, 0 },
    ["hks 17"] = { 30, 100, 70, 0 },
    ["hks 18"] = { 60, 100, 80, 0 },
    ["hks 21"] = { 0, 55, 25, 0 },
    ["hks 22"] = { 0, 90, 80, 0 },
    ["hks 23"] = { 0, 100, 70, 0 },
    ["hks 24"] = { 0, 100, 50, 0 },
    ["hks 25"] = { 0, 100, 25, 0 },
    ["hks 26"] = { 20, 100, 20, 0 },
    ["hks 27"] = { 5, 100, 0, 0 },
    ["hks 28"] = { 20, 100, 40, 0 },
    ["hks 29"] = { 50, 100, 0, 0 },
    ["hks 31"] = { 20, 100, 0, 0 },
    ["hks 32"] = { 10, 100, 0, 0 },
    ["hks 33"] = { 60, 100, 0, 0 },
    ["hks 34"] = { 80, 100, 0, 0 },
    ["hks 35"] = { 90, 90, 0, 0 },
    ["hks 36"] = { 80, 90, 0, 0 },
    ["hks 37"] = { 90, 100, 0, 0 },
    ["hks 38"] = { 100, 60, 20, 70 },
    ["hks 39"] = { 90, 50, 0, 0 },
    ["hks 40"] = { 100, 30, 15, 0 },
    ["hks 41"] = { 100, 70, 10, 60 },
    ["hks 42"] = { 100, 80, 0, 0 },
    ["hks 43"] = { 100, 70, 0, 0 },
    ["hks 44"] = { 100, 50, 0, 0 },
    ["hks 45"] = { 90, 70, 0, 0 },
    ["hks 46"] = { 90, 30, 5, 5 },
    ["hks 47"] = { 100, 0, 0, 0 },
    ["hks 48"] = { 100, 0, 10, 0 },
    ["hks 49"] = { 100, 20, 10, 0 },
    ["hks 50"] = { 65, 0, 5, 0 },
    ["hks 51"] = { 100, 0, 45, 0 },
    ["hks 52"] = { 95, 0, 55, 0 },
    ["hks 53"] = { 80, 0, 60, 0 },
    ["hks 54"] = { 100, 0, 80, 0 },
    ["hks 55"] = { 100, 0, 100, 10 },
    ["hks 56"] = { 100, 50, 70, 30 },
    ["hks 57"] = { 100, 0, 80, 0 },
    ["hks 58"] = { 60, 0, 90, 20 },
    ["hks 59"] = { 100, 0, 65, 50 },
    ["hks 60"] = { 80, 5, 50, 20 },
    ["hks 61"] = { 70, 0, 100, 75 },
    ["hks 62"] = { 10, 0, 70, 60 },
    ["hks 63"] = { 60, 0, 90, 40 },
    ["hks 64"] = { 85, 0, 100, 10 },
    ["hks 65"] = { 65, 0, 100, 0 },
    ["hks 66"] = { 60, 0, 100, 0 },
    ["hks 67"] = { 60, 0, 95, 0 },
    ["hks 68"] = { 20, 20, 100, 0 },
    ["hks 69"] = { 20, 0, 100, 0 },
    ["hks 71"] = { 10, 50, 100, 0 },
    ["hks 72"] = { 10, 55, 100, 0 },
    ["hks 73"] = { 0, 55, 100, 20 },
    ["hks 74"] = { 0, 50, 100, 55 },
    ["hks 75"] = { 10, 30, 80, 60 },
    ["hks 76"] = { 0, 60, 90, 80 },
    ["hks 77"] = { 0, 60, 60, 70 },
    ["hks 78"] = { 60, 95, 100, 0 },
    ["hks 81"] = { 10, 80, 100, 0 },
    ["hks 82"] = { 0, 85, 100, 30 },
    ["hks 83"] = { 0, 75, 70, 50 },
    ["hks 84"] = { 0, 80, 70, 60 },
    ["hks 88"] = { 0, 0, 0, 100 },
    ["hks 89"] = { 0, 10, 30, 35 },
    ["hks 90"] = { 0, 25, 30, 90 },
    ["hks 91"] = { 10, 0, 10, 40 },
    ["hks 92"] = { 10, 0, 0, 70 },
    ["hks 93"] = { 20, 0, 10, 80 },
    ["hks 95"] = { 0, 0, 20, 50 },
    ["hks 96"] = { 0, 0, 20, 60 },
    ["hks 97"] = { 10, 0, 20, 90 },
}


-- The color profile defaults to 'ISO coated v2'. This is obsolete and only for backwards compatibility
function set_colorprofile_filename(fn)
    for k,v in pairs(colorprofiles) do
        if v.filename == fn then
            currentcolorprofile = v.identifier
            return
        end
    end
    currentcolorprofile = {identifier = fn, filename = fn, colors = 4, objectid = 0}
    colorprofiles[fn] = currentcolorprofile
end

-- set the default color profile
function set_colorprofile(name)
    local tmp = colorprofiles[name]
    if not tmp then
        err("Color profile with ID %q not found. Using default %q",tostring(name),"FOGRA39")
        currentcolorprofile = colorprofiles["FOGRA39"]
    else
        currentcolorprofile = tmp
    end
end

-- get the current color profile
function get_colorprofile( )
    return currentcolorprofile
end

-- register a color profile
function register_colorprofile( name, options )
    colorprofiles[name] = { identifier = name }
    local cp = colorprofiles[name]
    for k,v in pairs(options) do
        cp[k] = v
    end
end

-- Make sure that the color profile is written to the PDF.
function write_colorprofile()
    if currentcolorprofile.objectid == nil or currentcolorprofile.objectid == 0 then
        local colorprofile_filename = currentcolorprofile.filename
        log("Loading colorprofile %s",colorprofile_filename)
        local path = kpse.find_file(colorprofile_filename)
        if not path then
            err("colorprofile not found %s",tostring(colorprofile_filename))
        else
            currentcolorprofile.objectid = pdf.immediateobj("streamfile",path,  string.format("/N %d",currentcolorprofile.colors or 4))
        end
    end
    return currentcolorprofile.objectid
end

-- DefineColor registers the colors
function register( colorname,c,m,y,k )
    colorobjects[#colorobjects + 1] = { colorname, 0 }
    local rawname
    _,_, rawname = string.find(string.lower(colorname),"^(.-)%s*[cmunkez]?%s*$")
    local cmyktable = spotcolors[rawname]
    if not cmyktable then
        spotcolors[rawname] = { c,m,y,k }
    end
    return #colorobjects
end

--- getresource is called from publisher.lua from dothingsbeforeoutput()
--- `tab` has the form
---
---     tab = {
---        [1] = "true"
---        [3] = "true"
---     }
function getresource( tab )
    local ret = {}
    for k,_ in pairs(tab) do
        local name, objnum = unpack(colorobjects[k])
        -- name is the user supplied name
        if objnum == 0 then
            objnum = use_color(name)
            colorobjects[k] = {name, objnum}
        end
        ret[#ret + 1] = string.format("/CS%d %d 0 R", k,objnum)
    end
    return table.concat(ret, " ")
end

-- Make sure the color definition is written to the PDF.
function use_color(colorname)
    local rawname
    _,_, rawname = string.find(string.lower(colorname),"^(.-)%s*[cmunkez]?%s*$")
    local cmyktable = spotcolors[rawname]
    if not cmyktable then
        err("Cannot find CMYK replacement for color %q",colorname)
        return
    end
    local pdfcolorname = "/" .. string.gsub(colorname," ","#20")
    local cp = write_colorprofile()
    local c,m,y,k = unpack(cmyktable)
    local tmp = string.format([==[[/Separation %s [ /ICCBased %d 0 R ]  << /FunctionType 2 /C0 [ 0 0 0 0 ] /C1 [ %g %g %g %g ] /Domain [ 0 1 ] /N 1 >> ]]==],pdfcolorname,cp,c/100,m/100,y/100,k/100)
    return pdf.immediateobj(tmp)
end

return {
    getresource               = getresource,
    register                  = register,
    set_colorprofile_filename = set_colorprofile_filename,
    write_colorprofile        = write_colorprofile,
    set_colorprofile          = set_colorprofile,
    register_colorprofile     = register_colorprofile,
    get_colorprofile          = get_colorprofile,
}

