/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XProcURIResolver
implements URIResolver,
EntityResolver {
    private URIResolver uriResolver = null;
    private EntityResolver entityResolver = null;
    private XProcRuntime runtime = null;
    private Hashtable<String, XdmNode> cache = new Hashtable();
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private static boolean useCache = true;

    public XProcURIResolver(XProcRuntime xProcRuntime) {
        this.runtime = xProcRuntime;
    }

    public void setUnderlyingURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public void setUnderlyingEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void cache(XdmNode xdmNode, URI uRI) {
        XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
        URI uRI2 = uRI.resolve(xdmNode2.getBaseURI());
        if (useCache) {
            this.cache.put(uRI2.toASCIIString(), xdmNode);
        }
    }

    @Override
    public Source resolve(String string, String string2) throws TransformerException {
        Object object;
        Object object2;
        this.runtime.finest(null, null, "URIResolver(" + string + "," + string2 + ")");
        try {
            object2 = new URI(string2);
            object = ((URI)object2).resolve(string).toASCIIString();
            if (this.cache.containsKey(object)) {
                this.runtime.finest(null, null, "Returning cached document.");
                return this.cache.get(object).asSource();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.runtime.finest(null, null, "URISyntaxException resolving base and href?");
        }
        if (this.uriResolver != null) {
            XMLReader xMLReader;
            object2 = this.uriResolver.resolve(string, string2);
            if (object2 != null && object2 instanceof SAXSource && (xMLReader = ((SAXSource)(object = (SAXSource)object2)).getXMLReader()) == null) {
                try {
                    xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                    xMLReader.setEntityResolver(this);
                    ((SAXSource)object).setXMLReader(xMLReader);
                }
                catch (SAXException sAXException) {
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
            return object2;
        }
        return null;
    }

    public XdmNode parse(String string, String string2) {
        return this.parse(string, string2, false);
    }

    public XdmNode parse(String string, String string2, boolean bl) {
        Object object;
        Source source = null;
        string = URIUtils.encode(string);
        this.runtime.finest(null, null, "Attempting to parse: " + string + " (" + string2 + ")");
        try {
            source = this.resolve(string, string2);
        }
        catch (TransformerException transformerException) {
            throw new XProcException(XProcConstants.dynamicError(9), (Throwable)transformerException);
        }
        if (source == null) {
            try {
                object = new URI(string2);
                source = new SAXSource(new InputSource(((URI)object).resolve(string).toASCIIString()));
                XMLReader xMLReader = ((SAXSource)source).getXMLReader();
                if (xMLReader == null) {
                    try {
                        xMLReader = XMLReaderFactory.createXMLReader();
                        ((SAXSource)source).setXMLReader(xMLReader);
                        xMLReader.setEntityResolver(this);
                    }
                    catch (SAXException sAXException) {}
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XProcException(uRISyntaxException);
            }
        }
        object = this.runtime.getProcessor().newDocumentBuilder();
        object.setDTDValidation(bl);
        object.setLineNumbering(true);
        try {
            return object.build(source);
        }
        catch (SaxonApiException saxonApiException) {
            String string3 = saxonApiException.getMessage();
            if (string3.contains("validation")) {
                throw XProcException.stepError(27, (Exception)((Object)saxonApiException));
            }
            if (string3.contains("HTTP response code: 403 ")) {
                throw XProcException.dynamicError(21);
            }
            throw XProcException.dynamicError(11, (Exception)((Object)saxonApiException));
        }
    }

    public XdmNode parse(InputSource inputSource) {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setEntityResolver(this);
            SAXSource sAXSource = new SAXSource(xMLReader, inputSource);
            DocumentBuilder documentBuilder = this.runtime.getProcessor().newDocumentBuilder();
            documentBuilder.setLineNumbering(true);
            documentBuilder.setDTDValidation(false);
            return documentBuilder.build((Source)sAXSource);
        }
        catch (SaxonApiException saxonApiException) {
            String string = saxonApiException.getMessage();
            if (string.contains("validation")) {
                throw XProcException.stepError(27, (Exception)((Object)saxonApiException));
            }
            if (string.contains("HTTP response code: 403 ")) {
                throw XProcException.dynamicError(21);
            }
            throw XProcException.dynamicError(11, (Exception)((Object)saxonApiException));
        }
        catch (SAXException sAXException) {
            throw new XProcException(sAXException);
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        Object object;
        this.runtime.finest(null, null, "ResolveEntity(" + string + "," + string2 + ")");
        try {
            object = new URI(string2);
            String string3 = ((URI)object).toASCIIString();
            if (this.cache.containsKey(string3)) {
                this.runtime.finest(null, null, "Returning cached document.");
                return S9apiUtils.xdmToInputSource(this.runtime, this.cache.get(string3));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.runtime.finest(null, null, "URISyntaxException resolving entityResolver systemId: " + string2);
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
        if (this.entityResolver != null) {
            object = this.entityResolver.resolveEntity(string, string2);
            return object;
        }
        return null;
    }
}

