/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XLibrary;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.URIUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class ParseArgs {
    public boolean debugExplicit = false;
    public boolean debug = false;
    public boolean showVersion = false;
    public String saxonProcessor = null;
    public String saxonConfigFile = null;
    public boolean schemaAwareExplicit = false;
    public boolean schemaAware = false;
    public boolean safeModeExplicit = false;
    public boolean safeMode = false;
    public String configFile = null;
    public String logStyle = null;
    public String entityResolverClass = null;
    public String uriResolverClass = null;
    private QName stepName = null;
    public String pipelineURI = null;
    private Vector<String> libraries = new Vector();
    public Hashtable<String, String> outputs = new Hashtable();
    private Hashtable<String, String> bindings = new Hashtable();
    private Vector<StepArgs> steps = new Vector();
    private StepArgs curStep = new StepArgs();
    private StepArgs lastStep = null;
    public boolean extensionValues = false;
    public boolean allowXPointerOnText = false;
    public boolean transparentJSON = false;
    public String jsonFlavor = null;
    private String[] args = null;
    private int argpos = 0;
    private String arg = null;

    public void parse(String[] stringArray) {
        this.args = stringArray;
        this.argpos = 0;
        this.bindings.put("p", "http://www.w3.org/ns/xproc");
        while (this.arg != null || this.argpos < stringArray.length) {
            String string;
            if (this.arg == null) {
                this.arg = stringArray[this.argpos];
            }
            if (this.arg.startsWith("-P") || this.arg.startsWith("--saxon-processor")) {
                this.saxonProcessor = this.parseString("P", "saxon-processor");
                if ("he".equals(this.saxonProcessor) || "pe".equals(this.saxonProcessor) || "ee".equals(this.saxonProcessor)) continue;
                throw new XProcException("Invalid Saxon processor option: " + this.saxonProcessor + ". Must be 'he', 'pe', or 'ee'.");
            }
            if (this.arg.startsWith("--saxon-configuration")) {
                this.saxonConfigFile = this.parseString(null, "saxon-configuration");
                continue;
            }
            if (this.arg.startsWith("-a") || this.arg.startsWith("--schema-aware")) {
                this.schemaAware = this.parseBoolean("a", "schema-aware");
                this.schemaAwareExplicit = true;
                continue;
            }
            if (this.arg.startsWith("-D") || this.arg.startsWith("--debug")) {
                this.debug = this.parseBoolean("D", "debug");
                this.debugExplicit = true;
                continue;
            }
            if (this.arg.startsWith("-S") || this.arg.startsWith("--safe-mode")) {
                this.safeMode = this.parseBoolean("S", "safe-mode");
                this.safeModeExplicit = true;
                continue;
            }
            if (this.arg.startsWith("-c") || this.arg.startsWith("--config")) {
                this.configFile = this.parseString("c", "config");
                continue;
            }
            if (this.arg.startsWith("-G") || this.arg.startsWith("--log-style")) {
                this.logStyle = this.parseString("G", "log-style");
                if ("off".equals(this.logStyle) || "plain".equals(this.logStyle) || "wrapped".equals(this.logStyle) || "directory".equals(this.logStyle)) continue;
                throw new XProcException("Invalid log style: " + this.logStyle);
            }
            if (this.arg.startsWith("-E") || this.arg.startsWith("--entity-resolver")) {
                this.entityResolverClass = this.parseString("E", "entity-resolver");
                continue;
            }
            if (this.arg.startsWith("-U") || this.arg.startsWith("--uri-resolver")) {
                this.uriResolverClass = this.parseString("U", "uri-resolver");
                continue;
            }
            if (this.arg.startsWith("-i") || this.arg.equals("--input")) {
                this.parseInput("i", "input");
                continue;
            }
            if (this.arg.startsWith("-d") || this.arg.equals("--data-input")) {
                this.parseDataInput("d", "data-input");
                continue;
            }
            if (this.arg.startsWith("-o") || this.arg.equals("--output")) {
                this.parseOutput("o", "output");
                continue;
            }
            if (this.arg.startsWith("-b") || this.arg.equals("--binding")) {
                this.parseBinding("b", "binding");
                continue;
            }
            if (this.arg.startsWith("-p") || this.arg.equals("--with-param")) {
                this.parseParam("p", "with-param");
                continue;
            }
            if (this.arg.startsWith("-v") || this.arg.equals("--version")) {
                this.showVersion = this.parseBoolean("v", "version");
                continue;
            }
            if (this.arg.startsWith("-s") || this.arg.startsWith("--step")) {
                this.stepName = this.parseQName("s", "step");
                this.curStep.setName(this.stepName);
                this.steps.add(this.curStep);
                this.lastStep = this.curStep;
                this.curStep = new StepArgs();
                continue;
            }
            if (this.arg.startsWith("-l") || this.arg.startsWith("--library")) {
                string = this.parseString("l", "library");
                this.libraries.add(string);
                continue;
            }
            if (this.arg.startsWith("-X") || this.arg.startsWith("--extension")) {
                string = this.parseString("X", "extension");
                if ("general-values".equals(string)) {
                    this.extensionValues = true;
                    continue;
                }
                if ("xpointer-on-text".equals(string)) {
                    this.allowXPointerOnText = true;
                    continue;
                }
                if ("transparent-json".equals(string)) {
                    this.transparentJSON = true;
                    continue;
                }
                if (string.startsWith("json-flavor=")) {
                    this.jsonFlavor = string.substring(12);
                    if (JSONtoXML.knownFlavor(this.jsonFlavor)) continue;
                    throw new XProcException("Can't parse JSON flavor '" + string + "' or unrecognized format: " + this.jsonFlavor);
                }
                throw new XProcException("Unexpected extension: " + string);
            }
            if (this.arg.startsWith("-")) {
                throw new XProcException("Unrecognized option: " + this.arg);
            }
            if (!this.arg.contains("=")) break;
            this.parseOption(this.arg);
            this.arg = null;
            ++this.argpos;
        }
        if (this.stepName != null && this.argpos < stringArray.length && !stringArray[this.argpos].contains("=")) {
            throw new XProcException("Bad command line. You can specify a step or a pipeline, not both.");
        }
        if (this.libraries.size() == 0 && this.stepName == null && this.argpos < stringArray.length) {
            this.pipelineURI = stringArray[this.argpos++];
        }
        while (this.argpos < stringArray.length) {
            if (stringArray[this.argpos].startsWith("-")) {
                throw new XProcException("Only options can occur on the command line after the pipeline document.");
            }
            this.parseOption(stringArray[this.argpos++]);
        }
    }

    public Set<String> getInputPorts() {
        if (this.steps.size() != 0) {
            return new HashSet<String>();
        }
        return this.curStep.inputs.keySet();
    }

    public Vector<String> getInputs(String string) {
        if (this.steps.size() != 0) {
            return new Vector<String>();
        }
        return this.curStep.inputs.get(string);
    }

    public Set<QName> getOptionNames() {
        if (this.steps.size() != 0) {
            return new HashSet<QName>();
        }
        return this.curStep.options.keySet();
    }

    public String getOption(QName qName) {
        if (this.steps.size() != 0) {
            return null;
        }
        return this.curStep.options.get(qName);
    }

    public Set<String> getParameterPorts() {
        if (this.steps.size() != 0) {
            return new HashSet<String>();
        }
        return this.curStep.params.keySet();
    }

    public Set<QName> getParameterNames(String string) {
        if (this.steps.size() != 0) {
            return new HashSet<QName>();
        }
        return this.curStep.params.get(string).keySet();
    }

    public String getParameter(String string, QName qName) {
        if (this.steps.size() != 0) {
            return null;
        }
        return this.curStep.params.get(string).get(qName);
    }

    public boolean impliedPipeline() {
        return this.steps.size() > 0 || this.libraries.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public XdmNode implicitPipeline(XProcRuntime xProcRuntime) {
        Object object;
        if (this.steps.size() == 0 && this.libraries.size() == 1) {
            try {
                object = xProcRuntime.loadLibrary(this.libraries.get(0));
                this.curStep.setName(((XLibrary)object).getFirstPipelineType());
                this.steps.add(this.curStep);
            }
            catch (SaxonApiException saxonApiException) {
                throw new XProcException(saxonApiException);
            }
        }
        object = new TreeWriter(xProcRuntime);
        ((TreeWriter)object).startDocument(xProcRuntime.getStaticBaseURI());
        ((TreeWriter)object).addStartElement(XProcConstants.p_declare_step);
        ((TreeWriter)object).addAttribute(new QName("version"), "1.0");
        ((TreeWriter)object).startContent();
        ((TreeWriter)object).addStartElement(XProcConstants.p_input);
        ((TreeWriter)object).addAttribute(new QName("port"), "source");
        ((TreeWriter)object).addAttribute(new QName("sequence"), "true");
        ((TreeWriter)object).startContent();
        ((TreeWriter)object).addEndElement();
        ((TreeWriter)object).addStartElement(XProcConstants.p_input);
        ((TreeWriter)object).addAttribute(new QName("port"), "parameters");
        ((TreeWriter)object).addAttribute(new QName("kind"), "parameter");
        ((TreeWriter)object).startContent();
        ((TreeWriter)object).addEndElement();
        if (this.outputs.size() == 0) {
            this.outputs.put("result", "-");
        }
        String string = "cmdlineStep" + this.steps.size();
        for (String object2 : this.outputs.keySet()) {
            ((TreeWriter)object).addStartElement(XProcConstants.p_output);
            ((TreeWriter)object).addAttribute(new QName("port"), object2);
            ((TreeWriter)object).startContent();
            ((TreeWriter)object).addStartElement(XProcConstants.p_pipe);
            ((TreeWriter)object).addAttribute(new QName("step"), string);
            ((TreeWriter)object).addAttribute(new QName("port"), object2);
            ((TreeWriter)object).startContent();
            ((TreeWriter)object).addEndElement();
            ((TreeWriter)object).addEndElement();
        }
        for (String string2 : this.libraries) {
            ((TreeWriter)object).addStartElement(XProcConstants.p_import);
            ((TreeWriter)object).addAttribute(new QName("href"), string2);
            ((TreeWriter)object).startContent();
            ((TreeWriter)object).addEndElement();
        }
        int n = 0;
        for (StepArgs stepArgs : this.steps) {
            Object object2;
            ((TreeWriter)object).addStartElement(stepArgs.stepName);
            ((TreeWriter)object).addAttribute(new QName("name"), "cmdlineStep" + ++n);
            for (QName qName : stepArgs.options.keySet()) {
                ((TreeWriter)object).addAttribute(qName, stepArgs.options.get(qName));
            }
            ((TreeWriter)object).startContent();
            for (String string3 : stepArgs.inputs.keySet()) {
                ((TreeWriter)object).addStartElement(XProcConstants.p_input);
                ((TreeWriter)object).addAttribute(new QName("port"), string3);
                ((TreeWriter)object).startContent();
                for (String string4 : stepArgs.inputs.get(string3)) {
                    void var10_22;
                    object2 = XProcConstants.p_document;
                    if (string4.startsWith("xml:")) {
                        String string5 = string4.substring(4);
                    } else if (string4.startsWith("data:")) {
                        object2 = XProcConstants.p_data;
                        String string6 = string4.substring(5);
                    } else {
                        throw new UnsupportedOperationException("Unexpected URI type: " + string4);
                    }
                    if ("p:empty".equals(var10_22)) {
                        ((TreeWriter)object).addStartElement(XProcConstants.p_empty);
                        ((TreeWriter)object).startContent();
                        ((TreeWriter)object).addEndElement();
                        continue;
                    }
                    ((TreeWriter)object).addStartElement((QName)object2);
                    ((TreeWriter)object).addAttribute(new QName("href"), (String)var10_22);
                    ((TreeWriter)object).startContent();
                    ((TreeWriter)object).addEndElement();
                }
                ((TreeWriter)object).addEndElement();
            }
            for (String string7 : stepArgs.params.keySet()) {
                for (QName qName : stepArgs.params.get(string7).keySet()) {
                    object2 = stepArgs.params.get(string7).get(qName);
                    if (((String)object2).contains("'") && ((String)object2).contains("\"")) {
                        throw new IllegalArgumentException("I haven't figured out how to handle parameter values with both double and single quotes.");
                    }
                    object2 = ((String)object2).contains("'") ? "\"" + (String)object2 + "\"" : "'" + (String)object2 + "'";
                    ((TreeWriter)object).addStartElement(XProcConstants.p_with_param);
                    if (!"*".equals(string7)) {
                        ((TreeWriter)object).addAttribute(new QName("port"), string7);
                    }
                    ((TreeWriter)object).addAttribute(new QName("name"), qName.toString());
                    ((TreeWriter)object).addAttribute(new QName("select"), (String)object2);
                    ((TreeWriter)object).startContent();
                    ((TreeWriter)object).addEndElement();
                }
            }
            ((TreeWriter)object).addEndElement();
            ((TreeWriter)object).endDocument();
        }
        ((TreeWriter)object).addEndElement();
        ((TreeWriter)object).endDocument();
        return ((TreeWriter)object).getResult();
    }

    private boolean parseBoolean(String string, String string2) {
        String string3 = "-" + string;
        String string4 = "--" + string2;
        boolean bl = false;
        if (this.arg.startsWith(string3)) {
            bl = true;
            if (this.arg.equals(string3)) {
                this.arg = null;
                ++this.argpos;
            } else {
                this.arg = "-" + this.arg.substring(2);
            }
            return bl;
        }
        if (this.arg.equals(string4)) {
            bl = true;
            this.arg = null;
            ++this.argpos;
            return bl;
        }
        if (this.arg.startsWith(string4 + "=")) {
            this.arg = this.arg.substring(string4.length() + 1);
            if (!this.arg.equals("true") && !this.arg.equals("false")) {
                throw new XProcException("Unparseable command line argument: " + string4 + "=" + this.arg);
            }
            bl = this.arg.equals("true");
            this.arg = null;
            ++this.argpos;
            return bl;
        }
        throw new XProcException("Unparseable command line argument: " + this.arg);
    }

    private String parseString(String string, String string2) {
        String string3;
        String string4 = null;
        if (string != null && this.arg.startsWith(string3 = "-" + string)) {
            if (this.arg.equals(string3)) {
                string4 = this.args[++this.argpos];
                this.arg = null;
                ++this.argpos;
            } else {
                string4 = this.arg.substring(2);
                this.arg = null;
                ++this.argpos;
            }
            return string4;
        }
        string3 = "--" + string2;
        if (this.arg.equals(string3)) {
            string4 = this.args[++this.argpos];
            this.arg = null;
            ++this.argpos;
            return string4;
        }
        if (this.arg.startsWith(string3 + "=")) {
            string4 = this.arg.substring(string3.length() + 1);
            this.arg = null;
            ++this.argpos;
            return string4;
        }
        throw new XProcException("Unparseable command line argument: " + this.arg);
    }

    private QName parseQName(String string, String string2) {
        String string3 = "-" + string;
        String string4 = "--" + string2;
        String string5 = null;
        if (this.arg.startsWith(string3)) {
            if (this.arg.equals(string3)) {
                string5 = this.args[++this.argpos];
                this.arg = null;
                ++this.argpos;
            } else {
                string5 = this.arg.substring(2);
                this.arg = null;
                ++this.argpos;
            }
        } else if (this.arg.equals(string4)) {
            string5 = this.args[++this.argpos];
            this.arg = null;
            ++this.argpos;
        } else if (this.arg.startsWith(string4 + "=")) {
            string5 = this.arg.substring(string4.length() + 1);
            this.arg = null;
            ++this.argpos;
        } else {
            throw new XProcException("Unparseable command line argument: " + this.arg);
        }
        QName qName = null;
        int n = string5.indexOf(":");
        if (n > 0) {
            String string6 = string5.substring(0, n);
            if (!this.bindings.containsKey(string6)) {
                throw new XProcException("Unbound prefix \"" + string6 + "\": " + string5);
            }
            String string7 = this.bindings.get(string6);
            qName = new QName(string6, string7, string5.substring(n + 1));
        } else {
            qName = new QName("", string5);
        }
        return qName;
    }

    private KeyValuePair parseKeyValue(String string, String string2) {
        String string3 = "-" + (string == null ? "" : string);
        String string4 = "--" + string2;
        String string5 = null;
        String string6 = this.arg;
        if (string != null && this.arg.startsWith(string3)) {
            if (this.arg.equals(string3)) {
                string5 = this.args[++this.argpos];
                this.arg = null;
                ++this.argpos;
            } else {
                string5 = this.arg.substring(2);
                this.arg = null;
                ++this.argpos;
            }
        } else if (this.arg.equals(string4)) {
            string5 = this.args[++this.argpos];
            this.arg = null;
            ++this.argpos;
        } else {
            throw new XProcException("Unparseable command line argument: " + this.arg);
        }
        String string7 = null;
        String string8 = null;
        int n = string5.indexOf("=");
        if (n > 0) {
            string7 = string5.substring(0, n);
            string8 = string5.substring(n + 1);
        } else {
            string7 = string5;
            string8 = null;
        }
        if (string8 == null) {
            throw new XProcException("Unparseable command line argument: " + string6);
        }
        return new KeyValuePair(string7, string8);
    }

    private void parseInput(String string, String string2) {
        KeyValuePair keyValuePair = this.parseKeyValue(string, string2);
        String string3 = keyValuePair.value;
        if ("-".equals(string3) || string3.startsWith("http:") || string3.startsWith("https:") || string3.startsWith("file:") || "p:empty".equals(string3)) {
            this.curStep.addInput(keyValuePair.key, string3, "xml");
        } else {
            File file = new File(string3);
            String string4 = URIUtils.encode(file.getAbsolutePath());
            if ("\\".equals(System.getProperty("file.separator"))) {
                string4 = "/" + string4;
            }
            this.curStep.addInput(keyValuePair.key, "file://" + string4, "xml");
        }
    }

    private void parseDataInput(String string, String string2) {
        KeyValuePair keyValuePair = this.parseKeyValue(string, string2);
        String string3 = keyValuePair.value;
        if ("-".equals(string3) || string3.startsWith("http:") || string3.startsWith("https:") || string3.startsWith("file:") || "p:empty".equals(string3)) {
            this.curStep.addInput(keyValuePair.key, string3, "data");
        } else {
            File file = new File(string3);
            String string4 = URIUtils.encode(file.getAbsolutePath());
            if ("\\".equals(System.getProperty("file.separator"))) {
                string4 = "/" + string4;
            }
            this.curStep.addInput(keyValuePair.key, "file://" + string4, "data");
        }
    }

    private void parseOutput(String string, String string2) {
        KeyValuePair keyValuePair = this.parseKeyValue(string, string2);
        if (this.outputs.containsKey(keyValuePair.key)) {
            throw new XProcException("Duplicate output binding: " + keyValuePair.key);
        }
        String string3 = keyValuePair.value;
        if ("-".equals(string3)) {
            this.outputs.put(keyValuePair.key, string3);
        } else {
            File file = new File(string3);
            String string4 = URIUtils.encode(file.getAbsolutePath());
            if ("\\".equals(System.getProperty("file.separator"))) {
                string4 = "/" + string4;
            }
            this.outputs.put(keyValuePair.key, "file://" + string4);
        }
    }

    private void parseBinding(String string, String string2) {
        KeyValuePair keyValuePair = this.parseKeyValue(string, string2);
        this.bindings.put(keyValuePair.key, keyValuePair.value);
    }

    private void parseParam(String string, String string2) {
        KeyValuePair keyValuePair = this.parseKeyValue(string, string2);
        String string3 = "*";
        String string4 = keyValuePair.key;
        String string5 = null;
        QName qName = null;
        int n = string4.indexOf("@");
        if (n > 0) {
            string3 = string4.substring(0, n);
            string4 = string4.substring(n + 1);
        }
        if ((n = string4.indexOf(":")) > 0) {
            String string6 = string4.substring(0, n);
            if (!this.bindings.containsKey(string6)) {
                throw new XProcException("Unbound prefix \"" + string6 + "\": " + keyValuePair.key + "=" + keyValuePair.value);
            }
            string5 = this.bindings.get(string6);
            qName = new QName(string6, string5, string4.substring(n + 1));
        } else {
            qName = new QName("", string4);
        }
        this.curStep.addParameter(string3, qName, keyValuePair.value);
    }

    private void parseOption(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf("=");
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string2 = string;
            string3 = null;
        }
        if (string3 == null) {
            throw new XProcException("Unparseable option: " + string);
        }
        String string4 = null;
        QName qName = null;
        int n2 = string2.indexOf(":");
        if (n2 > 0) {
            String string5 = string2.substring(0, n2);
            if (!this.bindings.containsKey(string5)) {
                throw new XProcException("Unbound prefix \"" + string5 + "\": " + string2 + "=" + string3);
            }
            string4 = this.bindings.get(string5);
            qName = new QName(string4, string2.substring(n2 + 1), string5);
        } else {
            qName = new QName("", string2);
        }
        if (this.lastStep != null) {
            this.lastStep.addOption(qName, string3);
        } else {
            this.curStep.addOption(qName, string3);
        }
    }

    private class StepArgs {
        public QName stepName = null;
        public Hashtable<String, Vector<String>> inputs = new Hashtable();
        public Hashtable<String, Hashtable<QName, String>> params = new Hashtable();
        public Hashtable<QName, String> options = new Hashtable();

        public void setName(QName qName) {
            this.stepName = qName;
        }

        public void addInput(String string, String string2, String string3) {
            if (!this.inputs.containsKey(string)) {
                this.inputs.put(string, new Vector());
            }
            this.inputs.get(string).add(string3 + ":" + string2);
        }

        public void addOption(QName qName, String string) {
            if (this.options.containsKey(qName)) {
                throw new XProcException("Duplicate option name: " + qName);
            }
            this.options.put(qName, string);
        }

        public void addParameter(String string, QName qName, String string2) {
            Hashtable<Object, Object> hashtable = !this.params.containsKey(string) ? new Hashtable() : this.params.get(string);
            if (hashtable.containsKey(qName)) {
                throw new XProcException("Duplicate parameter name: " + qName);
            }
            hashtable.put(qName, string2);
            this.params.put(string, hashtable);
        }
    }

    private class KeyValuePair {
        public String key = null;
        public String value = null;

        public KeyValuePair(String string, String string2) {
            this.key = string;
            this.value = string2;
        }
    }
}

