/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;

public class Exec
extends DefaultStep {
    private static final QName c_result = new QName("c", "http://www.w3.org/ns/xproc-step", "result");
    private static final QName c_line = new QName("c", "http://www.w3.org/ns/xproc-step", "line");
    private static final QName cx_show_stderr = new QName("cx", "http://xmlcalabash.com/ns/extensions", "show-stderr");
    private static final QName _command = new QName("", "command");
    private static final QName _args = new QName("", "args");
    private static final QName _cwd = new QName("", "cwd");
    private static final QName _source_is_xml = new QName("", "source-is-xml");
    private static final QName _result_is_xml = new QName("", "result-is-xml");
    private static final QName _wrap_result_lines = new QName("", "wrap-result-lines");
    private static final QName _errors_is_xml = new QName("", "errors-is-xml");
    private static final QName _wrap_error_lines = new QName("", "wrap-error-lines");
    private static final QName _path_separator = new QName("", "path-separator");
    private static final QName _failure_threshold = new QName("", "failure-threshold");
    private static final QName _arg_separator = new QName("", "arg-separator");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private WritablePipe errors = null;
    private WritablePipe status = null;
    private String command = null;
    private String args = null;
    private String cwd = null;
    private boolean wrapResultLines = false;
    private boolean wrapErrorLines = false;
    private String pathSeparator = null;
    private boolean failureThreshold = false;
    private int failureThresholdValue = 0;
    private String argSeparator = null;
    private boolean sourceIsXML = false;
    private boolean resultIsXML = false;
    private boolean errorsIsXML = false;

    public Exec(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        if ("result".equals(string)) {
            this.result = writablePipe;
        } else if ("errors".equals(string)) {
            this.errors = writablePipe;
        } else {
            this.status = writablePipe;
        }
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
        this.errors.resetWriter();
        this.status.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        this.command = this.getOption(_command).getString();
        this.args = this.getOption(_args, (String)null);
        this.cwd = this.getOption(_cwd, (String)null);
        this.sourceIsXML = this.getOption(_source_is_xml, false);
        this.resultIsXML = this.getOption(_result_is_xml, false);
        this.errorsIsXML = this.getOption(_errors_is_xml, false);
        this.wrapResultLines = this.getOption(_wrap_result_lines, false);
        this.wrapErrorLines = this.getOption(_wrap_error_lines, false);
        if (this.getOption(_path_separator) != null) {
            this.pathSeparator = this.getOption(_path_separator).getString();
            if (this.pathSeparator.length() != 1) {
                throw XProcException.stepError(63);
            }
        }
        if (this.getOption(_failure_threshold) != null) {
            this.failureThreshold = true;
            this.failureThresholdValue = Integer.parseInt(this.getOption(_failure_threshold).getString());
        }
        if (this.getOption(_arg_separator) != null) {
            this.argSeparator = this.getOption(_arg_separator).getString();
            if (this.argSeparator.length() != 1) {
                throw XProcException.stepError(66);
            }
        }
        String string = System.getProperty("file.separator");
        if (this.command == null || "".equals(this.command)) {
            throw XProcException.stepError(33);
        }
        if (this.resultIsXML && this.wrapResultLines || this.errorsIsXML && this.wrapErrorLines) {
            throw new XProcException(XProcException.stepError(34));
        }
        if (this.pathSeparator != null) {
            this.command = this.command.replaceAll(Pattern.quote(this.pathSeparator), string);
        }
        String string2 = "";
        try {
            XQueryEvaluator xQueryEvaluator;
            Object object;
            Object object2;
            Object object3;
            OutputStream outputStream;
            Object object4;
            String[] stringArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.command);
            string2 = string2 + this.command;
            if (this.args != null && !"".equals(this.args)) {
                if (this.pathSeparator != null) {
                    this.args = this.args.replaceAll(Pattern.quote(this.pathSeparator), string);
                }
                stringArray = this.args.split("\\" + this.argSeparator);
                for (String object52 : stringArray) {
                    arrayList.add(object52);
                    string2 = string2 + " " + (String)object52;
                }
            }
            stringArray = new ProcessBuilder(arrayList);
            if (this.cwd != null) {
                object4 = new File(this.cwd);
                if (!((File)object4).isDirectory() || !((File)object4).canRead()) {
                    throw XProcException.stepError(34, "Cannot change to requested directory: " + this.cwd);
                }
                stringArray.directory(new File(this.cwd));
            }
            this.fine(this.step.getNode(), "Exec: " + string2);
            object4 = stringArray.start();
            if (this.source.moreDocuments()) {
                outputStream = this.source.read();
                if (this.source.moreDocuments()) {
                    throw XProcException.dynamicError(6);
                }
                OutputStream outputStream2 = ((Process)object4).getOutputStream();
                Serializer serializer = this.makeSerializer();
                object3 = null;
                if (this.sourceIsXML) {
                    object3 = ".";
                } else {
                    object3 = "//text()";
                    serializer.setOutputProperty(Serializer.Property.METHOD, "text");
                    serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
                }
                object2 = this.runtime.getProcessor();
                XQueryCompiler xQueryCompiler = object2.newXQueryCompiler();
                object = xQueryCompiler.compile((String)object3);
                xQueryEvaluator = object.load();
                xQueryEvaluator.setContextItem((XdmItem)outputStream);
                serializer.setOutputStream(outputStream2);
                xQueryEvaluator.setDestination((Destination)serializer);
                xQueryEvaluator.run();
                outputStream2.close();
            } else {
                outputStream = ((Process)object4).getOutputStream();
                outputStream.close();
            }
            boolean bl = !"false".equals(this.step.getExtensionAttribute(cx_show_stderr));
            ProcessOutputReader processOutputReader = new ProcessOutputReader(((Process)object4).getInputStream(), this.resultIsXML, this.wrapResultLines, false);
            ProcessOutputReader processOutputReader2 = new ProcessOutputReader(((Process)object4).getErrorStream(), this.errorsIsXML, this.wrapErrorLines, bl);
            object3 = new Thread(processOutputReader);
            object2 = new Thread(processOutputReader2);
            ((Thread)object3).start();
            ((Thread)object2).start();
            int n = 0;
            try {
                n = ((Process)object4).waitFor();
                ((Thread)object3).join();
                ((Thread)object2).join();
            }
            catch (InterruptedException interruptedException) {
                throw new XProcException(interruptedException);
            }
            if (this.failureThreshold && n > this.failureThresholdValue) {
                throw XProcException.stepError(64);
            }
            object = new TreeWriter(this.runtime);
            ((TreeWriter)object).startDocument(this.step.getNode().getBaseURI());
            ((TreeWriter)object).addStartElement(c_result);
            ((TreeWriter)object).startContent();
            ((TreeWriter)object).addText("" + n);
            ((TreeWriter)object).addEndElement();
            ((TreeWriter)object).endDocument();
            xQueryEvaluator = ((TreeWriter)object).getResult();
            this.status.write((XdmNode)xQueryEvaluator);
            xQueryEvaluator = processOutputReader.getResult();
            this.result.write((XdmNode)xQueryEvaluator);
            xQueryEvaluator = processOutputReader2.getResult();
            this.errors.write((XdmNode)xQueryEvaluator);
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
    }

    private class ProcessOutputReader
    implements Runnable {
        private InputStream is;
        private boolean asXML;
        private boolean showLines;
        private boolean wrapLines;
        private TreeWriter tree;

        public ProcessOutputReader(InputStream inputStream, boolean bl, boolean bl2, boolean bl3) {
            this.is = inputStream;
            this.asXML = bl;
            this.wrapLines = bl2;
            this.showLines = bl3;
            this.tree = new TreeWriter(Exec.this.runtime);
        }

        public XdmNode getResult() {
            return this.tree.getResult();
        }

        @Override
        public void run() {
            this.tree.startDocument(Exec.this.step.getNode().getBaseURI());
            this.tree.addStartElement(c_result);
            this.tree.startContent();
            if (this.asXML) {
                XdmNode xdmNode = Exec.this.runtime.parse(new InputSource(this.is));
                this.tree.addSubtree(xdmNode);
            } else {
                try {
                    if (this.wrapLines) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));
                        String string = bufferedReader.readLine();
                        while (string != null) {
                            if (this.showLines) {
                                System.err.println(string);
                            }
                            this.tree.addStartElement(c_line);
                            this.tree.startContent();
                            this.tree.addText(string);
                            this.tree.addEndElement();
                            this.tree.addText("\n");
                            string = bufferedReader.readLine();
                        }
                    } else {
                        InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                        char[] cArray = new char[1000];
                        int n = inputStreamReader.read(cArray, 0, cArray.length);
                        while (n >= 0) {
                            if (n == 0) {
                                Thread.sleep(1000L);
                                continue;
                            }
                            String string = new String(cArray, 0, n);
                            if (this.showLines) {
                                System.err.print(string);
                            }
                            this.tree.addText(string);
                            n = inputStreamReader.read(cArray, 0, cArray.length);
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new XProcException(iOException);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.tree.addEndElement();
            this.tree.endDocument();
        }
    }

    private static class ParseArgs {
        private static final String dq = "\ue000";
        private static final String sq = "\ue001";
        private static final Pattern squoted = Pattern.compile("(^.*?)'(.*?)'(.*)$");
        private static final Pattern dquoted = Pattern.compile("(^.*?)\"(.*?)\"(.*)$");

        protected ParseArgs() {
        }

        public static String[] parse(String string) {
            Vector<String> vector = new Vector<String>();
            Matcher matcher = dquoted.matcher(string = string.replaceAll("\"\"", dq).replaceAll("''", sq));
            if (matcher.matches()) {
                String[] stringArray = ParseArgs.parse(matcher.group(1).trim());
                String string2 = matcher.group(2);
                String[] stringArray2 = ParseArgs.parse(matcher.group(3).trim());
                for (String string3 : stringArray) {
                    vector.add(ParseArgs.fixup(string3));
                }
                vector.add(ParseArgs.fixup(string2));
                for (String string3 : stringArray2) {
                    vector.add(ParseArgs.fixup(string3));
                }
                return vector.toArray(new String[]{" "});
            }
            matcher = squoted.matcher(string);
            if (matcher.matches()) {
                String[] stringArray = ParseArgs.parse(matcher.group(1));
                String string4 = matcher.group(2);
                String[] stringArray3 = ParseArgs.parse(matcher.group(3));
                for (String string5 : stringArray) {
                    vector.add(ParseArgs.fixup(string5));
                }
                vector.add(ParseArgs.fixup(string4));
                for (String string5 : stringArray3) {
                    vector.add(ParseArgs.fixup(string5));
                }
                return vector.toArray(new String[]{" "});
            }
            return ParseArgs.fixup(string).split("\\s+");
        }

        private static String fixup(String string) {
            return string.replaceAll(dq, "\"").replaceAll(sq, "'");
        }
    }
}

