/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.S9apiUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public class Wrap
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _match = new QName("match");
    private static final QName _wrapper = new QName("wrapper");
    private static final QName _wrapper_prefix = new QName("wrapper-prefix");
    private static final QName _wrapper_namespace = new QName("wrapper-namespace");
    private static final QName _group_adjacent = new QName("group-adjacent");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private Map<QName, RuntimeValue> inScopeOptions = null;
    private QName wrapper = null;
    private NodeName wrapperCode = null;
    private RuntimeValue groupAdjacent = null;
    private Stack<Boolean> inGroup = new Stack();

    public Wrap(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue runtimeValue = this.getOption(_wrapper);
        String string = runtimeValue.getString();
        String string2 = this.getOption(_wrapper_prefix, (String)null);
        String string3 = this.getOption(_wrapper_namespace, (String)null);
        if (string2 != null && string3 == null) {
            throw XProcException.dynamicError(34, this.step.getNode(), "You can't specify a prefix without a namespace");
        }
        if (string3 != null && string.contains(":")) {
            throw XProcException.dynamicError(34, this.step.getNode(), "You can't specify a namespace if the wrapper name contains a colon");
        }
        this.wrapper = string.contains(":") ? new QName(string, runtimeValue.getNode()) : new QName(string2 == null ? "" : string2, string3, string);
        this.groupAdjacent = this.getOption(_group_adjacent);
        this.inGroup.push(false);
        XdmNode xdmNode = this.source.read();
        this.wrapperCode = new FingerprintedQName(this.wrapper.getPrefix(), this.wrapper.getNamespaceURI(), this.wrapper.getLocalName());
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(xdmNode, this.getOption(_match));
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6);
        }
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.startDocument(xdmNode.getBaseURI());
        this.matcher.addStartElement(this.wrapperCode, (SchemaType)Untyped.getInstance(), null);
        this.matcher.startContent();
        this.matcher.addSubtree(xdmNode);
        this.matcher.addEndElement();
        this.matcher.endDocument();
        return false;
    }

    @Override
    public void processEndDocument(XdmNode xdmNode) throws SaxonApiException {
    }

    @Override
    public boolean processStartElement(XdmNode xdmNode) throws SaxonApiException {
        if (!this.inGroup.peek().booleanValue()) {
            this.matcher.addStartElement(this.wrapperCode, (SchemaType)Untyped.getInstance(), null);
        }
        if (this.groupAdjacent != null && this.nextMatches(xdmNode)) {
            this.inGroup.pop();
            this.inGroup.push(true);
        } else {
            this.inGroup.pop();
            this.inGroup.push(false);
        }
        this.matcher.addStartElement(xdmNode);
        this.matcher.addAttributes(xdmNode);
        this.inGroup.push(false);
        return true;
    }

    @Override
    public void processAttribute(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processEndElement(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addEndElement();
        this.inGroup.pop();
        if (!this.inGroup.peek().booleanValue()) {
            this.matcher.addEndElement();
        }
    }

    @Override
    public void processText(XdmNode xdmNode) throws SaxonApiException {
        if (!this.inGroup.peek().booleanValue()) {
            this.matcher.addStartElement(this.wrapperCode, (SchemaType)Untyped.getInstance(), null);
        }
        this.matcher.addText(xdmNode.getStringValue());
        if (this.groupAdjacent != null && this.nextMatches(xdmNode)) {
            this.inGroup.pop();
            this.inGroup.push(true);
        } else {
            this.matcher.addEndElement();
            this.inGroup.pop();
            this.inGroup.push(false);
        }
    }

    @Override
    public void processComment(XdmNode xdmNode) throws SaxonApiException {
        if (!this.inGroup.peek().booleanValue()) {
            this.matcher.addStartElement(this.wrapperCode, (SchemaType)Untyped.getInstance(), null);
        }
        this.matcher.addComment(xdmNode.getStringValue());
        if (this.groupAdjacent != null && this.nextMatches(xdmNode)) {
            this.inGroup.pop();
            this.inGroup.push(true);
        } else {
            this.matcher.addEndElement();
            this.inGroup.pop();
            this.inGroup.push(false);
        }
    }

    @Override
    public void processPI(XdmNode xdmNode) throws SaxonApiException {
        if (!this.inGroup.peek().booleanValue()) {
            this.matcher.addStartElement(this.wrapperCode, (SchemaType)Untyped.getInstance(), null);
        }
        this.matcher.addPI(xdmNode.getNodeName().getLocalName(), xdmNode.getStringValue());
        if (this.groupAdjacent != null && this.nextMatches(xdmNode)) {
            this.inGroup.pop();
            this.inGroup.push(true);
        } else {
            this.matcher.addEndElement();
            this.inGroup.pop();
            this.inGroup.push(false);
        }
    }

    private boolean nextMatches(XdmNode xdmNode) {
        XdmItem xdmItem = this.computeGroup(xdmNode);
        if (xdmItem == null) {
            return false;
        }
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.FOLLOWING_SIBLING);
        while (xdmSequenceIterator.hasNext()) {
            boolean bl;
            XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            boolean bl2 = bl = xdmNode2.getNodeKind() == XdmNodeKind.COMMENT || xdmNode2.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION;
            if (xdmNode2.getNodeKind() == XdmNodeKind.TEXT && "".equals(xdmNode2.toString().trim())) {
                bl = true;
            }
            if (this.matcher.matches(xdmNode2)) {
                XdmItem xdmItem2 = this.computeGroup(xdmNode2);
                boolean bl3 = S9apiUtils.xpathEqual(this.runtime.getProcessor(), xdmItem, xdmItem2);
                return bl3;
            }
            if (bl) continue;
            return false;
        }
        return false;
    }

    private XdmItem computeGroup(XdmNode xdmNode) {
        try {
            String string2;
            XPathCompiler xPathCompiler = this.runtime.getProcessor().newXPathCompiler();
            xPathCompiler.setBaseURI(this.step.getNode().getBaseURI());
            for (String string2 : this.groupAdjacent.getNamespaceBindings().keySet()) {
                xPathCompiler.declareNamespace(string2, this.groupAdjacent.getNamespaceBindings().get(string2));
            }
            XPathExecutable xPathExecutable = xPathCompiler.compile(this.groupAdjacent.getString());
            string2 = xPathExecutable.load();
            string2.setContextItem((XdmItem)xdmNode);
            Iterator iterator = string2.iterator();
            if (iterator.hasNext()) {
                return (XdmItem)iterator.next();
            }
            return null;
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
    }
}

