/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.core;

import com.xmlcalabash.config.XProcConfigurer;
import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.functions.BaseURI;
import com.xmlcalabash.functions.Cwd;
import com.xmlcalabash.functions.IterationPosition;
import com.xmlcalabash.functions.IterationSize;
import com.xmlcalabash.functions.ResolveURI;
import com.xmlcalabash.functions.StepAvailable;
import com.xmlcalabash.functions.SystemProperty;
import com.xmlcalabash.functions.ValueAvailable;
import com.xmlcalabash.functions.VersionAvailable;
import com.xmlcalabash.functions.XPathVersionAvailable;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Parser;
import com.xmlcalabash.model.PipelineLibrary;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XLibrary;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.runtime.XRootStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.DefaultXProcConfigurer;
import com.xmlcalabash.util.DefaultXProcMessageListener;
import com.xmlcalabash.util.StepErrorListener;
import com.xmlcalabash.util.URIUtils;
import com.xmlcalabash.util.XProcURIResolver;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.apache.commons.httpclient.Cookie;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XProcRuntime {
    protected Logger logger = Logger.getLogger("com.xmlcalabash");
    private Processor processor = null;
    private Parser parser = null;
    private XProcURIResolver uriResolver = null;
    private XProcConfiguration config = null;
    private Vector<XStep> reported = new Vector();
    private QName errorCode = null;
    private XdmNode errorNode = null;
    private String errorMessage = null;
    private Hashtable<QName, DeclareStep> declaredSteps = new Hashtable();
    private DeclareStep pipeline = null;
    private XPipeline xpipeline = null;
    private Vector<Throwable> errors = null;
    private static String episode = null;
    private Hashtable<String, Vector<XdmNode>> collections = null;
    private URI staticBaseURI = null;
    private boolean allowGeneralExpressions = true;
    private boolean allowXPointerOnText = true;
    private boolean transparentJSON = false;
    private String jsonFlavor = "marklogic";
    private XProcData xprocData = null;
    private Logger log = null;
    private XProcMessageListener msgListener = null;
    private PipelineLibrary standardLibrary = null;
    private XLibrary xStandardLibrary = null;
    private Hashtable<String, Vector<Cookie>> cookieHash = new Hashtable();
    private XProcConfigurer configurer = null;
    private String htmlParser = null;

    public XProcRuntime(XProcConfiguration xProcConfiguration) {
        Object object;
        String string;
        this.config = xProcConfiguration;
        this.processor = xProcConfiguration.getProcessor();
        if (xProcConfiguration.xprocConfigurer != null) {
            try {
                string = xProcConfiguration.xprocConfigurer;
                object = Class.forName(string).getConstructor(XProcRuntime.class);
                this.configurer = (XProcConfigurer)((Constructor)object).newInstance(this);
            }
            catch (Exception exception) {
                throw new XProcException(exception);
            }
        } else {
            this.configurer = new DefaultXProcConfigurer(this);
        }
        this.xprocData = new XProcData(this);
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new Cwd(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new BaseURI(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new ResolveURI(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new SystemProperty(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new StepAvailable(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new IterationSize(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new IterationPosition(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new ValueAvailable(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new VersionAvailable(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new XPathVersionAvailable(this));
        this.log = Logger.getLogger(this.getClass().getName());
        string = this.processor.getUnderlyingConfiguration();
        this.uriResolver = new XProcURIResolver(this);
        string.setURIResolver((URIResolver)this.uriResolver);
        this.staticBaseURI = URIUtils.cwdAsURI();
        try {
            if (xProcConfiguration.uriResolver != null) {
                this.uriResolver.setUnderlyingURIResolver((URIResolver)Class.forName(xProcConfiguration.uriResolver).newInstance());
            }
            if (xProcConfiguration.entityResolver != null) {
                this.uriResolver.setUnderlyingEntityResolver((EntityResolver)Class.forName(xProcConfiguration.entityResolver).newInstance());
            }
            this.msgListener = xProcConfiguration.errorListener != null ? (XProcMessageListener)Class.forName(xProcConfiguration.errorListener).newInstance() : new DefaultXProcMessageListener();
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
        this.processor.getUnderlyingConfiguration().setURIResolver((URIResolver)this.uriResolver);
        object = new StepErrorListener(this);
        string.setErrorListener((ErrorListener)object);
        this.allowGeneralExpressions = xProcConfiguration.extensionValues;
        this.allowXPointerOnText = xProcConfiguration.xpointerOnText;
        this.transparentJSON = xProcConfiguration.transparentJSON;
        this.jsonFlavor = xProcConfiguration.jsonFlavor;
        for (String string2 : xProcConfiguration.extensionFunctions) {
            try {
                ExtensionFunctionDefinition extensionFunctionDefinition = (ExtensionFunctionDefinition)Class.forName(string2).newInstance();
                this.finer(null, null, "Instantiated: " + string2);
                this.processor.registerExtensionFunction(extensionFunctionDefinition);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.finer(null, null, "Failed to instantiate extension function: " + string2);
            }
            catch (Exception exception) {
                this.finer(null, null, "Failed to instantiate extension function: " + string2);
            }
        }
        this.htmlParser = xProcConfiguration.htmlParser;
        this.reset();
    }

    public XProcRuntime(XProcRuntime xProcRuntime) {
        this.processor = xProcRuntime.processor;
        this.parser = xProcRuntime.parser;
        this.uriResolver = xProcRuntime.uriResolver;
        this.config = xProcRuntime.config;
        this.staticBaseURI = xProcRuntime.staticBaseURI;
        this.allowGeneralExpressions = xProcRuntime.allowGeneralExpressions;
        this.log = xProcRuntime.log;
        this.msgListener = xProcRuntime.msgListener;
        this.standardLibrary = xProcRuntime.standardLibrary;
        this.xStandardLibrary = xProcRuntime.xStandardLibrary;
        this.cookieHash = xProcRuntime.cookieHash;
        this.configurer = xProcRuntime.configurer;
        this.allowGeneralExpressions = xProcRuntime.allowGeneralExpressions;
        this.allowXPointerOnText = xProcRuntime.allowXPointerOnText;
        this.transparentJSON = xProcRuntime.transparentJSON;
        this.jsonFlavor = xProcRuntime.jsonFlavor;
    }

    public XProcConfigurer getConfigurer() {
        return this.configurer;
    }

    public void setConfigurer(XProcConfigurer xProcConfigurer) {
        this.configurer = xProcConfigurer;
    }

    public XProcData getXProcData() {
        return this.xprocData;
    }

    public boolean getDebug() {
        return this.config.debug;
    }

    public URI getStaticBaseURI() {
        return this.staticBaseURI;
    }

    public String getSendmailHost() {
        return this.config.mailHost;
    }

    public String getSendmailPort() {
        return this.config.mailPort;
    }

    public String getSendmailUsername() {
        return this.config.mailUser;
    }

    public String getSendmailPassword() {
        return this.config.mailPass;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver.setUnderlyingURIResolver(uRIResolver);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.uriResolver.setUnderlyingEntityResolver(entityResolver);
    }

    public XProcURIResolver getResolver() {
        return this.uriResolver;
    }

    public XProcMessageListener getMessageListener() {
        return this.msgListener;
    }

    public void setMessageListener(XProcMessageListener xProcMessageListener) {
        this.msgListener = xProcMessageListener;
    }

    public void setCollection(URI uRI, Vector<XdmNode> vector) {
        if (this.collections == null) {
            this.collections = new Hashtable();
        }
        this.collections.put(uRI.toASCIIString(), vector);
    }

    public Vector<XdmNode> getCollection(URI uRI) {
        if (this.collections == null) {
            return null;
        }
        if (this.collections.containsKey(uRI.toASCIIString())) {
            return this.collections.get(uRI.toASCIIString());
        }
        return null;
    }

    public boolean getSafeMode() {
        return this.config.safeMode;
    }

    public boolean getAllowGeneralExpressions() {
        return this.allowGeneralExpressions;
    }

    public boolean getAllowXPointerOnText() {
        return this.allowXPointerOnText;
    }

    public boolean transparentJSON() {
        return this.transparentJSON;
    }

    public String jsonFlavor() {
        return this.jsonFlavor;
    }

    public String htmlParser() {
        return this.htmlParser;
    }

    public void cache(XdmNode xdmNode, URI uRI) {
        this.uriResolver.cache(xdmNode, uRI);
    }

    public XProcConfiguration getConfiguration() {
        return this.config;
    }

    public Parser getParser() {
        return this.parser;
    }

    public String getEpisode() {
        if (episode == null) {
            MessageDigest messageDigest = null;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw XProcException.dynamicError(36);
            }
            byte[] byArray = messageDigest.digest(gregorianCalendar.toString().getBytes());
            episode = "CB";
            for (byte by : byArray) {
                episode = episode + Integer.toHexString(by & 0xFF);
            }
        }
        return episode;
    }

    public String getLanguage() {
        return Locale.getDefault().toString().replace('_', '-');
    }

    public String getProductName() {
        return "XML Calabash";
    }

    public String getProductVersion() {
        return XProcConstants.XPROC_VERSION;
    }

    public String getVendor() {
        return "Norman Walsh";
    }

    public String getVendorURI() {
        return "http://xmlcalabash.com/";
    }

    public String getXProcVersion() {
        return "1.0";
    }

    public String getXPathVersion() {
        return "2.0";
    }

    public boolean getPSVISupported() {
        return this.config.schemaAware;
    }

    public XLibrary getStandardLibrary() {
        if (this.xStandardLibrary == null) {
            this.xStandardLibrary = new XLibrary(this, this.standardLibrary);
            if (this.errorCode != null) {
                throw new XProcException(this.errorCode, this.errorMessage);
            }
        }
        return this.xStandardLibrary;
    }

    private void reset() {
        this.reported = new Vector();
        this.errorCode = null;
        this.errorMessage = null;
        this.declaredSteps = new Hashtable();
        this.pipeline = null;
        this.xpipeline = null;
        this.errors = null;
        episode = null;
        this.collections = null;
        this.cookieHash = new Hashtable();
        this.xprocData = new XProcData(this);
        this.parser = new Parser(this);
        try {
            this.standardLibrary = this.parser.loadStandardLibrary();
            if (this.errorCode != null) {
                throw new XProcException(this.errorCode, this.errorMessage);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new XProcException(XProcConstants.dynamicError(9), (Throwable)fileNotFoundException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XProcException(XProcConstants.dynamicError(9), (Throwable)uRISyntaxException);
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(XProcConstants.dynamicError(9), (Throwable)saxonApiException);
        }
    }

    public XPipeline load(String string) throws SaxonApiException {
        try {
            return this._load(string);
        }
        catch (SaxonApiException saxonApiException) {
            this.error(saxonApiException);
            throw saxonApiException;
        }
        catch (XProcException xProcException) {
            this.error(xProcException);
            throw xProcException;
        }
    }

    private XPipeline _load(String string) throws SaxonApiException {
        this.reset();
        this.configurer.getXMLCalabashConfigurer().configRuntime(this);
        this.pipeline = this.parser.loadPipeline(string);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        XRootStep xRootStep = new XRootStep(this);
        DeclareStep declareStep = this.pipeline.getDeclaration();
        declareStep.setup();
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorNode, this.errorMessage);
        }
        this.xpipeline = new XPipeline(this, this.pipeline, xRootStep);
        this.xpipeline.instantiate(declareStep);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        return this.xpipeline;
    }

    public XPipeline use(XdmNode xdmNode) throws SaxonApiException {
        try {
            return this._use(xdmNode);
        }
        catch (SaxonApiException saxonApiException) {
            this.error(saxonApiException);
            throw saxonApiException;
        }
        catch (XProcException xProcException) {
            this.error(xProcException);
            throw xProcException;
        }
    }

    private XPipeline _use(XdmNode xdmNode) throws SaxonApiException {
        this.reset();
        this.configurer.getXMLCalabashConfigurer().configRuntime(this);
        this.pipeline = this.parser.usePipeline(xdmNode);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        XRootStep xRootStep = new XRootStep(this);
        DeclareStep declareStep = this.pipeline.getDeclaration();
        declareStep.setup();
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        this.xpipeline = new XPipeline(this, this.pipeline, xRootStep);
        this.xpipeline.instantiate(declareStep);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        return this.xpipeline;
    }

    public XLibrary loadLibrary(String string) throws SaxonApiException {
        try {
            return this._loadLibrary(string);
        }
        catch (SaxonApiException saxonApiException) {
            this.error(saxonApiException);
            throw saxonApiException;
        }
        catch (XProcException xProcException) {
            this.error(xProcException);
            throw xProcException;
        }
    }

    private XLibrary _loadLibrary(String string) throws SaxonApiException {
        PipelineLibrary pipelineLibrary = this.parser.loadLibrary(string);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        XLibrary xLibrary = new XLibrary(this, pipelineLibrary);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        return xLibrary;
    }

    public XLibrary useLibrary(XdmNode xdmNode) throws SaxonApiException {
        try {
            return this._useLibrary(xdmNode);
        }
        catch (SaxonApiException saxonApiException) {
            this.error(saxonApiException);
            throw saxonApiException;
        }
        catch (XProcException xProcException) {
            this.error(xProcException);
            throw xProcException;
        }
    }

    private XLibrary _useLibrary(XdmNode xdmNode) throws SaxonApiException {
        PipelineLibrary pipelineLibrary = this.parser.useLibrary(xdmNode);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        XLibrary xLibrary = new XLibrary(this, pipelineLibrary);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        return xLibrary;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public XdmNode parse(String string, String string2) {
        return this.parse(string, string2, false);
    }

    public XdmNode parse(String string, String string2, boolean bl) {
        return this.uriResolver.parse(string, string2, bl);
    }

    public XdmNode parse(InputSource inputSource) {
        return this.uriResolver.parse(inputSource);
    }

    public void declareStep(QName qName, DeclareStep declareStep) {
        if (this.declaredSteps.containsKey(qName)) {
            throw new XProcException((Step)declareStep, "Duplicate declaration for " + qName);
        }
        this.declaredSteps.put(qName, declareStep);
    }

    public DeclareStep getBuiltinDeclaration(QName qName) {
        if (this.declaredSteps.containsKey(qName)) {
            return this.declaredSteps.get(qName);
        }
        throw XProcException.staticError(44, null, "Unexpected step name: " + qName);
    }

    public void clearCookies(String string) {
        if (this.cookieHash.containsKey(string)) {
            this.cookieHash.get(string).clear();
        }
    }

    public void addCookie(String string, Cookie cookie) {
        if (!this.cookieHash.containsKey(string)) {
            this.cookieHash.put(string, new Vector());
        }
        this.cookieHash.get(string).add(cookie);
    }

    public Vector<Cookie> getCookies(String string) {
        if (this.cookieHash.containsKey(string)) {
            return this.cookieHash.get(string);
        }
        return new Vector<Cookie>();
    }

    public QName getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void error(XProcRunnable xProcRunnable, XdmNode xdmNode, String string, QName qName) {
        if (this.errorCode == null) {
            this.errorCode = qName;
            this.errorNode = xdmNode;
            this.errorMessage = string;
        }
        this.msgListener.error(xProcRunnable, xdmNode, string, qName);
    }

    public void error(Throwable throwable) {
        this.msgListener.error(throwable);
    }

    public void warning(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.msgListener.warning(xProcRunnable, xdmNode, string);
    }

    public void warning(Throwable throwable) {
        this.msgListener.warning(throwable);
    }

    public void info(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.msgListener.info(xProcRunnable, xdmNode, string);
    }

    public void fine(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.msgListener.fine(xProcRunnable, xdmNode, string);
    }

    public void finer(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.msgListener.finer(xProcRunnable, xdmNode, string);
    }

    public void finest(XProcRunnable xProcRunnable, XdmNode xdmNode, String string) {
        this.msgListener.finest(xProcRunnable, xdmNode, string);
    }

    public void reportStep(XStep xStep) {
        this.reported.add(xStep);
    }

    public void start(XPipeline xPipeline) {
    }

    public void finish(XPipeline xPipeline) {
    }
}

