/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class Template
extends DefaultStep
implements ProcessMatchingNodes {
    private ReadablePipe source = null;
    private ReadablePipe template = null;
    private WritablePipe result = null;
    private Hashtable<QName, RuntimeValue> params = new Hashtable();
    private ProcessMatch matcher = null;
    private XdmNode context = null;
    private static final int START = 0;
    private static final int XPATHMODE = 1;
    private static final int SQUOTEMODE = 2;
    private static final int DQUOTEMODE = 3;
    private static final int END = 4;

    public Template(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.source = readablePipe;
        } else if ("template".equals(string)) {
            this.template = readablePipe;
        } else {
            throw new UnsupportedOperationException("WTF?");
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void setParameter(QName qName, RuntimeValue runtimeValue) {
        this.params.put(qName, runtimeValue);
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
        this.template.resetReader();
    }

    @Override
    public void run() throws SaxonApiException {
        if (this.step.getNode().getNodeName().equals((Object)XProcConstants.p_document_template)) {
            this.runtime.finer(this, this.step.getNode(), "The template step should be named p:template, the name p:document-template is deprecated.");
        }
        super.run();
        if (this.source.documentCount() > 1) {
            throw XProcException.stepError(68);
        }
        this.context = this.source.read();
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.template.read(), new RuntimeValue("node()", this.step.getNode()));
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.startDocument(xdmNode.getBaseURI());
        return true;
    }

    @Override
    public void processEndDocument(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.endDocument();
    }

    @Override
    public boolean processStartElement(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addStartElement(xdmNode);
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.ATTRIBUTE);
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            String string = xdmNode2.getStringValue();
            if (string.contains("{") || string.contains("}")) {
                Vector<XdmItem> vector = this.parse(xdmNode2, string);
                String string2 = "";
                for (XdmItem xdmItem : vector) {
                    string2 = string2 + xdmItem.getStringValue();
                }
                this.matcher.addAttribute(xdmNode2, string2);
                continue;
            }
            this.matcher.addAttribute(xdmNode2);
        }
        return true;
    }

    @Override
    public void processEndElement(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode xdmNode) throws SaxonApiException {
        String string = xdmNode.getStringValue();
        if (string.contains("{") || string.contains("}")) {
            Vector<XdmItem> vector = this.parse(xdmNode, string);
            block6: for (XdmItem xdmItem : vector) {
                if (xdmItem.isAtomicValue()) {
                    this.matcher.addText(xdmItem.getStringValue());
                    continue;
                }
                XdmNode xdmNode2 = (XdmNode)xdmItem;
                switch (xdmNode2.getNodeKind()) {
                    case ELEMENT: {
                        this.matcher.addSubtree(xdmNode2);
                        continue block6;
                    }
                    case ATTRIBUTE: {
                        this.matcher.addAttribute(xdmNode2);
                        continue block6;
                    }
                    case PROCESSING_INSTRUCTION: {
                        this.matcher.addSubtree(xdmNode2);
                        continue block6;
                    }
                    case COMMENT: {
                        this.matcher.addComment(xdmNode2.getStringValue());
                        continue block6;
                    }
                }
                this.matcher.addText(xdmNode2.getStringValue());
            }
        } else {
            this.matcher.addText(string);
        }
    }

    private Vector<XdmItem> parse(XdmNode xdmNode, String string) {
        String string2;
        XdmNode xdmNode2;
        Vector<XdmItem> vector = new Vector<XdmItem>();
        int n = 0;
        String string3 = "";
        String string4 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (xdmNode2 = xdmNode; xdmNode2 != null && xdmNode2.getNodeKind() != XdmNodeKind.ELEMENT && xdmNode2.getNodeKind() != XdmNodeKind.DOCUMENT; xdmNode2 = xdmNode2.getParent()) {
        }
        if (xdmNode2.getNodeKind() == XdmNodeKind.ELEMENT) {
            string2 = xdmNode2.getUnderlyingNode();
            InscopeNamespaceResolver inscopeNamespaceResolver = new InscopeNamespaceResolver((NodeInfo)string2);
            Iterator iterator = inscopeNamespaceResolver.iteratePrefixes();
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                String string6 = inscopeNamespaceResolver.getURIForPrefix(string5, true);
                hashtable.put(string5, string6);
            }
        }
        string2 = "";
        block8: for (int i = 0; i < string.length(); ++i) {
            string4 = string.substring(i, i + 1);
            switch (n) {
                case 0: {
                    string2 = i + 1 < string.length() ? string.substring(i + 1, i + 2) : "";
                    if ("{".equals(string4)) {
                        if ("{".equals(string2)) {
                            string3 = string3 + "{";
                            ++i;
                            continue block8;
                        }
                        if (!"".equals(string3)) {
                            vector.add((XdmItem)new XdmAtomicValue(string3));
                            string3 = "";
                        }
                        n = 1;
                        continue block8;
                    }
                    if ("}".equals(string4)) {
                        if ("}".equals(string2)) {
                            string3 = string3 + "}";
                            ++i;
                            continue block8;
                        }
                        throw XProcException.stepError(67);
                    }
                    string3 = string3 + string4;
                    continue block8;
                }
                case 1: {
                    if ("{".equals(string4)) {
                        throw XProcException.stepError(67);
                    }
                    if ("'".equals(string4)) {
                        string3 = string3 + "'";
                        n = 2;
                        continue block8;
                    }
                    if ("\"".equals(string4)) {
                        string3 = string3 + "\"";
                        n = 3;
                        continue block8;
                    }
                    if ("}".equals(string4)) {
                        vector.addAll(this.evaluateXPath(this.context, hashtable, string3, this.params));
                        string3 = "";
                        n = 0;
                        continue block8;
                    }
                    string3 = string3 + string4;
                    continue block8;
                }
                case 2: {
                    if ("'".equals(string4)) {
                        string3 = string3 + "'";
                        n = 1;
                        continue block8;
                    }
                    string3 = string3 + string4;
                    continue block8;
                }
                case 3: {
                    if ("\"".equals(string4)) {
                        string3 = string3 + "\"";
                        n = 1;
                        continue block8;
                    }
                    string3 = string3 + string4;
                }
            }
        }
        if (n != 0) {
            throw XProcException.stepError(67);
        }
        if (!"".equals(string3)) {
            vector.add((XdmItem)new XdmAtomicValue(string3));
        }
        return vector;
    }

    @Override
    public void processComment(XdmNode xdmNode) throws SaxonApiException {
        String string = xdmNode.getStringValue();
        if (string.contains("{") || string.contains("}")) {
            Vector<XdmItem> vector = this.parse(xdmNode, string);
            String string2 = "";
            for (XdmItem xdmItem : vector) {
                string2 = string2 + xdmItem.getStringValue();
            }
            this.matcher.addComment(string2);
        } else {
            this.matcher.addComment(string);
        }
    }

    @Override
    public void processPI(XdmNode xdmNode) throws SaxonApiException {
        String string = xdmNode.getStringValue();
        if (string.contains("{") || string.contains("}")) {
            Vector<XdmItem> vector = this.parse(xdmNode, string);
            String string2 = "";
            for (XdmItem xdmItem : vector) {
                string2 = string2 + xdmItem.getStringValue();
            }
            this.matcher.addPI(xdmNode.getNodeName().getLocalName(), string2);
        } else {
            this.matcher.addPI(xdmNode.getNodeName().getLocalName(), string);
        }
    }

    @Override
    public void processAttribute(XdmNode xdmNode) throws SaxonApiException {
        throw new UnsupportedOperationException("This can't happen.");
    }
}

