/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.EmptyBinding;
import com.xmlcalabash.model.EndPoint;
import com.xmlcalabash.model.Environment;
import com.xmlcalabash.model.ErrorBinding;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Log;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Parameter;
import com.xmlcalabash.model.PipeBinding;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.Port;
import com.xmlcalabash.model.SourceArtifact;
import com.xmlcalabash.model.Variable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class Step
extends SourceArtifact {
    private static final QName cx_depend = new QName("cx", "http://xmlcalabash.com/ns/extensions", "depend");
    private static final QName cx_depends = new QName("cx", "http://xmlcalabash.com/ns/extensions", "depends");
    private static final QName cx_dependson = new QName("cx", "http://xmlcalabash.com/ns/extensions", "dependson");
    protected QName stepType = null;
    protected String stepName = null;
    private boolean anonymous = false;
    protected Vector<Input> inputs = new Vector();
    protected Vector<Output> outputs = new Vector();
    private Vector<Option> options = new Vector();
    private Vector<Log> logs = new Vector();
    private Vector<Parameter> params = new Vector();
    private HashSet<String> dependsOn = new HashSet();
    protected Environment env = null;
    protected Step parent = null;
    private int depth = -1;
    private boolean ordered = false;
    private static HashSet<String> anonNames = new HashSet();
    Vector<Step> subpipeline = new Vector();
    protected DeclareStep declaration = null;
    protected Double version = null;

    public Step(XProcRuntime xProcRuntime, XdmNode xdmNode, QName qName) {
        super(xProcRuntime, xdmNode);
        this.stepType = qName;
        this.stepName = this.anonymousName(xdmNode);
    }

    public Step(XProcRuntime xProcRuntime, XdmNode xdmNode, QName qName, String string) {
        super(xProcRuntime, xdmNode);
        this.stepType = qName;
        this.stepName = string;
        if (this.stepName == null) {
            this.stepName = this.anonymousName(xdmNode);
        }
    }

    public boolean isPipeline() {
        return false;
    }

    private synchronized String anonymousName(XdmNode xdmNode) {
        String string = this.recursiveAnonymousName(xdmNode);
        anonNames.add(string);
        return string;
    }

    private String recursiveAnonymousName(XdmNode xdmNode) {
        if (xdmNode.getParent().getNodeKind() == XdmNodeKind.DOCUMENT) {
            return "!1";
        }
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.PRECEDING_SIBLING);
        int n = 1;
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            if (xdmNode2.getNodeKind() != XdmNodeKind.ELEMENT) continue;
            ++n;
        }
        return this.anonymousName(xdmNode.getParent()) + "." + n;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setDeclaration(DeclareStep declareStep) {
        this.declaration = declareStep;
    }

    public DeclareStep getDeclaration() {
        return this.declaration;
    }

    public boolean isPipelineCall() {
        return !this.declaration.isAtomic();
    }

    public QName getType() {
        return this.stepType;
    }

    public Step getStep() {
        return this;
    }

    protected void setVersion(Double d) {
        this.version = d;
    }

    public Double getVersion() {
        if (this.version == null) {
            if (this.parent != null) {
                return this.parent.getVersion();
            }
            throw new UnsupportedOperationException("Step with no version or inherited version!?");
        }
        return this.version;
    }

    public QName getDeclaredType() {
        return this.stepType;
    }

    public String getName() {
        return this.stepName;
    }

    @Override
    public XdmNode getNode() {
        return this.node;
    }

    public Step getPipeline() {
        Step step = this;
        while (step != null && step.stepType != XProcConstants.p_declare_step) {
            step = step.parent;
        }
        return step;
    }

    public boolean containsStep(String string) {
        return false;
    }

    public void addStep(Step step) {
        step.parent = this;
        this.subpipeline.add(step);
    }

    public void setSubpipeline(Vector<Step> vector) {
        this.subpipeline = vector;
    }

    public Vector<Step> subpipeline() {
        return this.subpipeline;
    }

    public void addVariable(Variable variable) {
        throw new UnsupportedOperationException("You can only call addVariable() on a compound step");
    }

    public Collection<Variable> getVariables() {
        return new Vector<Variable>();
    }

    public void addInput(Input input) {
        input.setStep(this);
        for (Input input2 : this.inputs) {
            if (!input2.getPort().equals(input.getPort())) continue;
            throw XProcException.staticError(11, input.getNode(), "Input port name '" + input.getPort() + "' appears more than once.");
        }
        this.inputs.add(input);
    }

    public Vector<Input> inputs() {
        return this.inputs;
    }

    public Input getInput(String string) {
        for (Input input : this.inputs) {
            if (!string.equals(input.getPort())) continue;
            return input;
        }
        return null;
    }

    public void addOutput(Output output) {
        output.setStep(this);
        for (Output output2 : this.outputs) {
            if (!output2.getPort().equals(output.getPort())) continue;
            throw XProcException.staticError(11, output.getNode(), "Output port name '" + output.getPort() + "' appears more than once.");
        }
        this.outputs.add(output);
    }

    public Vector<Output> outputs() {
        return this.outputs;
    }

    public Output getPrimaryOutput() {
        int n = 0;
        Output output = null;
        for (Output output2 : this.outputs) {
            if ("#current".equals(output2.getPort())) continue;
            if (output2.getPrimary() || !output2.getPrimarySet()) {
                output = output2;
            }
            ++n;
            if (!output2.getPrimary()) continue;
            return output2;
        }
        if (n == 1) {
            return output;
        }
        return null;
    }

    public Output getOutput(String string) {
        for (Output output : this.outputs) {
            if (!string.equals(output.getPort())) continue;
            return output;
        }
        return null;
    }

    public void addOption(Option option) {
        QName qName = option.getName();
        for (Option option2 : this.options) {
            if (!qName.equals((Object)option2.getName())) continue;
            this.error(option.getNode(), "Duplication option name: " + qName, XProcConstants.staticError(4));
        }
        this.options.add(option);
    }

    public Vector<Option> options() {
        return this.options;
    }

    public Option getOption(QName qName) {
        for (Option option : this.options) {
            if (!qName.equals((Object)option.getName())) continue;
            return option;
        }
        return null;
    }

    public List<QName> getOptions() {
        Vector<QName> vector = new Vector<QName>();
        for (Option option : this.options) {
            vector.add(option.getName());
        }
        return vector;
    }

    public void addLog(Log log) {
        this.logs.add(log);
    }

    public Log getLog(String string) {
        for (Log log : this.logs) {
            if (!string.equals(log.getPort())) continue;
            return log;
        }
        return null;
    }

    public void addParameter(Parameter parameter) {
        this.params.add(parameter);
    }

    public Parameter getParameter(QName qName) {
        for (Parameter parameter : this.params) {
            if (!qName.equals((Object)parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    public List<QName> getParameters() {
        Vector<QName> vector = new Vector<QName>();
        for (Parameter parameter : this.params) {
            vector.add(parameter.getName());
        }
        return vector;
    }

    public Vector<Parameter> parameters() {
        return this.params;
    }

    public boolean loops() {
        return false;
    }

    public boolean insideALoop() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.loops() || this.parent.insideALoop();
    }

    public Output getDefaultOutput() {
        int n = 0;
        Port port = null;
        for (Output output : this.outputs) {
            if (output.getPort().startsWith("#")) continue;
            if (output.getPrimary()) {
                return output;
            }
            if (output.getPort().endsWith("|")) continue;
            ++n;
            port = output;
        }
        if (n == 1 && (port.getPrimary() || !port.getPrimarySet())) {
            return port;
        }
        return null;
    }

    protected void addDependency(String string) {
        this.dependsOn.add(string);
    }

    protected HashSet<String> getDependencies() {
        return this.dependsOn;
    }

    protected boolean dependsOn(String string) {
        return this.dependsOn.contains(string);
    }

    protected boolean matchesDeclaration() {
        boolean bl = true;
        DeclareStep declareStep = this.declaration;
        if (declareStep == null) {
            return true;
        }
        Hashtable<String, Input> hashtable = new Hashtable<String, Input>();
        for (Input object : declareStep.inputs()) {
            hashtable.put(object.getPort(), object);
        }
        for (Input input : this.inputs()) {
            String string = input.getPort();
            if (string.startsWith("|")) continue;
            if (!hashtable.containsKey(string)) {
                if (this.getVersion() != 1.0) continue;
                this.error("Undeclared input port '" + string + "' on " + this, XProcConstants.staticError(10));
                bl = false;
                continue;
            }
            input.setPrimary(((Input)hashtable.get(string)).getPrimary());
        }
        Hashtable hashtable2 = new Hashtable();
        for (Output output : declareStep.outputs()) {
            hashtable2.put(output.getPort(), output);
        }
        for (Output output : this.outputs()) {
            String string = output.getPort();
            if (string.endsWith("|")) continue;
            if (!hashtable2.containsKey(string) && !hashtable2.containsKey("*")) {
                this.error("Undeclared output port: " + string, XProcConstants.staticError(10));
                bl = false;
                continue;
            }
            output.setPrimary(((Output)hashtable2.get(string)).getPrimary());
        }
        return bl;
    }

    protected boolean validOptions() {
        HashSet<QName> hashSet = new HashSet<QName>();
        boolean bl = true;
        for (Option vector : this.options) {
            bl = bl && vector.valid(this.env);
            QName qName = vector.getName();
            if (qName == null) {
                bl = false;
                this.error("Option without name", XProcConstants.staticError(38));
                continue;
            }
            if (hashSet.contains(qName)) {
                bl = false;
                this.error("Duplicate option name: " + qName, XProcConstants.staticError(4));
                continue;
            }
            hashSet.add(qName);
        }
        DeclareStep declareStep = this.declaration;
        if (declareStep != null) {
            for (Option option : declareStep.options()) {
                if (!option.getRequired() || this.getOption(option.getName()) != null) continue;
                bl = false;
                this.error("Required option not specified: " + option.getName(), XProcConstants.staticError(18));
            }
            Vector<Option> vector = new Vector<Option>();
            for (Option option : this.options()) {
                Option option2 = declareStep.getOption(option.getName());
                if (option2 == null) {
                    if (this.getVersion() > 1.0) continue;
                    bl = false;
                    this.error("Undeclared option specified: " + option.getName(), XProcConstants.staticError(10));
                    continue;
                }
                vector.add(option);
            }
            this.options = vector;
        }
        return bl;
    }

    protected boolean validParams() {
        HashSet<QName> hashSet = new HashSet<QName>();
        boolean bl = true;
        for (Parameter parameter : this.params) {
            bl = bl && parameter.valid(this.env);
            QName qName = parameter.getName();
            if (qName == null) {
                bl = false;
                this.error("Parameter without name", XProcConstants.staticError(38));
            } else if (hashSet.contains(qName)) {
                bl = false;
                this.error("Duplicate parameter name: " + qName, XProcConstants.staticError(4));
            } else {
                hashSet.add(qName);
            }
            String string = parameter.getPort();
            if (string == null) {
                for (Input input : this.inputs()) {
                    if (!input.getParameterInput() || !input.getPrimary()) continue;
                    string = input.getPort();
                }
                if (string == null) {
                    for (Input input : this.inputs()) {
                        if (!input.getParameterInput()) continue;
                        if (string != null) {
                            this.error("Port not specified and multiple parameter input ports", XProcException.err_E0001);
                        }
                        string = input.getPort();
                    }
                }
            }
            if (string == null) {
                bl = false;
                this.error("Port not specified and no primary parameter input port", XProcException.err_E0001);
                continue;
            }
            Input input = this.getInput(string);
            if (input != null && input.getParameterInput()) continue;
            bl = false;
            this.error("Port is not a parameter input port: " + string, XProcException.err_E0001);
        }
        return bl;
    }

    protected boolean validBindings() {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        for (Input endPoint : this.inputs()) {
            if (!endPoint.getPort().startsWith("|") && endPoint.getPrimary()) {
                if (endPoint.getParameterInput()) {
                    if (bl3) {
                        this.error("At most one primary parameter input port is allowed", XProcConstants.staticError(30));
                    }
                    bl3 = true;
                } else {
                    if (bl2) {
                        this.error("At most one primary input port is allowed", XProcConstants.staticError(30));
                    }
                    bl2 = true;
                }
            }
            if (this.checkBinding(endPoint)) continue;
            bl = false;
        }
        for (Option option : this.options()) {
            if (!XProcConstants.p_with_option.equals((Object)option.getNode().getNodeName()) || this.checkOptionBinding(option, true)) continue;
            bl = false;
        }
        for (Parameter parameter : this.parameters()) {
            if (this.checkOptionBinding(parameter, true)) continue;
            bl = false;
        }
        return bl;
    }

    protected void checkDuplicateVars(HashSet<QName> hashSet) {
        for (Variable variable : this.getVariables()) {
            if (hashSet.contains(variable.getName())) {
                throw XProcException.staticError(4, this.getNode(), "Duplicate variable name: " + variable.getName());
            }
            hashSet.add(variable.getName());
        }
    }

    protected boolean checkBinding(Input input) {
        SourceArtifact sourceArtifact;
        Object object2;
        boolean bl = true;
        this.runtime.finest(null, this.node, "Check bindings for " + input.getPort() + " on " + this.getName());
        if (input.getBinding().size() == 0) {
            SourceArtifact sourceArtifact3;
            if (input.getParameterInput()) {
                if (input.getPrimary()) {
                    sourceArtifact3 = this.getPipeline();
                    object2 = null;
                    int n = 0;
                    for (Input input2 : ((Step)sourceArtifact3).inputs()) {
                        if (!input2.getParameterInput()) continue;
                        ++n;
                        if (object2 != null && !input2.getPrimary()) continue;
                        object2 = input2;
                    }
                    if (object2 == null || !((Port)object2).getPrimary() && n > 1) {
                        if (this.params.size() > 0) {
                            EmptyBinding emptyBinding = new EmptyBinding(this.runtime, this.node);
                            input.addBinding(emptyBinding);
                        } else {
                            bl = false;
                            this.error("Parameter input " + input.getPort() + " unbound on " + this.getType() + " step named " + this.getName() + " and no default binding available.", XProcConstants.staticError(55));
                        }
                    } else {
                        PipeNameBinding pipeNameBinding = new PipeNameBinding(this.runtime, this.node);
                        pipeNameBinding.setStep(((Step)sourceArtifact3).getName());
                        pipeNameBinding.setPort(((Port)object2).getPort());
                        input.addBinding(pipeNameBinding);
                    }
                } else {
                    sourceArtifact3 = new EmptyBinding(this.runtime, this.node);
                    input.addBinding((Binding)sourceArtifact3);
                }
            } else {
                sourceArtifact3 = this.env.getDefaultReadablePort();
                if (input.getPort().startsWith("|")) {
                    if (this.subpipeline.size() > 0) {
                        object2 = this.subpipeline.get(this.subpipeline.size() - 1);
                        sourceArtifact3 = ((Step)object2).getDefaultOutput();
                    } else if (this.isPipelineCall()) {
                        return true;
                    }
                }
                if (sourceArtifact3 == null) {
                    object2 = this.declaration.getInput(input.getPort());
                    if (((EndPoint)object2).getBinding().size() != 0) {
                        input.setSelect(((Input)object2).getSelect());
                        for (Binding binding : ((EndPoint)object2).getBinding()) {
                            input.addBinding(binding);
                        }
                    } else {
                        bl = false;
                        this.error("Input " + input.getPort() + " unbound on " + this.getType() + " step named " + this.getName() + " and no default binding available.", XProcConstants.staticError(32));
                    }
                } else {
                    object2 = ((EndPoint)sourceArtifact3).getStep().getName();
                    String string = ((Port)sourceArtifact3).getPort();
                    PipeNameBinding pipeNameBinding = new PipeNameBinding(this.runtime, this.node);
                    pipeNameBinding.setStep((String)object2);
                    pipeNameBinding.setPort(string);
                    input.addBinding(pipeNameBinding);
                }
            }
        }
        boolean bl2 = false;
        for (Binding binding : input.getBinding()) {
            if (binding.getBindingType() != 1) continue;
            PipeNameBinding pipeNameBinding = (PipeNameBinding)binding;
            Output output = this.env.readablePort(pipeNameBinding.getStep(), pipeNameBinding.getPort());
            if (output == null) {
                sourceArtifact = this.env.visibleStep(pipeNameBinding.getStep());
                if (sourceArtifact == null) {
                    throw XProcException.staticError(22, binding.getNode(), "No step named \"" + pipeNameBinding.getStep() + "\" is visible here.");
                }
                if ("error".equals(pipeNameBinding.getPort()) && XProcConstants.p_catch.equals((Object)((Step)sourceArtifact).getType())) {
                    bl2 = true;
                    continue;
                }
                if ("http://www.w3.org/ns/xproc".equals(((Step)sourceArtifact).getType().getNamespaceURI()) && this.getVersion() > 1.0) {
                    input.setSequence(true);
                    continue;
                }
                this.error(binding.getNode(), "No port named \"" + pipeNameBinding.getPort() + "\" on step named \"" + pipeNameBinding.getStep() + "\"", XProcConstants.staticError(22));
                bl = false;
                continue;
            }
            if (pipeNameBinding.getPort().equals(output.getPort()) || !XProcConstants.p_viewport.equals((Object)((Step)(sourceArtifact = this.env.visibleStep(pipeNameBinding.getStep()))).getType())) continue;
            pipeNameBinding.setPort(output.getPort());
        }
        if (bl2) {
            object2 = new Vector();
            SourceArtifact sourceArtifact4 = null;
            for (Binding binding : input.getBinding()) {
                Output output;
                bl2 = false;
                if (binding.getBindingType() == 1 && (output = this.env.readablePort(((PipeNameBinding)(sourceArtifact = (PipeNameBinding)binding)).getStep(), ((PipeNameBinding)sourceArtifact).getPort())) == null) {
                    sourceArtifact4 = this.env.visibleStep(((PipeNameBinding)sourceArtifact).getStep());
                    if ("error".equals(((PipeNameBinding)sourceArtifact).getPort()) && XProcConstants.p_catch.equals((Object)((Step)sourceArtifact4).getType())) {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    ((Vector)object2).add(new ErrorBinding(sourceArtifact4.getXProc(), ((Step)sourceArtifact4).getNode()));
                    continue;
                }
                ((Vector)object2).add(binding);
            }
            input.clearBindings();
            Iterator iterator = ((Vector)object2).iterator();
            while (iterator.hasNext()) {
                Binding binding = (Binding)iterator.next();
                input.addBinding(binding);
            }
        }
        return bl;
    }

    protected boolean checkOptionBinding(EndPoint endPoint) {
        return this.checkOptionBinding(endPoint, false);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean checkOptionBinding(EndPoint endPoint, boolean bl) {
        SourceArtifact sourceArtifact;
        SourceArtifact sourceArtifact2;
        Object object;
        Object object3;
        boolean bl2 = true;
        this.runtime.finest(null, this.node, "Check bindings for " + endPoint + " on " + this.getName());
        if (endPoint.getBinding().size() == 0) {
            Port port = this.env.getDefaultReadablePort();
            if (port == null) {
                if (bl) {
                    object3 = new EmptyBinding(this.runtime, this.node);
                    endPoint.addBinding((Binding)object3);
                } else {
                    bl2 = false;
                    this.error("" + endPoint + " unbound on " + this.getType() + " step named " + this.getName() + " and no default readable port.", XProcConstants.staticError(32));
                }
            } else {
                object3 = port.getStep().getName();
                String object22 = port.getPort();
                object = new PipeNameBinding(this.runtime, this.node);
                ((PipeNameBinding)object).setStep((String)object3);
                ((PipeNameBinding)object).setPort(object22);
                endPoint.addBinding((Binding)object);
            }
        }
        boolean bl3 = false;
        for (Binding binding : endPoint.getBinding()) {
            if (binding.getBindingType() != 1) continue;
            object = (PipeNameBinding)binding;
            Output output = this.env.readablePort(((PipeNameBinding)object).getStep(), ((PipeNameBinding)object).getPort());
            if (output == null) {
                sourceArtifact2 = this.env.visibleStep(((PipeNameBinding)object).getStep());
                if ("error".equals(((PipeNameBinding)object).getPort()) && XProcConstants.p_catch.equals((Object)((Step)sourceArtifact2).getType())) {
                    bl3 = true;
                    continue;
                }
                this.error("Unreadable port: " + ((PipeNameBinding)object).getPort() + " on " + ((PipeNameBinding)object).getStep(), XProcConstants.staticError(22));
                bl2 = false;
                continue;
            }
            if (!XProcConstants.p_variable.equals((Object)endPoint.getNode().getNodeName())) continue;
            sourceArtifact2 = this.env.visibleStep(((PipeNameBinding)object).getStep());
            sourceArtifact = ((Step)sourceArtifact2).parent;
            if (sourceArtifact != this) continue;
            throw XProcException.staticError(19, endPoint.getNode(), "Variable binding to " + ((PipeNameBinding)object).getPort() + " on " + ((PipeNameBinding)object).getStep() + " not allowed.");
        }
        if (bl3) {
            object3 = new Vector();
            Object var6_10 = null;
            for (Binding binding : endPoint.getBinding()) {
                bl3 = false;
                if (binding.getBindingType() == 1 && (sourceArtifact = this.env.readablePort(((PipeNameBinding)(sourceArtifact2 = (PipeNameBinding)binding)).getStep(), ((PipeNameBinding)sourceArtifact2).getPort())) == null) {
                    Step step = this.env.visibleStep(((PipeNameBinding)sourceArtifact2).getStep());
                    if ("error".equals(((PipeNameBinding)sourceArtifact2).getPort()) && XProcConstants.p_catch.equals((Object)step.getType())) {
                        bl3 = true;
                    }
                }
                if (bl3) {
                    void var6_11;
                    ((Vector)object3).add(new ErrorBinding(var6_11.getXProc(), var6_11.getNode()));
                    continue;
                }
                ((Vector)object3).add(binding);
            }
            endPoint.clearBindings();
            object = ((Vector)object3).iterator();
            while (object.hasNext()) {
                Binding binding = (Binding)object.next();
                endPoint.addBinding(binding);
            }
        }
        return bl2;
    }

    protected void checkForBindings(HashSet<Output> hashSet) {
        PipeNameBinding pipeNameBinding;
        Output output;
        for (Input endPoint : this.inputs()) {
            for (Binding binding : endPoint.bindings) {
                if (binding.getBindingType() != 1 || !hashSet.contains(output = this.env.readablePort((pipeNameBinding = (PipeNameBinding)binding).getStep(), pipeNameBinding.getPort()))) continue;
                hashSet.remove(output);
            }
        }
        for (Option option : this.options()) {
            for (Binding binding : option.bindings) {
                if (binding.getBindingType() != 1 || !hashSet.contains(output = this.env.readablePort((pipeNameBinding = (PipeNameBinding)binding).getStep(), pipeNameBinding.getPort()))) continue;
                hashSet.remove(output);
            }
        }
        for (Parameter parameter : this.parameters()) {
            for (Binding binding : parameter.bindings) {
                if (binding.getBindingType() != 1 || !hashSet.contains(output = this.env.readablePort((pipeNameBinding = (PipeNameBinding)binding).getStep(), pipeNameBinding.getPort()))) continue;
                hashSet.remove(output);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean orderSteps() {
        PipeNameBinding pipeNameBinding;
        boolean bl = true;
        if (this.ordered) {
            return true;
        }
        this.ordered = true;
        for (Step object22 : this.subpipeline) {
            if (object22.orderSteps()) continue;
            bl = false;
        }
        this.runtime.finest(null, this.node, "Checking step order for " + this.getName());
        if (this.getExtensionAttribute(cx_depend) != null || this.getExtensionAttribute(cx_depends) != null || this.getExtensionAttribute(cx_dependson) != null) {
            throw new XProcException(this.getNode(), "The correct spelling of the depends-on attribute is cx:depends-on.");
        }
        String string = this.getExtensionAttribute(XProcConstants.cx_depends_on);
        if (string != null) {
            Step step = this.env.visibleStep(string);
            if (step == null) {
                throw new XProcException(this.getNode(), "The value of cx:depends-on must be the name of an in-scope step: " + (String)string);
            }
            this.addDependency(string);
        }
        for (Input input : this.inputs) {
            for (Binding binding : input.getBinding()) {
                if (binding.getBindingType() != 1) continue;
                pipeNameBinding = (PipeNameBinding)binding;
                this.runtime.finest(null, this.node, this.getName() + " input " + input.getPort() + " depends on " + pipeNameBinding.getStep());
                this.addDependency(pipeNameBinding.getStep());
            }
        }
        for (Parameter parameter : this.params) {
            for (Binding binding : parameter.getBinding()) {
                if (binding.getBindingType() != 1) continue;
                pipeNameBinding = (PipeNameBinding)binding;
                this.runtime.finest(null, this.node, this.getName() + " param depends on " + pipeNameBinding.getStep());
                this.addDependency(pipeNameBinding.getStep());
            }
        }
        for (Option option : this.options) {
            for (Binding binding : option.getBinding()) {
                if (binding.getBindingType() != 1) continue;
                pipeNameBinding = (PipeNameBinding)binding;
                this.runtime.finest(null, this.node, this.getName() + " option depends on " + pipeNameBinding.getStep());
                this.addDependency(pipeNameBinding.getStep());
            }
        }
        this.checkVariables();
        Vector<Step> vector = new Vector<Step>();
        for (Step step : this.subpipeline) {
            HashSet<String> hashSet = step.getDependencies();
            boolean bl2 = true;
            for (String string2 : hashSet) {
                if (!string2.equals(this.getName())) {
                    this.runtime.finest(null, this.node, this.getName() + " step " + step.getName() + " depends on " + string2);
                    this.addDependency(string2);
                }
                if (!this.containsStep(string2)) continue;
                bl2 = false;
            }
            if (!bl2) continue;
            this.runtime.finest(null, this.node, "==> " + step.getName() + " is a graph root of " + this.getName());
            vector.add(step);
            step.depth = 0;
        }
        if (this.subpipeline.size() > 0) {
            if (vector.size() == 0) {
                this.error("No roots in " + this.getName(), XProcConstants.staticError(1));
                bl = false;
            } else {
                boolean bl3;
                int n;
                void var3_10;
                boolean bl4;
                boolean bl5 = true;
                boolean bl6 = true;
                while (bl4 && var3_10.size() > 0) {
                    Vector<Step> vector2 = new Vector<Step>();
                    for (Iterator<Step> iterator : var3_10) {
                        for (Step step : this.subpipeline) {
                            if (step.dependsOn(((Step)((Object)iterator)).getName())) {
                                this.runtime.finest(null, this.node, "XProcStep " + step.getName() + " depends on " + ((Step)((Object)iterator)).getName() + "(step.depth=" + step.depth + ", depth=" + n + ")");
                                if (step.depth < 0 || n >= step.depth) {
                                    step.depth = n;
                                    this.runtime.finest(null, this.node, step.getName() + " gets depth " + n);
                                    vector2.add(step);
                                    continue;
                                }
                                bl4 = false;
                                this.error("Loop in subpipeline: " + step.getName() + " points back to " + ((Step)((Object)iterator)).getName(), XProcConstants.staticError(1));
                                continue;
                            }
                            this.runtime.finest(null, this.node, "XProcStep " + step.getName() + " does not depend on " + ((Step)((Object)iterator)).getName());
                        }
                    }
                    Vector<Step> vector3 = vector2;
                    ++n;
                }
                if (bl4) {
                    for (Step step : this.subpipeline) {
                        if (step.depth >= 0) continue;
                        bl3 = false;
                        this.error("Closed loop in subpipeline involves: " + step.getName(), XProcConstants.staticError(1));
                    }
                }
                boolean bl7 = bl = bl && bl3;
                if (bl) {
                    Vector<Step> vector4 = new Vector<Step>();
                    for (int i = 0; i < n; ++i) {
                        for (Step step : this.subpipeline) {
                            if (step.depth != i) continue;
                            vector4.add(step);
                        }
                    }
                    this.subpipeline = vector4;
                }
            }
        }
        return bl;
    }

    public void checkVariables() {
    }

    public boolean valid() {
        boolean bl = this.validParams();
        if (!this.matchesDeclaration()) {
            bl = false;
        }
        if (!this.validOptions()) {
            bl = false;
        }
        if (!this.validBindings()) {
            bl = false;
        }
        for (Log log : this.logs) {
            Output output = this.getOutput(log.getPort());
            if (output != null) continue;
            this.error("A p:log specified for a bad port: " + log.getPort(), XProcConstants.staticError(26));
            bl = false;
        }
        if (this.env.countVisibleSteps(this.getName()) > 1) {
            this.error("Duplicate step name: " + this.getName(), XProcConstants.staticError(2));
            bl = false;
        }
        return bl;
    }

    protected void augmentIO() {
        Port port;
        DeclareStep declareStep = this.declaration;
        if (declareStep == null) {
            throw new UnsupportedOperationException("Unexpected step type.");
        }
        Hashtable<String, Input> hashtable = new Hashtable<String, Input>();
        for (Input object2 : declareStep.inputs()) {
            hashtable.put(object2.getPort(), object2);
        }
        int n = 0;
        for (Input input : this.inputs()) {
            ++n;
        }
        for (Parameter parameter : this.parameters()) {
            ++n;
        }
        for (String string : hashtable.keySet()) {
            Input input = (Input)hashtable.get(string);
            port = this.getInput(string);
            if (port == null) {
                this.runtime.finest(null, this.node, "Added " + string + " input to " + this.getName());
                port = new Input(this.runtime, this.node);
                port.setPort(string);
                ((Input)port).setParameterInput(input.getParameterInput());
                if (input.getPrimarySet()) {
                    port.setPrimary(input.getPrimary());
                }
                port.setSequence(input.getSequence());
                ((Input)port).setPosition(++n);
                this.addInput((Input)port);
                continue;
            }
            ((Input)port).setParameterInput(input.getParameterInput());
            port.setPrimary(input.getPrimary());
            port.setSequence(input.getSequence());
        }
        Hashtable<String, Output> hashtable2 = new Hashtable<String, Output>();
        for (Output output : declareStep.outputs()) {
            hashtable2.put(output.getPort(), output);
        }
        for (String string : hashtable2.keySet()) {
            port = (Output)hashtable2.get(string);
            Output output = this.getOutput(string);
            if (output != null) continue;
            this.runtime.finest(null, this.node, "Added " + string + " output to " + this.getName());
            output = new Output(this.runtime, this.node);
            output.setPort(string);
            output.setSequence(port.getSequence());
            if (port.getPrimarySet()) {
                output.setPrimary(port.getPrimary());
            }
            this.addOutput(output);
        }
    }

    protected void augmentOptions() {
        DeclareStep declareStep = this.declaration;
        if (declareStep == null) {
            throw new UnsupportedOperationException("Unexpected step type: " + this.getType());
        }
        Hashtable<QName, Option> hashtable = new Hashtable<QName, Option>();
        for (Option option : declareStep.options()) {
            hashtable.put(option.getName(), option);
        }
        for (Option option : hashtable.keySet()) {
            Option option2 = (Option)hashtable.get(option);
            Option option3 = this.getOption((QName)option);
            if (option3 == null) {
                if (option2.getSelect() == null && option2.getBinding().size() == 0) continue;
                this.addOption(option2);
                continue;
            }
            option3.setType(option2.getType(), option2.getNode());
        }
    }

    public void augment() {
        this.augmentIO();
        this.augmentOptions();
    }

    public void patchPipeBindings() {
        for (Input sourceArtifact : this.inputs) {
            this.patchInputBindings(sourceArtifact);
        }
        for (Parameter parameter : this.params) {
            this.patchInputBindings(parameter);
        }
        for (Option option : this.options) {
            this.patchInputBindings(option);
        }
        for (Variable variable : this.getVariables()) {
            this.patchInputBindings(variable);
        }
        for (Step step : this.subpipeline) {
            step.patchPipeBindings();
        }
    }

    protected void patchInputBindings(EndPoint endPoint) {
        Vector<Binding> vector = endPoint.getBinding();
        for (int i = 0; i < vector.size(); ++i) {
            Binding binding = vector.get(i);
            if (binding.getBindingType() != 1) continue;
            PipeNameBinding pipeNameBinding = (PipeNameBinding)binding;
            PipeBinding pipeBinding = new PipeBinding(this.runtime, pipeNameBinding.node);
            Output output = this.env.readablePort(pipeNameBinding.getStep(), pipeNameBinding.getPort());
            pipeBinding.setOutput(output);
            pipeBinding.setInput(endPoint);
            vector.set(i, pipeBinding);
            if (output == null) continue;
            output.addBinding(pipeBinding);
        }
    }

    protected void setEnvironment(Environment environment) {
        this.env = environment;
    }

    protected void patchEnvironment(Environment environment) {
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public String toString() {
        String string = null;
        string = this.stepName.startsWith("#") ? "anonymous step " + this.stepType : "step " + this.stepType + " named " + this.stepName;
        string = this.node.getLineNumber() > 0 ? string + " at " + this.node.getDocumentURI() + ":" + this.node.getLineNumber() : string + " in " + this.node.getDocumentURI();
        return string;
    }

    public void dump() {
        System.err.println("============================================================================");
        this.dump(0);
        System.err.println("");
    }

    protected void dump(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        if (this.getType().getNamespaceURI().equals("http://www.w3.org/ns/xproc")) {
            System.err.println(string + this.getType().getLocalName() + " " + this.getName());
        } else {
            System.err.println(string + "XProcStep " + this.getName() + " (" + this.getType() + ")");
        }
        for (Input sourceArtifact : this.inputs) {
            sourceArtifact.dump(n + 2);
        }
        for (Output output : this.outputs) {
            output.dump(n + 2);
        }
        for (Parameter parameter : this.params) {
            parameter.dump(n + 2);
        }
        for (Option option : this.options) {
            option.dump(n + 2);
        }
        for (Variable variable : this.getVariables()) {
            variable.dump(n + 2);
        }
        for (Step step : this.subpipeline) {
            step.dump(n + 2);
        }
    }
}

